/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.basic;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Partition;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.IndexList;

public class TypedPartition<T> {
    private DelaneySymbol<T> ds;
    private List<Integer> indices;
    private Partition<T> P = new Partition();
    private HashMap<T, int[]> M = new HashMap();

    public TypedPartition(DelaneySymbol<T> delaneySymbol) {
        this.ds = delaneySymbol;
        this.indices = new IndexList(delaneySymbol);
    }

    private int[] preliminaryType(T t) {
        if (!this.M.containsKey(t)) {
            int[] nArray = new int[this.ds.dim()];
            this.M.put(t, nArray);
            for (int i = 0; i < this.ds.dim(); ++i) {
                nArray[i] = -1;
            }
        }
        return this.M.get(t);
    }

    private int[] type(T t) {
        int[] nArray = this.preliminaryType(t);
        for (int i = 0; i < this.ds.dim(); ++i) {
            int n;
            if (nArray[i] >= 0) continue;
            int n2 = this.indices.get(i);
            int n3 = this.indices.get(i + 1);
            nArray[i] = n = this.ds.m(n2, n3, t);
            for (T t2 : this.ds.orbit(new IndexList(n2, n3), t)) {
                this.preliminaryType(t2)[i] = n;
            }
        }
        return nArray;
    }

    public boolean haveEqualTypes(T t, T t2) {
        int[] nArray = this.type(t);
        int[] nArray2 = this.type(t2);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean unite(T object, T object2) {
        if ((object = this.P.find(object)) == (object2 = this.P.find(object2))) {
            return true;
        }
        if (!this.haveEqualTypes(object, object2)) {
            return false;
        }
        Object object3 = this.P.clone();
        LinkedList<T> linkedList = new LinkedList<T>();
        ((Partition)object3).unite(object, object2);
        linkedList.addLast(object);
        linkedList.addLast(object2);
        while (linkedList.size() > 0) {
            object2 = linkedList.removeLast();
            object = linkedList.removeLast();
            for (int n : this.ds.indices()) {
                T t;
                T t2 = ((Partition)object3).find(this.ds.op(n, object));
                if (t2 == (t = ((Partition)object3).find(this.ds.op(n, object2)))) continue;
                if (!this.haveEqualTypes(t2, t)) {
                    return false;
                }
                ((Partition)object3).unite(t2, t);
                linkedList.addLast(t2);
                linkedList.addLast(t);
            }
        }
        this.P = object3;
        return true;
    }

    public void uniteAll() {
        IteratorAdapter<T> iteratorAdapter = this.ds.elements();
        T t = null;
        while (iteratorAdapter.hasNext()) {
            Object e = iteratorAdapter.next();
            if (t == null) {
                t = (T)e;
                continue;
            }
            this.unite(t, e);
        }
    }

    public T find(T t) {
        return this.P.find(t);
    }

    public boolean areEquivalent(T t, T t2) {
        return this.P.areEquivalent(t, t2);
    }

    public Map<T, T> representativeMap() {
        return this.P.representativeMap();
    }
}

