/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.basic;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.box.collections.Iterators;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.Subsymbol;

public class TestDSymbol
extends TestCase {
    private DSymbol ds1;
    private DSymbol ds2;
    private DSymbol ds3;

    protected void setUp() throws Exception {
        super.setUp();
        this.ds1 = new DSymbol("6:1 3 4 6,2 4 5 6,1 5 6 4:4 4,3 3");
        this.ds2 = new DSymbol("6:1 3 0 6,2 4 5 6,1 5 6 4:8 6,0 3");
        this.ds3 = new DSymbol("6:2 4 6,4 3 6,6 5 4:4 4,3");
    }

    protected void tearDown() throws Exception {
        this.ds1 = null;
        this.ds2 = null;
        this.ds3 = null;
        super.tearDown();
    }

    public void testDim() {
        Assert.assertTrue((this.ds1.dim() == 2 ? 1 : 0) != 0);
    }

    public void testSize() {
        Assert.assertTrue((this.ds1.size() == 6 ? 1 : 0) != 0);
    }

    public void testElements() {
        Assert.assertTrue((boolean)Iterators.equal(this.ds1.elements(), Iterators.range(1, 7)));
    }

    public void testIsElement() {
        Assert.assertTrue((boolean)this.ds1.hasElement(new Integer(3)));
        Assert.assertFalse((boolean)this.ds1.hasElement(new Integer(7)));
        Assert.assertFalse((boolean)this.ds1.hasElement(new Integer(0)));
    }

    public void testIndices() {
        Assert.assertTrue((boolean)Iterators.equal(this.ds1.indices(), Iterators.range(0, 3)));
    }

    public void testIsIndex() {
        Assert.assertTrue((boolean)this.ds1.hasIndex(0));
        Assert.assertTrue((boolean)this.ds1.hasIndex(2));
        Assert.assertFalse((boolean)this.ds1.hasIndex(-1));
        Assert.assertFalse((boolean)this.ds1.hasIndex(3));
    }

    public void testOpDefined() {
        Assert.assertTrue((boolean)this.ds2.definesOp(1, new Integer(1)));
        Assert.assertFalse((boolean)this.ds2.definesOp(0, new Integer(4)));
        Assert.assertFalse((boolean)this.ds2.definesOp(0, new Integer(7)));
        Assert.assertFalse((boolean)this.ds2.definesOp(-1, new Integer(1)));
    }

    public void testOp() {
        Assert.assertEquals((Object)this.ds1.op(1, new Integer(1)), (Object)new Integer(2));
        Assert.assertEquals((Object)this.ds2.op(0, new Integer(4)), (Object)new Integer(0));
        try {
            this.ds1.op(0, new Integer(7));
            TestDSymbol.fail((String)"Should raise an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ds1.op(3, new Integer(4));
            TestDSymbol.fail((String)"Should raise an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testVDefined() {
        Assert.assertTrue((boolean)this.ds2.definesV(0, 1, new Integer(2)));
        Assert.assertTrue((boolean)this.ds2.definesV(0, 2, new Integer(2)));
        Assert.assertFalse((boolean)this.ds2.definesV(1, 2, new Integer(2)));
        Assert.assertFalse((boolean)this.ds2.definesV(0, 1, new Integer(7)));
        Assert.assertFalse((boolean)this.ds2.definesV(1, 3, new Integer(1)));
    }

    public void testV() {
        Assert.assertTrue((this.ds1.v(1, 2, new Integer(1)) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.ds1.v(0, 2, new Integer(1)) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((this.ds2.v(1, 2, new Integer(2)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.ds3.v(0, 2, new Integer(3)) == 2 ? 1 : 0) != 0);
        try {
            this.ds1.v(0, 1, new Integer(7));
            TestDSymbol.fail((String)"Should raise an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ds1.v(0, 3, new Integer(4));
            TestDSymbol.fail((String)"Should raise an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructors() {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[1] = 2;
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        int[][] op = nArrayArray;
        int[][] nArrayArray2 = new int[2][];
        int[] nArray4 = new int[3];
        nArray4[1] = 6;
        nArray4[2] = 3;
        nArrayArray2[0] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[1] = 2;
        nArray5[2] = 2;
        nArrayArray2[1] = nArray5;
        int[][] v = nArrayArray2;
        String s = "2:1 2, 1 2, 2:6 3,4";
        Assert.assertEquals((String)new DSymbol(op, v).toString(), (String)new DSymbol("2:1 2, 1 2, 2:6 3,4").toString());
        String s1 = "<1.1:2:1 2, 1 2, 2:6 3,4>";
        Assert.assertEquals((String)new DSymbol(op, v).toString(), (String)new DSymbol("<1.1:2:1 2, 1 2, 2:6 3,4>").toString());
        String code = "8 3:2 8 7 6,3 4 5 6 8,1 2 8 5 7,2 4 6 8:3 4,5 3,4 3";
        DSymbol tmp = new DSymbol("8 3:2 8 7 6,3 4 5 6 8,1 2 8 5 7,2 4 6 8:3 4,5 3,4 3");
        Subsymbol<Integer> sub = new Subsymbol<Integer>(tmp, new IndexList(1, 2), new Integer(1));
        String out = "   D |  op0  op1 |  v01\n-----+-----------+------\n   1 |    2    1 |    1\n   2 |    1    5 |    1\n   3 |    3    4 |    1\n   4 |    5    3 |    1\n   5 |    4    2 |    1\n";
        Assert.assertEquals((String)"   D |  op0  op1 |  v01\n-----+-----------+------\n   1 |    2    1 |    1\n   2 |    1    5 |    1\n   3 |    3    4 |    1\n   4 |    5    3 |    1\n   5 |    4    2 |    1\n", (String)new DSymbol(sub).tabularDisplay());
        Assert.assertEquals((String)"   D |  op0  op1 |  v01\n-----+-----------+------\n   1 |    2    1 |    1\n   2 |    1    5 |    1\n   3 |    3    4 |    1\n   4 |    5    3 |    1\n   5 |    4    2 |    1\n", (String)new DSymbol(new DSymbol(sub)).tabularDisplay());
    }

    public void testToString() {
        Assert.assertEquals((String)this.ds1.toString(), (String)"<1.1:6:1 3 4 6,2 4 5 6,1 5 6 4:4 4,3 3>");
        Assert.assertEquals((String)this.ds2.toString(), (String)"<1.1:6:1 3 0 6,2 4 5 6,1 5 6 4:8 6,0 3>");
    }

    public void testClone() {
        Assert.assertEquals((String)this.ds1.toString(), (String)this.ds1.clone().toString());
        Assert.assertEquals((String)this.ds2.toString(), (String)this.ds2.clone().toString());
    }

    public void testDual() {
        Assert.assertEquals((String)this.ds1.dual().toString(), (String)"<1.1:6:1 5 6 4,2 4 5 6,1 3 4 6:3 3,4 4>");
        Assert.assertEquals((String)this.ds2.dual().toString(), (String)"<1.1:6:1 5 6 4,2 4 5 6,1 3 0 6:0 3,8 6>");
    }
}

