/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.basic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.IndexList;

public class DSymbol
extends DelaneySymbol<Integer>
implements Cloneable {
    private int dim;
    private int size;
    private int[][] op;
    private int[][] v;
    private String name = null;

    private DSymbol() {
    }

    private void assertConsistency() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.dim < 0) {
            stringBuffer.append("\n : the dimension is negative.");
        }
        if (this.size < 0) {
            stringBuffer.append("\n : the size is negative.");
        }
        if (this.dim >= 0 && this.op.length < this.dim + 1) {
            stringBuffer.append("\n : found " + this.op.length + " neighbors per element,");
            stringBuffer.append(" required " + (this.dim + 1) + ".");
        }
        if (this.dim >= 0 && this.v.length < this.dim) {
            stringBuffer.append("\n : found " + this.v.length + " branching limits per");
            stringBuffer.append(" element, required " + (this.dim + 1) + ".");
        }
        for (n5 = 0; n5 <= this.dim; ++n5) {
            if (this.op[n5].length < this.size + 1) {
                stringBuffer.append("\n : found " + (this.op[n5].length - 1) + " neighbors");
                stringBuffer.append(" for index " + n5 + ", required " + this.size + ".");
            }
            if (n5 >= this.dim || this.v[n5].length >= this.size + 1) continue;
            stringBuffer.append("\n : found " + (this.v[n5].length - 1) + " branching");
            stringBuffer.append(" limits for index " + n5 + ", required " + this.size);
            stringBuffer.append(".");
        }
        if (stringBuffer.length() == 0) {
            for (n5 = 0; n5 <= this.dim; ++n5) {
                for (n4 = 1; n4 <= this.size; ++n4) {
                    int n6 = this.op[n5][n4];
                    if (n6 != 0) {
                        if (n6 < 0 || n6 > this.size) {
                            stringBuffer.append("\n : op[" + n5 + "][" + n4 + "] = ");
                            stringBuffer.append(n6 + " is outside the allowed range");
                            stringBuffer.append(" 1.." + this.size + ".");
                            n6 = 0;
                        } else if (this.op[n5][n6] != n4) {
                            n3 = this.op[n5][n6];
                            stringBuffer.append("\n : op[" + n5 + "][" + n4 + "] = " + n6);
                            stringBuffer.append(", but op[" + n5 + "][" + n6 + "] = ");
                            stringBuffer.append(n3 + ".");
                        }
                    }
                    if (n5 < this.dim) {
                        n3 = this.v[n5][n4];
                        if (n3 < 0) {
                            stringBuffer.append("\n : v[" + n5 + "][" + n4 + "] = " + n3);
                            stringBuffer.append(" is negative.");
                        } else if (n6 >= n4 && n3 != (n2 = this.v[n5][n6])) {
                            stringBuffer.append("\n : v[" + n5 + "][" + n4 + "] = ");
                            stringBuffer.append(n3 + ", but v[" + n5 + "][" + n6);
                            stringBuffer.append("] = " + n2 + ".");
                        }
                    }
                    if (n5 <= 0 || n6 < n4 || (n2 = this.v[n3 = n5 - 1][n4]) == (n = this.v[n3][n6])) continue;
                    stringBuffer.append("\n : v[" + n3 + "][" + n4 + "] = " + n2);
                    stringBuffer.append(", but v[" + n3 + "][" + n6 + "] = ");
                    stringBuffer.append(n + ".");
                }
            }
        }
        if (stringBuffer.length() == 0) {
            for (n5 = 0; n5 <= this.dim; ++n5) {
                for (n4 = n5 + 2; n4 <= this.dim; ++n4) {
                    Iterator iterator = this.orbitReps(new IndexList(n5, n4)).iterator();
                    while (iterator.hasNext()) {
                        n3 = (Integer)iterator.next();
                        n2 = this.op[n4][this.op[n5][n3]];
                        if (n2 == (n = this.op[n5][this.op[n4][n3]]) || n2 == 0 || n == 0) continue;
                        stringBuffer.append("\n : the " + n5 + "," + n4 + "-orbit");
                        stringBuffer.append(" at " + n3 + " is too large.");
                    }
                }
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "Consistency check failed for " + this.toString());
            throw new RuntimeException(stringBuffer.toString());
        }
    }

    public DSymbol(int[][] nArray, int[][] nArray2) {
        this.dim = nArray.length - 1;
        this.size = nArray[0].length - 1;
        this.op = (int[][])nArray.clone();
        this.v = (int[][])nArray2.clone();
        this.assertConsistency();
    }

    public DSymbol(String string) {
        int n;
        int n2;
        String[] stringArray;
        int n3;
        String[] stringArray2;
        String string2 = string.trim();
        int n4 = 0;
        int n5 = string2.length();
        if (string2.startsWith("<")) {
            ++n4;
        }
        if (string2.endsWith(">")) {
            --n5;
        }
        int n6 = (stringArray2 = string2.substring(n4, n5).split(":")).length >= 4 ? stringArray2.length - 3 : 0;
        String[] stringArray3 = stringArray2[n6].trim().split("\\s+");
        this.size = Integer.parseInt(stringArray3[0]);
        this.dim = stringArray3.length > 1 ? Integer.parseInt(stringArray3[1]) : 2;
        this.op = new int[this.dim + 1][this.size + 1];
        this.v = new int[this.dim][this.size + 1];
        if (this.size == 0 || this.dim == 0) {
            return;
        }
        stringArray3 = stringArray2[n6 + 1].split(",");
        for (n3 = 0; n3 <= this.dim; ++n3) {
            stringArray = stringArray3[n3].trim().split("\\s+");
            n2 = 0;
            for (int i = 1; i <= this.size; ++i) {
                if (this.op[n3][i] != 0) continue;
                if ((n = Integer.parseInt(stringArray[n2++])) < 0 || n > this.size) {
                    String string3 = "illegal " + n3 + "-image: " + n;
                    throw new IllegalArgumentException(string3);
                }
                if (this.op[n3][n] != 0) {
                    String string4 = "element " + n + " already has a " + n3 + "-image";
                    throw new IllegalArgumentException(string4);
                }
                this.op[n3][i] = n;
                if (n == 0) continue;
                this.op[n3][n] = i;
            }
        }
        stringArray3 = stringArray2[n6 + 2].split(",");
        for (n3 = 0; n3 < this.dim; ++n3) {
            stringArray = stringArray3[n3].trim().split("\\s+");
            n2 = 0;
            boolean[] blArray = new boolean[this.size + 1];
            for (n = 1; n <= this.size; ++n) {
                int n7;
                if (blArray[n]) continue;
                if ((n7 = Integer.parseInt(stringArray[n2++])) < 0) {
                    String string5 = "illegal degree: " + n7;
                    throw new IllegalArgumentException(string5);
                }
                int n8 = this.r(n3, n3 + 1, new Integer(n));
                if (n7 % n8 != 0) {
                    String string6 = "degree " + n7 + " not a multiple of " + n8 + " at i=" + n3 + ", D = " + n;
                    throw new IllegalArgumentException(string6);
                }
                int n9 = n7 / n8;
                int n10 = n;
                do {
                    if (this.op[n3][n10] != 0) {
                        n10 = this.op[n3][n10];
                    }
                    this.v[n3][n10] = n9;
                    blArray[n10] = true;
                    if (this.op[n3 + 1][n10] != 0) {
                        n10 = this.op[n3 + 1][n10];
                    }
                    this.v[n3][n10] = n9;
                    blArray[n10] = true;
                } while (n10 != n);
            }
        }
        this.assertConsistency();
    }

    public <T> DSymbol(DelaneySymbol<T> delaneySymbol) {
        IndexList indexList;
        int n;
        int n2;
        Object object2;
        this.dim = delaneySymbol.dim();
        this.size = delaneySymbol.size();
        if (delaneySymbol instanceof DSymbol) {
            this.op = ((DSymbol)delaneySymbol).op;
            this.v = ((DSymbol)delaneySymbol).v;
            return;
        }
        this.op = new int[this.dim() + 1][this.size() + 1];
        this.v = new int[this.dim()][this.size() + 1];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap<T, Integer> hashMap = new HashMap<T, Integer>();
        int[] nArray = new int[this.dim() + 1];
        arrayList.add(null);
        for (Object object2 : delaneySymbol.elements()) {
            hashMap.put(object2, arrayList.size());
            arrayList.add(object2);
        }
        int n3 = 0;
        object2 = delaneySymbol.indices().iterator();
        while (object2.hasNext()) {
            nArray[n3] = n2 = ((Integer)object2.next()).intValue();
            ++n3;
        }
        for (n3 = 1; n3 <= this.size(); ++n3) {
            object2 = arrayList.get(n3);
            for (n2 = 0; n2 <= this.dim(); ++n2) {
                n = nArray[n2];
                if (!delaneySymbol.definesOp(n, object2)) continue;
                indexList = delaneySymbol.op(n, object2);
                this.op[n2][n3] = (Integer)hashMap.get(indexList);
            }
        }
        for (int i = 0; i < this.dim(); ++i) {
            n2 = nArray[i];
            n = nArray[i + 1];
            indexList = new IndexList(n2, n);
            for (T t : delaneySymbol.orbitReps(indexList)) {
                if (!delaneySymbol.definesV(n2, n, t)) continue;
                int n4 = delaneySymbol.v(n2, n, t);
                for (T t2 : delaneySymbol.orbit(indexList, t)) {
                    this.v[i][((Integer)hashMap.get(t2)).intValue()] = n4;
                }
            }
        }
        this.assertConsistency();
    }

    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.getName() != null) {
            stringBuffer.append("#@ name ");
            stringBuffer.append(this.getName());
            stringBuffer.append('\n');
        }
        stringBuffer.append("<1.1:");
        stringBuffer.append(this.size);
        if (this.dim() != 2) {
            stringBuffer.append(" ");
            stringBuffer.append(this.dim);
        }
        stringBuffer.append(":");
        for (n2 = 0; n2 <= this.dim; ++n2) {
            for (int i = 1; i <= this.size; ++i) {
                n = this.op[n2][i];
                if (n != 0 && n < i) continue;
                if (i == 1) {
                    if (n2 > 0) {
                        stringBuffer.append(",");
                    }
                } else {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(n);
            }
        }
        stringBuffer.append(":");
        for (n2 = 0; n2 < this.dim; ++n2) {
            boolean[] blArray = new boolean[this.size + 1];
            for (n = 1; n <= this.size; ++n) {
                if (blArray[n]) continue;
                int n3 = this.m(n2, n2 + 1, new Integer(n));
                if (n == 1) {
                    if (n2 > 0) {
                        stringBuffer.append(",");
                    }
                } else {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(n3);
                int n4 = n;
                do {
                    if (this.op[n2][n4] != 0) {
                        n4 = this.op[n2][n4];
                    }
                    blArray[n4] = true;
                    if (this.op[n2 + 1][n4] != 0) {
                        n4 = this.op[n2 + 1][n4];
                    }
                    blArray[n4] = true;
                } while (n4 != n);
            }
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    @Override
    public int dim() {
        return this.dim;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public IteratorAdapter<Integer> elements() {
        return Iterators.range(1, this.size() + 1);
    }

    @Override
    public boolean hasElement(Integer n) {
        return n != null && n >= 1 && n <= this.size();
    }

    @Override
    public IteratorAdapter<Integer> indices() {
        return Iterators.range(0, this.dim() + 1);
    }

    @Override
    public boolean hasIndex(int n) {
        return n >= 0 && n <= this.dim();
    }

    @Override
    public boolean definesOp(int n, Integer n2) {
        return this.hasElement(n2) && this.hasIndex(n) && this.op[n][n2] != 0;
    }

    @Override
    public Integer op(int n, Integer n2) {
        if (!this.hasElement(n2)) {
            throw new IllegalArgumentException("not an element: " + n2);
        }
        if (!this.hasIndex(n)) {
            throw new IllegalArgumentException("invalid index: " + n);
        }
        return this.op[n][n2];
    }

    @Override
    public boolean definesV(int n, int n2, Integer n3) {
        return this.hasElement(n3) && this.hasIndex(n) && this.hasIndex(n2) && (Math.abs(n - n2) != 1 || this.v[Math.min(n, n2)][n3] != 0);
    }

    @Override
    public int v(int n, int n2, Integer n3) {
        if (!this.hasElement(n3)) {
            throw new IllegalArgumentException("not an element: " + n3);
        }
        if (!this.hasIndex(n)) {
            throw new IllegalArgumentException("invalid index: " + n);
        }
        if (!this.hasIndex(n2)) {
            throw new IllegalArgumentException("invalid index: " + n2);
        }
        int n4 = n2 == n + 1 ? this.v[n][n3] : (n2 == n - 1 ? this.v[n2][n3] : (n != n2 && this.op(n, n3).equals(this.op(n2, n3)) ? 2 : 1));
        return this.normalizedV(n4);
    }

    public Object clone() {
        DSymbol dSymbol = new DSymbol();
        dSymbol.dim = this.dim;
        dSymbol.size = this.size;
        dSymbol.op = new int[this.dim + 1][this.size + 1];
        dSymbol.v = new int[this.dim][this.size + 1];
        for (int i = 1; i <= this.size; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                dSymbol.op[j][i] = this.op[j][i];
                dSymbol.v[j][i] = this.v[j][i];
            }
            dSymbol.op[this.dim][i] = this.op[this.dim][i];
        }
        return dSymbol;
    }

    public DSymbol dual() {
        DSymbol dSymbol = new DSymbol();
        dSymbol.dim = this.dim;
        dSymbol.size = this.size;
        dSymbol.op = new int[this.dim + 1][this.size + 1];
        dSymbol.v = new int[this.dim][this.size + 1];
        for (int i = 1; i <= this.size; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                dSymbol.op[j][i] = this.op[this.dim - j][i];
                dSymbol.v[j][i] = this.v[this.dim - j - 1][i];
            }
            dSymbol.op[this.dim][i] = this.op[0][i];
        }
        return dSymbol;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }
}

