/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.basic;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.collections.Pair;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.IndexList;

public class DSMorphism<S, T> {
    private final Map<S, T> src2img;
    final Map<T, S> img2src;
    private final boolean bijective;

    public DSMorphism(DelaneySymbol<S> delaneySymbol, DelaneySymbol<T> delaneySymbol2, S s, T t) {
        try {
            delaneySymbol.size();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationException("source must be finite");
        }
        if (!delaneySymbol.isConnected()) {
            throw new UnsupportedOperationException("source must be connected");
        }
        if (!Iterators.equal(delaneySymbol.indices(), delaneySymbol2.indices())) {
            throw new UnsupportedOperationException("index lists must be equal");
        }
        if (s == null || t == null) {
            throw new IllegalArgumentException("elements must not be null");
        }
        IndexList indexList = new IndexList(delaneySymbol);
        boolean bl = delaneySymbol2.isConnected();
        this.src2img = new HashMap<S, T>();
        this.img2src = new HashMap<T, S>();
        this.src2img.put(s, t);
        this.img2src.put(t, s);
        LinkedList<Pair<S, T>> linkedList = new LinkedList<Pair<S, T>>();
        linkedList.addLast(new Pair<S, T>(s, t));
        while (linkedList.size() > 0) {
            Pair pair = (Pair)linkedList.removeFirst();
            Object f = pair.getFirst();
            Object s2 = pair.getSecond();
            for (int n : delaneySymbol.indices()) {
                T t2;
                S s3 = delaneySymbol.op(n, f);
                if (this.correspond(s3, t2 = delaneySymbol2.op(n, s2))) continue;
                if (this.src2img.containsKey(s3)) {
                    throw new IllegalArgumentException("no such morphism");
                }
                if (this.img2src.containsKey(t2)) {
                    bl = false;
                }
                for (int i = 0; i < delaneySymbol.dim(); ++i) {
                    int n2;
                    int n3 = (Integer)indexList.get(i);
                    if (delaneySymbol.m(n3, n2 = ((Integer)indexList.get(i + 1)).intValue(), s3) == delaneySymbol2.m(n3, n2, t2)) continue;
                    throw new IllegalArgumentException("no such morphism");
                }
                this.src2img.put(s3, t2);
                this.img2src.put(t2, s3);
                linkedList.addLast(new Pair<S, T>(s3, t2));
            }
        }
        this.bijective = bl;
    }

    public DSMorphism(DelaneySymbol<S> delaneySymbol, DelaneySymbol<T> delaneySymbol2) {
        this(delaneySymbol, delaneySymbol2, delaneySymbol.elements().next(), delaneySymbol2.elements().next());
    }

    public DSMorphism(DSMorphism<S, T> dSMorphism) {
        this.src2img = dSMorphism.src2img;
        this.img2src = dSMorphism.img2src;
        this.bijective = dSMorphism.bijective;
    }

    private DSMorphism(DSMorphism<T, S> dSMorphism, boolean bl) {
        if (!dSMorphism.isIsomorphism()) {
            throw new IllegalArgumentException("not invertible");
        }
        this.src2img = dSMorphism.img2src;
        this.img2src = dSMorphism.src2img;
        this.bijective = true;
    }

    public DSMorphism<T, S> inverse() {
        return new DSMorphism<S, T>(this, true);
    }

    private boolean correspond(S s, T t) {
        if (t == null) {
            return s == null;
        }
        return t.equals(this.src2img.get(s));
    }

    public boolean isIsomorphism() {
        return this.bijective;
    }

    public S getASource(T t) {
        return this.img2src.get(t);
    }

    public int size() {
        return this.src2img.size();
    }

    public T get(S s) {
        return this.src2img.get(s);
    }

    public static <T> List<DSMorphism<T, T>> automorphisms(DelaneySymbol<T> delaneySymbol) {
        LinkedList<DSMorphism<T, T>> linkedList = new LinkedList<DSMorphism<T, T>>();
        IteratorAdapter<T> iteratorAdapter = delaneySymbol.elements();
        if (iteratorAdapter.hasNext()) {
            Object e = iteratorAdapter.next();
            linkedList.add(new DSMorphism<T, T>(delaneySymbol, delaneySymbol, e, e));
            while (iteratorAdapter.hasNext()) {
                Object e2 = iteratorAdapter.next();
                try {
                    linkedList.add(new DSMorphism<T, T>(delaneySymbol, delaneySymbol, e, e2));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return linkedList;
    }
}

