/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.numbers;

import org.gavrog.jane.numbers.Fraction;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;

public abstract class Rational
extends Real {
    public abstract Whole numerator();

    public abstract Whole denominator();

    private static Rational makeFast(Whole whole, Whole whole2) {
        if (whole2.isZero()) {
            throw new ArithmeticException("zero denominator");
        }
        if (whole2.isOne() || whole.isZero()) {
            return whole;
        }
        return new Fraction(whole, whole2, false);
    }

    public static Rational make(Whole whole, Whole whole2) {
        Whole whole3 = whole.gcd(whole2);
        if (whole2.isNegative()) {
            whole3 = (Whole)whole3.negative();
        }
        if (!whole3.isOne()) {
            whole = whole.div(whole3);
            whole2 = whole2.div(whole3);
        }
        return Rational.makeFast(whole, whole2);
    }

    public static Rational make(int n, int n2) {
        return Rational.make(new Whole(n), new Whole(n2));
    }

    @Override
    public boolean isExact() {
        return true;
    }

    public boolean isInteger() {
        return this.denominator().equals(Whole.ONE);
    }

    @Override
    public IArithmetic floor() {
        return this.numerator().div(this.denominator());
    }

    @Override
    public int sign() {
        return this.numerator().sign();
    }

    @Override
    public IArithmetic inverse() {
        Whole whole = this.numerator();
        Whole whole2 = this.denominator();
        if (whole2.isNegative()) {
            whole2 = (Whole)whole2.negative();
            whole = (Whole)whole.negative();
        }
        return Rational.makeFast(whole2, whole);
    }

    @Override
    public boolean isZero() {
        return this.numerator().isZero();
    }

    @Override
    public boolean isOne() {
        return this.numerator().isOne() && this.denominator().isOne();
    }

    @Override
    public double doubleValue() {
        return this.numerator().doubleValue() / this.denominator().doubleValue();
    }

    @Override
    public long longValue() {
        return this.numerator().div(this.denominator()).longValue();
    }

    @Override
    public String toString() {
        return this.numerator().toString() + "/" + this.denominator().toString();
    }

    @Override
    public IArithmetic negative() {
        return new Fraction((Whole)this.numerator().negative(), this.denominator(), false);
    }

    @Override
    public IArithmetic abs() {
        return new Fraction((Whole)this.numerator().abs(), this.denominator(), false);
    }

    @Override
    public int hashCode() {
        return 31 * this.numerator().hashCode() + this.denominator().hashCode();
    }

    @Override
    public IArithmetic plus(Object object) {
        if (object instanceof Rational) {
            Whole whole = this.numerator();
            Whole whole2 = this.denominator();
            Whole whole3 = ((Rational)object).numerator();
            Whole whole4 = ((Rational)object).denominator();
            Whole whole5 = whole2.gcd(whole4);
            Whole whole6 = (Whole)whole4.div(whole5).times(whole);
            Whole whole7 = (Whole)whole2.div(whole5).times(whole3);
            Whole whole8 = (Whole)whole6.plus(whole7);
            Whole whole9 = (Whole)whole2.div(whole5).times(whole4);
            return Rational.make(whole8, whole9);
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rplus(this);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IArithmetic minus(Object object) {
        if (object instanceof Rational) {
            Whole whole = this.numerator();
            Whole whole2 = this.denominator();
            Whole whole3 = ((Rational)object).numerator();
            Whole whole4 = ((Rational)object).denominator();
            Whole whole5 = whole2.gcd(whole4);
            Whole whole6 = (Whole)whole4.div(whole5).times(whole);
            Whole whole7 = (Whole)whole2.div(whole5).times(whole3);
            Whole whole8 = (Whole)whole6.minus(whole7);
            Whole whole9 = (Whole)whole2.div(whole5).times(whole4);
            return Rational.make(whole8, whole9);
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rminus(this);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IArithmetic times(Object object) {
        if (object instanceof Rational) {
            Whole whole;
            Whole whole2 = this.numerator();
            Whole whole3 = this.denominator();
            Whole whole4 = ((Rational)object).numerator();
            Whole whole5 = ((Rational)object).denominator();
            Whole whole6 = whole2.gcd(whole5);
            if (!whole6.isOne()) {
                whole2 = whole2.div(whole6);
                whole5 = whole5.div(whole6);
            }
            if (!(whole = whole4.gcd(whole3)).isOne()) {
                whole4 = whole4.div(whole);
                whole3 = whole3.div(whole);
            }
            Whole whole7 = (Whole)whole2.times(whole4);
            Whole whole8 = (Whole)whole3.times(whole5);
            if (whole8.isNegative()) {
                whole8 = (Whole)whole8.negative();
                whole7 = (Whole)whole7.negative();
            }
            return Rational.makeFast(whole7, whole8);
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rtimes(this);
        }
        throw new IllegalArgumentException();
    }

    public IArithmetic raisedTo(Whole whole) {
        if (whole.isNegative()) {
            return ((Rational)this.inverse()).raisedTo((Whole)whole.abs());
        }
        return Rational.makeFast((Whole)this.numerator().raisedTo(whole), (Whole)this.denominator().raisedTo(whole));
    }
}

