/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.numbers;

import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Rational;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;

public class FloatingPoint
extends Real {
    private double val;
    public static final FloatingPoint ZERO = new FloatingPoint(0.0);
    public static final FloatingPoint ONE = new FloatingPoint(1.0);

    public FloatingPoint(double d) {
        this.val = d;
    }

    public FloatingPoint(Rational rational) {
        this.val = rational.doubleValue();
    }

    @Override
    public IArithmetic zero() {
        return ZERO;
    }

    @Override
    public IArithmetic one() {
        return ONE;
    }

    @Override
    public IArithmetic floor() {
        return new Whole((long)Math.floor(this.val));
    }

    @Override
    public int sign() {
        return this.val == 0.0 ? 0 : (this.val > 0.0 ? 1 : -1);
    }

    @Override
    public boolean isExact() {
        return false;
    }

    @Override
    public boolean isPositive() {
        return this.val > 0.0;
    }

    @Override
    public boolean isNegative() {
        return this.val < 0.0;
    }

    @Override
    public boolean isZero() {
        return this.val == 0.0;
    }

    @Override
    public boolean isOne() {
        return this.val == 1.0;
    }

    @Override
    public double doubleValue() {
        return this.val;
    }

    @Override
    public long longValue() {
        return (long)this.val;
    }

    @Override
    public String toString() {
        return Double.toString(this.val);
    }

    @Override
    public IArithmetic negative() {
        return new FloatingPoint(-this.val);
    }

    @Override
    public IArithmetic inverse() {
        return new FloatingPoint(1.0 / this.val);
    }

    @Override
    public IArithmetic abs() {
        return new FloatingPoint(Math.abs(this.val));
    }

    @Override
    public int hashCode() {
        return new Double(this.val).hashCode();
    }

    @Override
    public IArithmetic plus(Object object) {
        if (object instanceof FloatingPoint) {
            return new FloatingPoint(this.val + ((FloatingPoint)object).val);
        }
        if (object instanceof Rational) {
            return new FloatingPoint(this.val + ((Rational)object).doubleValue());
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rplus(this);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IArithmetic minus(Object object) {
        if (object instanceof FloatingPoint) {
            return new FloatingPoint(this.val - ((FloatingPoint)object).val);
        }
        if (object instanceof Rational) {
            return new FloatingPoint(this.val - ((Rational)object).doubleValue());
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rminus(this);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IArithmetic times(Object object) {
        if (object instanceof FloatingPoint) {
            return new FloatingPoint(this.val * ((FloatingPoint)object).val);
        }
        if (object instanceof Rational) {
            return new FloatingPoint(this.val * ((Rational)object).doubleValue());
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rtimes(this);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IArithmetic dividedBy(Object object) {
        if (object instanceof FloatingPoint) {
            return new FloatingPoint(this.val / ((FloatingPoint)object).val);
        }
        if (object instanceof Rational) {
            return new FloatingPoint(this.val / ((Rational)object).doubleValue());
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rdividedBy(this);
        }
        throw new IllegalArgumentException();
    }
}

