/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.fpgroups;

import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.jane.fpgroups.FiniteAlphabet;
import org.gavrog.jane.fpgroups.FpGroup;
import org.gavrog.jane.fpgroups.FreeWord;
import org.gavrog.jane.numbers.Whole;

public class TestFpGroup
extends TestCase {
    private FiniteAlphabet A;
    private FpGroup G;

    protected void setUp() throws Exception {
        super.setUp();
        this.A = new FiniteAlphabet<String>(new String[]{"a", "b", "c"});
        this.G = new FpGroup(this.A, new String[]{"a*b^-1*a^-1*b", "a^-1*c^-1*a*c", "b*c*b^-1*c^-1"});
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testToString() {
        Assert.assertEquals((String)"FpGroup(Alphabet({\"a\", \"b\", \"c\"}), {a*b*a^-1*b^-1, a*c*a^-1*c^-1, b*c*b^-1*c^-1})", (String)this.G.toString());
    }

    public void testGetAlphabet() {
        Assert.assertEquals((Object)this.A, this.G.getAlphabet());
    }

    public void testGetIdentity() {
        Assert.assertEquals(FreeWord.parsedWord(this.A, "*"), this.G.getIdentity());
    }

    public void testGetGenerators() {
        List gens = this.G.getGenerators();
        Assert.assertTrue((gens.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)gens.contains(FreeWord.parsedWord(this.A, "a")));
        Assert.assertTrue((boolean)gens.contains(FreeWord.parsedWord(this.A, "b")));
        Assert.assertTrue((boolean)gens.contains(FreeWord.parsedWord(this.A, "c")));
    }

    public void testGetRelators() {
        List gens = this.G.getRelators();
        Assert.assertTrue((gens.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)gens.contains(FreeWord.parsedWord(this.A, "a*b*a^-1*b^-1")));
        Assert.assertTrue((boolean)gens.contains(FreeWord.parsedWord(this.A, "a*c*a^-1*c^-1")));
        Assert.assertTrue((boolean)gens.contains(FreeWord.parsedWord(this.A, "a*c*a^-1*c^-1")));
    }

    public void testTrivialGroup() {
        FiniteAlphabet<String> B = new FiniteAlphabet<String>(new String[0]);
        FpGroup I = new FpGroup(B, new String[0]);
        Assert.assertEquals((int)0, (int)I.getGenerators().size());
        Assert.assertEquals((int)0, (int)I.getRelators().size());
        Assert.assertNotNull((Object)I.toString());
        Assert.assertNotNull(I.getIdentity());
        Assert.assertEquals(new LinkedList(), I.abelianInvariants());
    }

    public void testGcdex() {
        this.testGcdex(5, 12, 1);
        this.testGcdex(111, -740, 37);
        this.testGcdex(-6100, 9870, 10);
    }

    public void testGcdex(int a, int b, int expected) {
        Whole m = new Whole(a);
        Whole n = new Whole(b);
        Whole x = new Whole(expected);
        Whole[] result = FpGroup.gcdex(m, n);
        Assert.assertEquals((Object)x, (Object)result[0]);
        Assert.assertEquals((Object)x, (Object)result[1].times(m).plus(result[2].times(n)));
        Assert.assertEquals((Object)Whole.ZERO, (Object)result[3].times(m).plus(result[4].times(n)));
    }

    private static List makeList(int[] entries) {
        LinkedList<Whole> res = new LinkedList<Whole>();
        int i = 0;
        while (i < entries.length) {
            res.add(new Whole(entries[i]));
            ++i;
        }
        return res;
    }

    public void testAbelianInvariants() {
        List expected = TestFpGroup.makeList(new int[3]);
        List<Whole> invars = this.G.abelianInvariants();
        Assert.assertEquals((Object)expected, invars);
        FpGroup H = new FpGroup(this.A, new String[]{"a^3*b*c^4*a^-1*c^-1*b", "c^7*b^-2*a*b^5*c^-1*a^2*c^-2", "(a*b*c)^2*c*b^-1"});
        Assert.assertEquals(new LinkedList(), H.abelianInvariants());
    }
}

