/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.fpgroups;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.fpgroups.FiniteAlphabet;
import org.gavrog.jane.fpgroups.FreeWord;
import org.gavrog.jane.numbers.Whole;

public class FpGroup<E> {
    private static final Whole ZERO = Whole.ZERO;
    private static final Whole ONE = Whole.ONE;
    private final FiniteAlphabet<E> alphabet;
    private final List<FreeWord<E>> relators;

    public <X extends E> FpGroup(FpGroup<X> fpGroup) {
        this(fpGroup.getAlphabet(), fpGroup.getRelators());
    }

    public FpGroup(FiniteAlphabet<? extends E> finiteAlphabet) {
        this(finiteAlphabet, new FreeWord[0]);
    }

    public <X extends E> FpGroup(FiniteAlphabet<X> finiteAlphabet, String[] stringArray) {
        this(finiteAlphabet, FpGroup.asWords(finiteAlphabet, stringArray));
    }

    private static <X> List<FreeWord<X>> asWords(FiniteAlphabet<X> finiteAlphabet, String[] stringArray) {
        LinkedList<FreeWord<X>> linkedList = new LinkedList<FreeWord<X>>();
        for (int i = 0; i < stringArray.length; ++i) {
            linkedList.add(FreeWord.parsedWord(finiteAlphabet, stringArray[i]));
        }
        return linkedList;
    }

    public <X extends E, Y extends X> FpGroup(FiniteAlphabet<X> finiteAlphabet, FreeWord<Y>[] freeWordArray) {
        this(finiteAlphabet, Arrays.asList(freeWordArray));
    }

    public <X extends E, Y extends X> FpGroup(FiniteAlphabet<X> finiteAlphabet, List<FreeWord<Y>> list) {
        FiniteAlphabet<X> finiteAlphabet2 = finiteAlphabet;
        LinkedList<FreeWord<Y>> linkedList = new LinkedList<FreeWord<Y>>();
        HashSet<FreeWord<Y>> hashSet = new HashSet<FreeWord<Y>>();
        for (FreeWord<Y> freeWord : list) {
            FreeWord<Y> freeWord2 = FpGroup.relatorRepresentative(freeWord);
            if (freeWord2.length() <= 0 || hashSet.contains(freeWord2)) continue;
            linkedList.add(freeWord2);
            hashSet.add(freeWord2);
        }
        Collections.sort(linkedList);
        this.relators = Collections.unmodifiableList(linkedList);
        this.alphabet = finiteAlphabet2;
    }

    public static <X> FreeWord<X> relatorRepresentative(FreeWord<X> freeWord) {
        int n = freeWord.length();
        FreeWord<X> freeWord2 = freeWord;
        for (int i = 0; i < n; ++i) {
            FreeWord<X> freeWord3;
            FreeWord<X> freeWord4 = freeWord.subword(i, n).times(freeWord.subword(0, i));
            if (freeWord2.compareTo(freeWord4) > 0) {
                freeWord2 = freeWord4;
            }
            if (freeWord2.compareTo(freeWord3 = freeWord4.inverse()) <= 0) continue;
            freeWord2 = freeWord3;
        }
        return freeWord2;
    }

    public FiniteAlphabet<E> getAlphabet() {
        return this.alphabet;
    }

    public List<FreeWord<E>> getGenerators() {
        FiniteAlphabet<E> finiteAlphabet = this.getAlphabet();
        ArrayList<FreeWord<E>> arrayList = new ArrayList<FreeWord<E>>();
        for (E e : finiteAlphabet.getNameList()) {
            arrayList.add(new FreeWord<E>(finiteAlphabet, finiteAlphabet.nameToLetter(e)));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<FreeWord<E>> getRelators() {
        return this.relators;
    }

    public FreeWord<E> getIdentity() {
        return new FreeWord<E>(this.getAlphabet());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("FpGroup(");
        stringBuffer.append(this.getAlphabet());
        stringBuffer.append(", {");
        boolean bl = true;
        for (FreeWord<E> freeWord : this.getRelators()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(freeWord);
            bl = false;
        }
        stringBuffer.append("})");
        return stringBuffer.toString();
    }

    private Whole[][] relatorMatrixAsArray() {
        int n = this.getGenerators().size();
        List<FreeWord<E>> list = this.getRelators();
        int n2 = list.size();
        Whole[][] wholeArray = new Whole[n2][n];
        for (int i = 0; i < n2; ++i) {
            int n3;
            FreeWord<E> freeWord = list.get(i);
            int[] nArray = new int[n];
            for (n3 = 0; n3 < freeWord.length(); ++n3) {
                int n4 = freeWord.getLetter(n3) - 1;
                if (freeWord.getSign(n3) > 0) {
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + 1;
                    continue;
                }
                int n6 = n4;
                nArray[n6] = nArray[n6] - 1;
            }
            for (n3 = 0; n3 < n; ++n3) {
                wholeArray[i][n3] = new Whole(nArray[n3]);
            }
        }
        return wholeArray;
    }

    public Matrix relatorMatrix() {
        return new Matrix(this.relatorMatrixAsArray());
    }

    public List<Whole> abelianInvariants() {
        int n = this.getGenerators().size();
        List<FreeWord<E>> list = this.getRelators();
        int n2 = list.size();
        int n3 = Math.min(n2, n);
        LinkedList<Whole> linkedList = new LinkedList<Whole>();
        if (n2 > 0) {
            int n4;
            Whole[][] wholeArray = this.relatorMatrixAsArray();
            FpGroup.diagonalize(wholeArray);
            Whole[] wholeArray2 = new Whole[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                wholeArray2[n4] = wholeArray[n4][n4];
            }
            for (n4 = 0; n4 < n3 - 1; ++n4) {
                int n5 = n4 + 1;
                while (n4 < n3) {
                    Whole whole = wholeArray2[n4];
                    Whole whole2 = wholeArray2[n5];
                    if (!whole.equals(ZERO) && !whole2.mod(whole).equals(ZERO)) {
                        Whole whole3 = whole.gcd(whole2);
                        wholeArray2[n5] = (Whole)whole2.dividedBy(whole3).times(whole);
                        wholeArray2[n4] = whole3;
                    }
                    ++n4;
                }
            }
            for (n4 = 0; n4 < n3; ++n4) {
                if (wholeArray2[n4].equals(ONE)) continue;
                linkedList.add(wholeArray2[n4]);
            }
        }
        for (int i = 0; i < n - n3; ++i) {
            linkedList.add(ZERO);
        }
        Collections.sort(linkedList);
        return linkedList;
    }

    static void diagonalize(Whole[][] wholeArray) {
        if (wholeArray.length == 0 || wholeArray[0].length == 0) {
            return;
        }
        int n = wholeArray.length;
        int n2 = wholeArray[0].length;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            Whole whole;
            int n4;
            Whole whole2 = null;
            int n5 = 0;
            int n6 = 0;
            for (n4 = i; n4 < n; ++n4) {
                for (int j = i; j < n2; ++j) {
                    whole = (Whole)wholeArray[n4][j].abs();
                    if (whole.equals(ZERO) || whole2 != null && whole.compareTo(whole2) >= 0) continue;
                    whole2 = whole;
                    n5 = n4;
                    n6 = j;
                }
            }
            if (whole2 == null) {
                return;
            }
            if (n5 != i) {
                for (n4 = i; n4 < n2; ++n4) {
                    Whole whole3 = wholeArray[i][n4];
                    wholeArray[i][n4] = wholeArray[n5][n4];
                    wholeArray[n5][n4] = whole3;
                }
            }
            if (n6 != i) {
                for (n4 = i; n4 < n; ++n4) {
                    Whole whole4 = wholeArray[n4][i];
                    wholeArray[n4][i] = wholeArray[n4][n6];
                    wholeArray[n4][n6] = whole4;
                }
            }
            if (wholeArray[i][i].compareTo(ZERO) < 0) {
                for (n4 = i; n4 < n2; ++n4) {
                    wholeArray[i][n4] = (Whole)wholeArray[i][n4].negative();
                }
            }
            n4 = 0;
            block6: while (n4 == 0) {
                Whole whole5;
                Whole whole6;
                int n7;
                Object object;
                Whole whole7;
                int n8;
                for (n8 = i + 1; n8 < n; ++n8) {
                    whole = wholeArray[i][i];
                    whole7 = wholeArray[n8][i];
                    if (!whole.equals(ZERO) && whole7.mod(whole).equals(ZERO)) {
                        object = (Whole)whole7.dividedBy(whole);
                        for (n7 = i; n7 < n2; ++n7) {
                            wholeArray[n8][n7] = (Whole)wholeArray[n8][n7].minus(((Whole)object).times(wholeArray[i][n7]));
                        }
                        continue;
                    }
                    if (whole7.equals(ZERO)) continue;
                    object = FpGroup.gcdex(whole, whole7);
                    for (n7 = i; n7 < n2; ++n7) {
                        whole6 = wholeArray[i][n7];
                        whole5 = wholeArray[n8][n7];
                        wholeArray[i][n7] = (Whole)whole6.times(object[1]).plus(whole5.times(object[2]));
                        wholeArray[n8][n7] = (Whole)whole6.times(object[3]).plus(whole5.times(object[4]));
                    }
                }
                n4 = 1;
                for (n8 = i + 1; n8 < n2; ++n8) {
                    whole = wholeArray[i][i];
                    whole7 = wholeArray[i][n8];
                    if (!whole.equals(ZERO) && whole7.mod(whole).equals(ZERO)) {
                        wholeArray[i][n8] = ZERO;
                        continue;
                    }
                    if (whole7.equals(ZERO)) continue;
                    object = FpGroup.gcdex(whole, whole7);
                    for (n7 = i; n7 < n; ++n7) {
                        whole6 = wholeArray[n7][i];
                        whole5 = wholeArray[n7][n8];
                        wholeArray[n7][i] = (Whole)whole6.times(object[1]).plus(whole5.times(object[2]));
                        wholeArray[n7][n8] = (Whole)whole6.times(object[3]).plus(whole5.times(object[4]));
                    }
                    n4 = 0;
                    continue block6;
                }
            }
        }
    }

    static Whole[] gcdex(Whole whole, Whole whole2) {
        Whole whole3 = (Whole)whole.abs();
        Whole whole4 = (Whole)whole3.dividedBy(whole);
        Whole whole5 = (Whole)whole2.abs();
        Whole whole6 = ZERO;
        while (!whole5.equals(ZERO)) {
            Whole whole7 = whole3.div(whole5);
            Whole whole8 = whole5;
            Whole whole9 = whole6;
            whole5 = (Whole)whole3.minus(whole7.times(whole5));
            whole6 = (Whole)whole4.minus(whole7.times(whole6));
            whole3 = whole8;
            whole4 = whole9;
        }
        if (whole2.equals(ZERO)) {
            return new Whole[]{whole3, whole4, ZERO, whole6, ONE};
        }
        return new Whole[]{whole3, whole4, (Whole)whole3.minus(whole4.times(whole)).dividedBy(whole2), whole6, (Whole)ZERO.minus(whole6.times(whole)).dividedBy(whole2)};
    }
}

