/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.compounds;

import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.FloatingPoint;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;

public class LinearAlgebra {
    static final Real EPS = new FloatingPoint(1.0E-12);

    public static Matrix rowOrthonormalized(Matrix matrix, Matrix matrix2) {
        int n;
        int n2 = matrix2.numberOfRows();
        int n3 = matrix.numberOfRows();
        if (!matrix2.equals(matrix2.transposed())) {
            throw new IllegalArgumentException("second argument must be symmetric");
        }
        if (matrix.numberOfColumns() != n2) {
            throw new IllegalArgumentException("wrong number of columns for first argument");
        }
        if (n3 > n2) {
            throw new IllegalArgumentException("too many rows in first argument");
        }
        Matrix[] matrixArray = new Matrix[n3];
        for (n = 0; n < n3; ++n) {
            matrixArray[n] = matrix.getRow(n);
        }
        for (n = 0; n < n3; ++n) {
            Matrix matrix3 = matrixArray[n];
            for (int i = 0; i < n; ++i) {
                Matrix matrix4 = (Matrix)matrixArray[n].times(matrix2).times(matrixArray[i].transposed());
                matrix3 = (Matrix)matrix3.minus(matrixArray[i].times(matrix4.get(0, 0)));
            }
            Matrix matrix5 = (Matrix)matrix3.times(matrix2).times(matrix3.transposed());
            double d = ((Real)matrix5.get(0, 0)).doubleValue();
            if (d <= 0.0) {
                return null;
            }
            double d2 = Math.sqrt(d);
            matrixArray[n] = (Matrix)matrix3.dividedBy(d2);
        }
        Matrix matrix6 = new Matrix(n3, n2);
        for (int i = 0; i < n3; ++i) {
            matrix6.setRow(i, matrixArray[i]);
        }
        return matrix6;
    }

    public static Matrix orthonormalRowBasis(Matrix matrix) {
        return LinearAlgebra.rowOrthonormalized(Matrix.one(matrix.numberOfRows()), matrix);
    }

    public static Matrix orthogonalProjection(Matrix matrix, Matrix matrix2) {
        int n = matrix.numberOfColumns();
        int n2 = matrix.rank();
        Matrix matrix3 = matrix.mutableClone();
        Matrix.triangulate(matrix3, null, true, false);
        matrix3 = matrix3.getSubMatrix(0, 0, n2, n);
        Matrix matrix4 = LinearAlgebra.columnNullSpace(matrix3, true).transposed();
        Matrix matrix5 = new Matrix(n, n);
        matrix5.setSubMatrix(0, 0, matrix3);
        matrix5.setSubMatrix(n2, 0, matrix4);
        Matrix matrix6 = LinearAlgebra.rowOrthonormalized(matrix5, matrix2);
        Matrix matrix7 = Matrix.one(n).mutableClone();
        for (int i = n2; i < n; ++i) {
            matrix7.set(i, i, Whole.ZERO);
        }
        return (Matrix)matrix7.times(matrix6.inverse());
    }

    private static boolean isDiagonal(Matrix matrix) {
        int n = matrix.numberOfRows();
        int n2 = matrix.numberOfColumns();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (i == j || matrix.get(i, j).isZero()) continue;
                return false;
            }
        }
        return true;
    }

    public static Matrix[] smithNormalForm(Matrix matrix, boolean bl) {
        int n = matrix.numberOfRows();
        int n2 = matrix.numberOfColumns();
        Matrix matrix2 = matrix.mutableClone();
        Matrix matrix3 = Matrix.one(n).mutableClone();
        Matrix matrix4 = Matrix.one(n2).mutableClone();
        do {
            Matrix.triangulate(matrix2, matrix3, bl, true);
            matrix2 = matrix2.transposed().mutableClone();
            Matrix.triangulate(matrix2, matrix4, bl, true);
        } while (!LinearAlgebra.isDiagonal(matrix2 = matrix2.transposed().mutableClone()) && bl);
        return new Matrix[]{matrix3, matrix2, matrix4.transposed()};
    }

    public static Matrix columnNullSpace(Matrix matrix, boolean bl) {
        Matrix[] matrixArray = LinearAlgebra.smithNormalForm(matrix, bl);
        Matrix matrix2 = matrixArray[1];
        Matrix matrix3 = matrixArray[2];
        int n = matrix3.numberOfRows();
        int n2 = matrix2.rank();
        Matrix matrix4 = new Matrix(n, n - n2);
        matrix4.setSubMatrix(0, 0, Matrix.zero(n2, n - n2));
        matrix4.setSubMatrix(n2, 0, Matrix.one(n - n2));
        return (Matrix)matrix3.times(matrix4);
    }

    public static Matrix rowNullSpace(Matrix matrix, boolean bl) {
        return LinearAlgebra.columnNullSpace(matrix.transposed(), bl).transposed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Matrix solutionInColumns(Matrix matrix, Matrix matrix2, boolean bl) {
        if (matrix == null || matrix2 == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (matrix.numberOfRows() != matrix2.numberOfRows()) {
            throw new IllegalArgumentException("matrix shapes don't match");
        }
        int n = matrix.numberOfRows();
        int n2 = matrix.numberOfColumns();
        int n3 = matrix2.numberOfColumns();
        Matrix[] matrixArray = LinearAlgebra.smithNormalForm(matrix, bl);
        Matrix matrix3 = matrixArray[0];
        Matrix matrix4 = matrixArray[1];
        Matrix matrix5 = matrixArray[2];
        Matrix matrix6 = (Matrix)matrix3.times(matrix2);
        Matrix matrix7 = new Matrix(n2, n3);
        for (int i = 0; i < n; ++i) {
            Whole whole = i < n2 ? matrix4.get(i, i) : Whole.ZERO;
            for (int j = 0; j < n3; ++j) {
                IArithmetic iArithmetic;
                IArithmetic iArithmetic2 = matrix6.get(i, j);
                if (whole.isZero()) {
                    if ((!bl || !(iArithmetic2 instanceof Whole)) && !iArithmetic2.isZero() && (iArithmetic2.isExact() || !iArithmetic2.isLessOrEqual(EPS))) return null;
                    iArithmetic = Whole.ZERO;
                } else {
                    iArithmetic = iArithmetic2.dividedBy(whole);
                }
                if (i >= n2) continue;
                matrix7.set(i, j, iArithmetic);
            }
        }
        return (Matrix)matrix5.times(matrix7);
    }

    public static Matrix solutionInRows(Matrix matrix, Matrix matrix2, boolean bl) {
        Matrix matrix3 = LinearAlgebra.solutionInColumns(matrix.transposed(), matrix2.transposed(), bl);
        if (matrix3 == null) {
            return null;
        }
        return matrix3.transposed();
    }

    public static IArithmetic dotRows(Matrix matrix, Matrix matrix2, Matrix matrix3) {
        if (matrix.numberOfRows() != 1 || matrix2.numberOfRows() != 1) {
            throw new IllegalArgumentException("first two arguments must be row vectors");
        }
        Matrix matrix4 = (Matrix)matrix.times(matrix3).times(matrix2.transposed());
        return matrix4.get(0, 0);
    }
}

