/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.algorithms;

import java.util.Arrays;

public class Amoeba {
    static final double TINY = 1.0E-10;
    static final boolean DEBUG = false;
    private final Function f;
    private double tolerance;
    private int maxSteps;
    private int maxRestarts;
    private double scale;
    private final int dim;
    private final Point[] simplex;
    int steps;

    public Amoeba(Function function, double d, int n, int n2, double d2) {
        this.f = function;
        this.tolerance = d;
        this.maxSteps = n;
        this.maxRestarts = n2;
        this.scale = d2;
        this.dim = function.dim();
        this.simplex = new Point[this.dim + 1];
    }

    public Amoeba(Function function) {
        this(function, 1.0E-6, 1000, 10, 1.0);
    }

    public double[] go(double[] dArray) {
        Object object;
        Object object2 = object = new Point(dArray);
        this.steps = 0;
        for (int i = 0; i < this.maxRestarts; ++i) {
            Object object3;
            double d = 1.0 - 2.0 * this.scale * (double)(i % 2);
            for (int j = 0; j <= this.dim; ++j) {
                object3 = (double[])dArray.clone();
                if (j > 0) {
                    int n = j - 1;
                    object3[n] = object3[n] + d;
                }
                this.simplex[j] = new Point((double[])object3);
            }
            Arrays.sort(this.simplex);
            Point point = null;
            while (this.steps < this.maxSteps) {
                double d2;
                double d3;
                double d4;
                if (point == null || this.simplex[0].value < point.value) {
                    point = this.simplex[0];
                }
                if ((d4 = 2.0 * Math.abs((d3 = this.simplex[this.dim].value) - (d2 = this.simplex[0].value)) / (Math.abs(d2) + Math.abs(d3) + 1.0E-10)) < this.tolerance) break;
                Point point2 = this.amotry(-1.0);
                if (point2.value <= this.simplex[0].value) {
                    point2 = this.amotry(2.0);
                    continue;
                }
                if (!(point2.value >= this.simplex[this.dim - 1].value)) continue;
                point2 = this.amotry(0.5);
                if (!(point2.value >= this.simplex[this.dim].value)) continue;
                double[] dArray2 = this.simplex[0].arg;
                for (int j = 1; j <= this.dim; ++j) {
                    double[] dArray3 = this.simplex[j].arg;
                    double[] dArray4 = new double[this.dim];
                    for (int k = 0; k < this.dim; ++k) {
                        dArray4[k] = (dArray2[k] + dArray3[k]) / 2.0;
                    }
                    this.simplex[j] = new Point(dArray4);
                }
                Arrays.sort(this.simplex);
            }
            object3 = this.simplex[0];
            if (object3.value < ((Point)object).value) {
                object = object3;
            }
            double d5 = 0.0;
            for (int j = 0; j < this.dim; ++j) {
                d5 = Math.max(d5, Math.abs(((Point)object2).arg[j] - object3.arg[j]));
            }
            if (d5 < this.tolerance) break;
            object2 = object3;
        }
        return ((Point)object).arg;
    }

    private Point amotry(double d) {
        double[] dArray = new double[this.dim];
        for (int i = 0; i <= this.dim; ++i) {
            double[] dArray2 = this.simplex[i].arg;
            for (int j = 0; j < this.dim; ++j) {
                int n = j;
                dArray[n] = dArray[n] + dArray2[j];
            }
        }
        double d2 = (1.0 - d) / (double)this.dim;
        double d3 = d - d2;
        double[] dArray3 = this.simplex[this.dim].arg;
        double[] dArray4 = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray4[i] = d2 * dArray[i] + d3 * dArray3[i];
        }
        Point point = new Point(dArray4);
        double d4 = point.value;
        if (d4 < this.simplex[this.dim].value) {
            for (int i = this.dim - 1; i >= -1; --i) {
                if (i < 0 || d4 >= this.simplex[i].value) {
                    this.simplex[i + 1] = point;
                    break;
                }
                this.simplex[i + 1] = this.simplex[i];
            }
        }
        return point;
    }

    public int getMaxRestarts() {
        return this.maxRestarts;
    }

    public void setMaxRestarts(int n) {
        this.maxRestarts = n;
    }

    public int getMaxSteps() {
        return this.maxSteps;
    }

    public void setMaxSteps(int n) {
        this.maxSteps = n;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double d) {
        this.tolerance = d;
    }

    private class Point
    implements Comparable<Point> {
        public final double[] arg;
        public final double value;

        public Point(double[] dArray) {
            this.arg = (double[])dArray.clone();
            double d = Amoeba.this.f.evaluate(dArray);
            this.value = Double.isNaN(d) ? Double.MAX_VALUE : d;
            ++Amoeba.this.steps;
        }

        @Override
        public int compareTo(Point point) {
            return Double.compare(this.value, point.value);
        }
    }

    public static interface Function {
        public double evaluate(double[] var1);

        public int dim();
    }
}

