/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.gui;

import buoy.widget.CustomWidget;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;

public abstract class SliderBase
extends CustomWidget {
    protected double min;
    protected double max;
    protected boolean showTicks = true;
    protected boolean showValue = true;
    protected double majorTickSpacing = 0.0;
    protected double minorTickSpacing = 0.0;
    protected double snapInterval = 0.0;

    protected abstract int sliderWidth();

    protected void clearCanvas(Graphics2D g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
    }

    protected void drawGuide(Graphics2D g) {
        g.setColor(Color.WHITE);
        g.fillRect(3, 2, this.sliderWidth(), 5);
        g.setColor(new Color(0.8f, 0.88f, 0.92f));
        g.drawLine(4, 3, this.sliderWidth() + 2, 3);
        g.setColor(Color.GRAY);
        g.drawRect(3, 2, this.sliderWidth(), 5);
    }

    protected void drawTicks(Graphics2D g) {
        if (this.showTicks) {
            int x;
            double t;
            g.setColor(Color.GRAY);
            if (this.minorTickSpacing > 0.0) {
                t = this.min;
                while (t <= this.max) {
                    x = this.valueToX(t) + 3;
                    g.drawLine(x, 8, x, 11);
                    t += this.minorTickSpacing;
                }
            }
            if (this.majorTickSpacing > 0.0) {
                t = this.min;
                while (t <= this.max) {
                    x = this.valueToX(t) + 3;
                    g.drawLine(x, 8, x, 14);
                    t += this.majorTickSpacing;
                }
            }
        }
    }

    protected void fillGuide(Graphics2D g, double lo, double hi) {
        int xlo = this.valueToX(lo) + 4;
        int xhi = this.valueToX(hi) + 2;
        g.setColor(new Color(1.0f, 0.6f, 0.2f));
        g.drawLine(xlo, 6, xhi, 6);
        g.setColor(new Color(1.0f, 0.75f, 0.5f));
        g.drawLine(xlo, 5, xhi, 5);
        g.setColor(new Color(1.0f, 0.9f, 0.8f));
        g.drawLine(xlo, 4, xhi, 4);
        g.setColor(Color.WHITE);
        g.drawLine(xlo, 3, xhi, 3);
    }

    protected void drawMarker(Graphics2D g, double pos) {
        int x = this.valueToX(pos);
        g.setColor(new Color(0.9f, 0.9f, 0.9f));
        g.drawLine(x + 1, 0, x + 1, 9);
        g.drawLine(x + 2, 0, x + 2, 10);
        g.setColor(new Color(0.8f, 0.88f, 0.92f));
        g.drawLine(x + 3, 0, x + 3, 11);
        g.setColor(new Color(0.6f, 0.76f, 0.84f));
        g.drawLine(x + 4, 0, x + 4, 10);
        g.setColor(new Color(0.5f, 0.7f, 0.8f));
        g.drawLine(x + 5, 0, x + 5, 9);
        g.setColor(Color.BLACK);
        int[] nArray = new int[5];
        nArray[2] = 8;
        nArray[3] = 11;
        nArray[4] = 8;
        g.draw(new Polygon(new int[]{x, x + 6, x + 6, x + 3, x}, nArray, 5));
    }

    protected int valueToX(double val) {
        return (int)Math.round((double)this.sliderWidth() * (val - this.min) / (this.max - this.min));
    }

    protected double xToValue(int x) {
        return this.min + (double)x / (double)this.sliderWidth() * (this.max - this.min);
    }

    public void setShowTicks(boolean b) {
        this.showTicks = b;
    }

    public void setShowValue(boolean b) {
        this.showValue = b;
    }

    public void setMajorTickSpacing(double major) {
        this.majorTickSpacing = major;
    }

    public void setMinorTickSpacing(double minor) {
        this.minorTickSpacing = minor;
    }

    public void setSnapInterval(double snap) {
        this.snapInterval = snap;
    }
}

