/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.gui;

import buoy.event.EventProcessor;
import buoy.event.EventSource;
import buoy.event.ToolTipEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BLabel;
import buoy.widget.BTextField;
import buoy.widget.BToolTip;
import buoy.widget.BorderContainer;
import buoy.widget.LayoutInfo;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.gavrog.box.gui.Config;

public class OptionInputBox
extends BorderContainer {
    private boolean eventsLocked = false;
    private BTextField input;

    public OptionInputBox(String string, Object object, String string2) throws Exception {
        this(string, object, string2, 5, null);
    }

    public OptionInputBox(String string, Object object, String string2, String string3) throws Exception {
        this(string, object, string2, 5, string3);
    }

    public OptionInputBox(String string, final Object object, final String string2, int n, String string3) throws Exception {
        this.setBackground(null);
        this.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(2, 10, 2, 10), null));
        if (string3 != null) {
            this.addEventLink(ToolTipEvent.class, new BToolTip(string3));
        }
        this.input = new BTextField(n);
        this.add(this.input, BorderContainer.WEST);
        this.add(new BLabel(string), BorderContainer.EAST);
        PropertyDescriptor propertyDescriptor = Config.namedProperty(object, string2);
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException("Target class has no property " + string2);
        }
        Method method = propertyDescriptor.getReadMethod();
        final Method method2 = propertyDescriptor.getWriteMethod();
        final Class<?> clazz = method2.getParameterTypes()[0];
        this.input.setText(Config.asString(method.invoke(object, new Object[0])));
        this.input.addEventLink(ValueChangedEvent.class, new EventProcessor(){

            @Override
            public void handleEvent(Object object2) {
                if (OptionInputBox.this.obtainLock()) {
                    try {
                        method2.invoke(object, Config.construct(clazz, OptionInputBox.this.input.getText()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    OptionInputBox.this.releaseLock();
                }
            }
        });
        if (object instanceof EventSource) {
            EventSource eventSource = (EventSource)object;
            eventSource.addEventLink(PropertyChangeEvent.class, new EventProcessor(){

                @Override
                public void handleEvent(Object object) {
                    if (OptionInputBox.this.obtainLock()) {
                        PropertyChangeEvent propertyChangeEvent = (PropertyChangeEvent)object;
                        try {
                            if (propertyChangeEvent.getPropertyName().equals(string2)) {
                                OptionInputBox.this.input.setText(Config.asString(propertyChangeEvent.getNewValue()));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        OptionInputBox.this.releaseLock();
                    }
                }
            });
        }
    }

    private boolean obtainLock() {
        if (this.eventsLocked) {
            return false;
        }
        this.eventsLocked = true;
        return true;
    }

    private void releaseLock() {
        this.eventsLocked = false;
    }
}

