/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.collections;

import java.util.Comparator;

public class Pair<F, S> {
    private F first;
    private S second;

    public Pair(F f, S s) {
        this.first = f;
        this.second = s;
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    private boolean equal(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public boolean equals(Pair<?, ?> pair) {
        return this.equal(this.first, pair.first) && this.equal(this.second, pair.second);
    }

    public boolean equals(Object object) {
        if (object instanceof Pair) {
            return this.equals((Pair)object);
        }
        return false;
    }

    private <T> int hash(T t) {
        return t == null ? 0 : t.hashCode();
    }

    public int hashCode() {
        return this.hash(this.first) * 37 + this.hash(this.second);
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }

    public static <F extends Comparable<? super F>, S extends Comparable<? super S>> Comparator<Pair<F, S>> defaultComparator() {
        return new Comparator<Pair<F, S>>(){

            @Override
            public int compare(Pair<F, S> pair, Pair<F, S> pair2) {
                int n = ((Comparable)pair.getFirst()).compareTo(pair2.getFirst());
                if (n == 0) {
                    return ((Comparable)pair.getSecond()).compareTo(pair2.getSecond());
                }
                return n;
            }
        };
    }

    public static <F extends Comparable<? super F>> Comparator<Pair<F, ?>> firstItemComparator() {
        return new Comparator<Pair<F, ?>>(){

            @Override
            public int compare(Pair<F, ?> pair, Pair<F, ?> pair2) {
                return ((Comparable)pair.getFirst()).compareTo(pair2.getFirst());
            }
        };
    }
}

