/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.collections;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class NiftyList<E extends Comparable<? super E>>
extends ArrayList<E>
implements Comparable<List<E>> {
    private static final long serialVersionUID = -8961300535697662494L;

    public NiftyList() {
    }

    public NiftyList(List<E> list) {
        super(list);
    }

    @Override
    public int compareTo(List<E> list) {
        for (int i = 0; i < Math.min(this.size(), list.size()); ++i) {
            int n = ((Comparable)this.get(i)).compareTo(list.get(i));
            if (n == 0) continue;
            return n;
        }
        return this.size() - list.size();
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            n = n * 157 + ((Comparable)this.get(i)).hashCode();
        }
        return n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.get(i));
        }
        return stringBuffer.toString();
    }

    public static <E> Comparator<List<E>> lexicographicComparator(final Comparator<? super E> comparator) {
        return new Comparator<List<E>>(){

            @Override
            public int compare(List<E> list, List<E> list2) {
                for (int i = 0; i < Math.min(list.size(), list2.size()); ++i) {
                    int n = comparator.compare(list.get(i), list2.get(i));
                    if (n == 0) continue;
                    return n;
                }
                return list.size() - list2.size();
            }
        };
    }

    public static <E extends Comparable<? super E>> Comparator<List<E>> lexicographicComparator() {
        return new Comparator<List<E>>(){

            @Override
            public int compare(List<E> list, List<E> list2) {
                for (int i = 0; i < Math.min(list.size(), list2.size()); ++i) {
                    int n = ((Comparable)list.get(i)).compareTo(list2.get(i));
                    if (n == 0) continue;
                    return n;
                }
                return list.size() - list2.size();
            }
        };
    }
}

