/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.apps.systre;

import buoy.event.CommandEvent;
import buoy.event.DocumentLinkEvent;
import buoy.event.WindowClosingEvent;
import buoy.event.WindowResizedEvent;
import buoy.widget.BButton;
import buoy.widget.BDialog;
import buoy.widget.BDocumentViewer;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BScrollBar;
import buoy.widget.BScrollPane;
import buoy.widget.BSeparator;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextArea;
import buoy.widget.BorderContainer;
import buoy.widget.ColumnContainer;
import buoy.widget.GridContainer;
import buoy.widget.LayoutInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.gavrog.apps.systre.SystreCmdline;
import org.gavrog.apps.systre.SystreException;
import org.gavrog.apps.systre.Version;
import org.gavrog.box.collections.Pair;
import org.gavrog.box.gui.ExtensionFilter;
import org.gavrog.box.gui.Invoke;
import org.gavrog.box.gui.OptionCheckBox;
import org.gavrog.box.gui.OptionInputBox;
import org.gavrog.box.simple.DataFormatException;
import org.gavrog.box.simple.Misc;
import org.gavrog.box.simple.TaskController;
import org.gavrog.box.simple.TaskStoppedException;
import org.gavrog.joss.geometry.SpaceGroupCatalogue;
import org.gavrog.joss.pgraphs.embed.ProcessedNet;
import org.gavrog.joss.pgraphs.io.Archive;
import org.gavrog.joss.pgraphs.io.Net;
import org.gavrog.joss.pgraphs.io.Output;

public class SystreGUI
extends BFrame {
    static final String mainLabel = "<html><h1><font color=#202060>Gavrog Systre</font></h1><font color=#202060>Version " + Version.full + "<br>by Olaf Delgado-Friedrichs, 2001-2019</font></html>";
    private static final Color textColor = new Color(255, 250, 240);
    private static final Color buttonColor = new Color(224, 224, 240);
    private static final Insets defaultInsets = new Insets(5, 5, 5, 5);
    private final BFileChooser inFileChooser = new BFileChooser(BFileChooser.OPEN_FILE, "Open data file");
    private final BFileChooser outFileChooser = new BFileChooser(BFileChooser.SAVE_FILE, "Save output");
    private final BTextArea output;
    private final BScrollBar vscroll;
    private final BButton openButton;
    private final BButton nextButton;
    private final BButton saveButton;
    private final BButton optionsButton;
    private final BLabel statusBar;
    private final SystreCmdline systre = new SystreCmdline();
    private Iterator<Net> netsToProcess = null;
    private Exception inputException = null;
    private String strippedFileName;
    private String fullFileName;
    private StringBuffer currentTranscript = new StringBuffer();
    private String lastFinishedTranscript = null;
    private List<Pair<ProcessedNet, String>> bufferedNets = new LinkedList<Pair<ProcessedNet, String>>();
    private int count;
    private TaskController taskController = null;
    private boolean singleWrite = false;
    private boolean readArchivesAsInput = false;
    private boolean nonStopMode = false;
    private String configFileName = "";

    public SystreGUI() {
        super("Systre " + Version.full);
        BorderContainer borderContainer = new BorderContainer();
        borderContainer.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        borderContainer.setBackground(textColor);
        BorderContainer borderContainer2 = new BorderContainer();
        borderContainer2.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, defaultInsets, null));
        borderContainer2.setBackground(null);
        BLabel bLabel = new BLabel(mainLabel);
        borderContainer2.add(bLabel, BorderContainer.NORTH);
        GridContainer gridContainer = new GridContainer(5, 1);
        gridContainer.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, null, null));
        this.openButton = this.makeButton("Open...", this, "doOpen");
        gridContainer.add(this.openButton, 0, 0);
        this.nextButton = this.makeButton("Next", this, "doNext");
        gridContainer.add(this.nextButton, 1, 0);
        this.saveButton = this.makeButton("Save as...", this, "doSave");
        gridContainer.add(this.saveButton, 2, 0);
        this.optionsButton = this.makeButton("Options...", this, "doOptions");
        gridContainer.add(this.optionsButton, 3, 0);
        gridContainer.add(this.makeButton("Help", this, "doHelp"), 4, 0);
        borderContainer2.add(gridContainer, BorderContainer.CENTER, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, null, null));
        this.statusBar = new BLabel();
        BOutline bOutline = BOutline.createLineBorder(this.statusBar, Color.BLACK, 2);
        bOutline.setBackground(Color.WHITE);
        borderContainer2.add(bOutline, BorderContainer.SOUTH, new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, null, null));
        borderContainer.add(borderContainer2, BorderContainer.NORTH);
        this.output = new BTextArea(20, 40);
        this.output.setBackground(null);
        BScrollPane bScrollPane = new BScrollPane(this.output, BScrollPane.SCROLLBAR_ALWAYS, BScrollPane.SCROLLBAR_ALWAYS);
        bScrollPane.setForceHeight(true);
        bScrollPane.setForceWidth(true);
        this.vscroll = bScrollPane.getVerticalScrollBar();
        bScrollPane.setBackground(null);
        borderContainer.add(bScrollPane, BorderContainer.CENTER);
        BButton bButton = this.makeButton("Cancel", this, "doCancel");
        BButton bButton2 = this.makeButton("Exit", this, "doQuit");
        BorderContainer borderContainer3 = new BorderContainer();
        borderContainer3.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, defaultInsets, null));
        borderContainer3.setBackground(null);
        borderContainer3.add(bButton, BorderContainer.WEST);
        borderContainer3.add(bButton2, BorderContainer.EAST);
        borderContainer.add(borderContainer3, BorderContainer.SOUTH, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, null, null));
        this.nextButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        JFileChooser jFileChooser = this.inFileChooser.getComponent();
        jFileChooser.addChoosableFileFilter(new ExtensionFilter(new String[]{"ds", "tgs"}, "Delaney-Dress Symbol Files"));
        jFileChooser.addChoosableFileFilter(new ExtensionFilter("arc", "Systre Archives"));
        jFileChooser.addChoosableFileFilter(new ExtensionFilter(new String[]{"cgd", "pgr"}, "Systre Input Files"));
        JFileChooser jFileChooser2 = this.outFileChooser.getComponent();
        jFileChooser2.addChoosableFileFilter(new ExtensionFilter("arc", "Systre Archive Files"));
        jFileChooser2.addChoosableFileFilter(new ExtensionFilter("cgd", "Embedded Nets"));
        jFileChooser2.addChoosableFileFilter(new ExtensionFilter("pgr", "Abstract Topologies"));
        jFileChooser2.addChoosableFileFilter(new ExtensionFilter("out", "Systre Transcripts"));
        this.systre.addEventLink(String.class, (Object)this, "status");
        this.statusBar.setText("...");
        this.setContent(borderContainer);
        this.pack();
        JFrame jFrame = this.getComponent();
        jFrame.setSize(700, 600);
        jFrame.validate();
        this.addEventLink(WindowClosingEvent.class, (Object)this, "doQuit");
        this.addEventLink(WindowResizedEvent.class, (Object)this, "resizeMessage");
        this.captureOutput();
        this.setVisible(true);
        this.status("Initializing...");
        try {
            this.configFileName = System.getProperty("user.home") + "/.systrerc";
            this.systre.loadOptions(this.configFileName);
            String string = System.getProperty("user.home") + "/.systre";
            for (String string2 : this.userDefinedArchives(string)) {
                this.systre.processArchive(string2);
            }
        }
        catch (Throwable throwable) {
            this.reportException(throwable, "FILE", null, true);
        }
        this.status("Ready to go!");
    }

    private List<String> userDefinedArchives(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        File file = new File(string);
        if (file.listFiles() != null) {
            for (File file2 : file.listFiles()) {
                if (!file2.getName().endsWith(".arc")) continue;
                linkedList.add(string + "/" + file2.getName());
            }
        }
        return linkedList;
    }

    public void resizeMessage() {
        Dimension dimension = this.getComponent().getSize();
        this.status("Window resized to " + dimension.width + "x" + dimension.height + ".");
    }

    public void status(final String string) {
        Invoke.andWait(new Runnable(){

            @Override
            public void run() {
                SystreGUI.this.statusBar.setText("<html><font color=\"green\">&nbsp;" + string + "</font></html>");
            }
        });
    }

    private BButton makeButton(String string, Object object, String string2) {
        BButton bButton = new BButton(string);
        bButton.setBackground(buttonColor);
        bButton.addEventLink(CommandEvent.class, object, string2);
        return bButton;
    }

    private void captureOutput() {
        OutputStream outputStream = new OutputStream(){
            private StringBuffer buffer = new StringBuffer(128);

            @Override
            public void write(int n) throws IOException {
                char c = (char)n;
                this.buffer.append(c);
                if (c == '\n' || this.buffer.length() > 1023) {
                    this.flush();
                }
            }

            @Override
            public void flush() {
                SystreGUI.this.output.append(this.buffer.toString());
                SystreGUI.this.currentTranscript.append(this.buffer);
                this.buffer.delete(0, this.buffer.length());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SystreGUI.this.vscroll.setValue(SystreGUI.this.vscroll.getMaximum());
                    }
                });
            }
        };
        this.systre.setOutStream(new PrintStream(outputStream));
    }

    public void doOpen() {
        boolean bl = this.inFileChooser.showDialog(this);
        if (bl) {
            this.netsToProcess = null;
            String string = this.inFileChooser.getSelectedFile().getName();
            File file = this.inFileChooser.getDirectory();
            String string2 = new File(file, string).getAbsolutePath();
            this.output.setText("");
            this.disableMainButtons();
            if (!this.readArchivesAsInput && string.endsWith(".arc")) {
                this.systre.processArchive(string2);
                this.enableMainButtons();
            } else {
                this.openFile(string2);
                this.doNext();
            }
        }
    }

    public void doSave() {
        String string = this.strippedFileName;
        this.outFileChooser.setSelectedFile(new File(string + ".out"));
        boolean bl = this.outFileChooser.showDialog(this);
        if (bl) {
            boolean bl2;
            File file;
            File file2;
            FileFilter fileFilter;
            String string2;
            int n;
            String string3 = this.outFileChooser.getSelectedFile().getName();
            String string4 = string3.substring((n = string3.lastIndexOf(46)) + 1);
            if (!string4.equals(string2 = (fileFilter = this.outFileChooser.getFileFilter()).accept(new File("x.cgd")) ? "cgd" : (fileFilter.accept(new File("x.pgr")) ? "pgr" : (fileFilter.accept(new File("x.arc")) ? "arc" : "out")))) {
                string3 = string3 + "." + string2;
            }
            if ((file2 = new File(file = this.outFileChooser.getDirectory(), string3)).exists()) {
                int n2 = new BStandardDialog("Systre - File exists", "File \"" + file2 + "\" exists. Overwrite?", BStandardDialog.QUESTION).showOptionDialog(this, new String[]{"Overwrite", "Append", "Cancel"}, "Cancel");
                if (n2 > 1) {
                    return;
                }
                bl2 = n2 == 1;
            } else {
                bl2 = false;
            }
            this.disableMainButtons();
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2, bl2));
                        if (SystreGUI.this.singleWrite) {
                            SystreGUI.this.writeStructure(string2, bufferedWriter, SystreGUI.this.systre.getLastStructure(), SystreGUI.this.lastFinishedTranscript);
                        } else {
                            for (Pair pair : SystreGUI.this.bufferedNets) {
                                ProcessedNet processedNet = (ProcessedNet)pair.getFirst();
                                String string = (String)pair.getSecond();
                                SystreGUI.this.writeStructure(string2, bufferedWriter, processedNet, string);
                            }
                            SystreGUI.this.writeStructure(string2, bufferedWriter, null, SystreGUI.this.currentTranscript.toString());
                        }
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        SystreGUI.this.reportException(null, "FILE", "I/O error writing to " + file2, false);
                    }
                    catch (Exception exception) {
                        SystreGUI.this.reportException(exception, "INTERNAL", "Unexpected exception while writing to " + file2, true);
                    }
                    finally {
                        SystreGUI.this.enableMainButtons();
                    }
                }
            }).start();
        }
    }

    private void writeStructure(String string, BufferedWriter bufferedWriter, ProcessedNet processedNet, String string2) throws IOException {
        String string3 = System.getProperty("line.separator");
        if ("out".equals(string)) {
            bufferedWriter.write(string2.replaceAll(string3, "\n"));
            bufferedWriter.write("\n");
        } else if (processedNet != null) {
            if ("arc".equals(string)) {
                String string4 = new Archive.Entry(processedNet.getGraph(), processedNet.getName()).toString();
                bufferedWriter.write(string4);
                bufferedWriter.write("\n");
            } else if ("cgd".equals(string) && processedNet.hasEmbedding()) {
                processedNet.writeEmbedding(bufferedWriter, true, this.systre.getOutputFullCell(), "");
            } else if ("pgr".equals(string) || "cgd".equals(string)) {
                Output.writePGR(bufferedWriter, processedNet.getGraph().canonical(), processedNet.getName());
                bufferedWriter.write("\n");
            }
        } else if (!"arc".equals(string)) {
            bufferedWriter.write("#");
            bufferedWriter.write(string2.replaceAll(string3, "\n#"));
            bufferedWriter.write("\n");
        }
    }

    public void doOptions() {
        BDialog bDialog = new BDialog(this, "Systre - Options", true);
        ColumnContainer columnContainer = new ColumnContainer();
        columnContainer.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, defaultInsets, null));
        columnContainer.setBackground(textColor);
        try {
            columnContainer.add(new OptionCheckBox("Process whole files without stopping", this, "nonStopMode", "Tells Systre not to wait for you to push 'Next' between structures."));
            columnContainer.add(new OptionCheckBox("Use Builtin Archive", this.systre, "useBuiltinArchive", "Tells Systre to use its archive of RCSR structures for identifying nets."));
            columnContainer.add(new OptionCheckBox("Process '.arc' files like normal input", this, "readArchivesAsInput", "Makes Systre read and process raw net topologies from .arc files instead of using them to lookup structures."));
            columnContainer.add(new BSeparator());
            columnContainer.add(new OptionCheckBox("Prefer Second Origin On Input", SpaceGroupCatalogue.class, "preferSecondOrigin", "Tells Systre whether to use the first or second origin choice for space groups by default."));
            columnContainer.add(new OptionCheckBox("Prefer Hexagonal Setting On Input", SpaceGroupCatalogue.class, "preferHexagonal", "Tells Systre whether to use the hexagonal or rhombohedral setting for rhombohedral space groups by default."));
            columnContainer.add(new BSeparator());
            columnContainer.add(new OptionCheckBox("Compute Wells point symbols", this.systre, "computePointSymbols", "Makes Systre compute and print the Wells point symbol for each net."));
            columnContainer.add(new BSeparator());
            columnContainer.add(new OptionCheckBox("Compute an Embedding", this.systre, "computeEmbedding", "Tells Systre whether to compute node coordinates for nets or simply determine their topological properties."));
            columnContainer.add(new OptionCheckBox("Start from given Embedding", this.systre, "useOriginalEmbedding", "Tells Systre whether to use existing node coordinates or compute barycentric positions from scratch."));
            columnContainer.add(new OptionCheckBox("Relax Node Positions", this.systre, "relaxPositions", "Tells Systre whether to relax node coordinates or use the initial values (barycentric or existing)."));
            columnContainer.add(new OptionInputBox("Importance Of Equal Edge Lengths", this.systre, "relaxPasses", "Use 3 for most nets; reduce to 2, 1 or 0 if Systrereports bad angle or non-bonded distance values."));
            columnContainer.add(new OptionInputBox("Relaxation Step Limit", this.systre, "relaxSteps", "Use 10000 for most nets, higher values if Systre reports bad angle or non-bonded distance values."));
            columnContainer.add(new OptionCheckBox("Skip output verification", this.systre, "skipOutputTest", "Allows output that Systre can not read back in properly, e.g. containing colliding vertices."));
            columnContainer.add(new BSeparator());
            columnContainer.add(new OptionCheckBox("Output Complete Unit Cell Contents", this.systre, "outputFullCell", "Tells Systre whether to output node coordinates for an assymetric unit or a full unit cell."));
            columnContainer.add(new OptionCheckBox("Save only last net finished", this, "singleWrite", "Tells Systre whether to save data for all nets so far from the current file, or just the most recent."));
            columnContainer.add(new BSeparator());
        }
        catch (Exception exception) {
            this.reportException(exception, "FATAL", "serious internal problem", true);
            return;
        }
        BorderContainer borderContainer = new BorderContainer();
        borderContainer.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, defaultInsets, null));
        borderContainer.setBackground(null);
        borderContainer.add(this.makeButton("Ok", bDialog, "dispose"), BorderContainer.WEST);
        borderContainer.add(this.makeButton("Save", this, "doSaveOptions"), BorderContainer.EAST);
        columnContainer.add(borderContainer, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, defaultInsets, null));
        bDialog.setContent(columnContainer);
        bDialog.addEventLink(WindowClosingEvent.class, (Object)bDialog, "dispose");
        bDialog.pack();
        bDialog.setVisible(true);
    }

    public void doNext() {
        this.disableMainButtons();
        new Thread(new Runnable(){

            @Override
            public void run() {
                SystreGUI.this.nextNet();
                SystreGUI.this.enableMainButtons();
            }
        }).start();
    }

    private boolean moreNets() {
        boolean bl;
        this.status("Reading next net...");
        try {
            bl = this.netsToProcess != null && this.netsToProcess.hasNext();
        }
        catch (Exception exception) {
            this.inputException = exception;
            bl = true;
        }
        if (bl) {
            this.status("Press \"Next\" to process next net.");
        } else {
            this.status("End of file reached.");
        }
        return bl;
    }

    private Net getNextNet() throws Exception {
        if (this.inputException != null) {
            Exception exception = this.inputException;
            this.inputException = null;
            throw exception;
        }
        Net net = this.netsToProcess.next();
        if (!net.isOk()) {
            throw net.getErrors().next();
        }
        this.taskController.bailOutIfCancelled();
        return net;
    }

    public void nextNet() {
        final class BailOut
        extends Throwable {
            private static final long serialVersionUID = -7490696217023106703L;

            BailOut() {
            }
        }
        final class Cancel
        extends Throwable {
            private static final long serialVersionUID = 5411581838341297732L;

            Cancel() {
            }
        }
        this.taskController = TaskController.getInstance();
        if (!this.moreNets()) {
            this.finishFile();
            return;
        }
        PrintStream printStream = this.systre.getOutStream();
        Net net = null;
        DataFormatException dataFormatException = null;
        this.currentTranscript.delete(0, this.currentTranscript.length());
        this.status("Reading the next net...");
        boolean bl = false;
        try {
            String string;
            String string2;
            ++this.count;
            printStream.println();
            if (this.count > 1) {
                printStream.println();
                printStream.println();
            }
            try {
                net = this.getNextNet();
            }
            catch (TaskStoppedException taskStoppedException) {
                this.reportException(new SystreException(SystreException.CANCELLED, "Execution stopped for this structure"), "CANCELLED", null, false);
                throw new Cancel();
            }
            catch (DataFormatException dataFormatException2) {
                dataFormatException = dataFormatException2;
            }
            catch (Exception exception) {
                this.reportException(exception, "INTERNAL", "Unexpected exception", true);
                throw new BailOut();
            }
            if (net == null) {
                this.reportException(dataFormatException, "INPUT", null, false);
                throw new BailOut();
            }
            if (net.getName() == null) {
                string2 = this.strippedFileName + "-#" + this.count;
                string = "";
            } else {
                string2 = net.getName();
                string = " - \"" + net.getName() + "\"";
            }
            printStream.println("Structure #" + this.count + string + ".");
            printStream.println();
            if (net.getWarnings().hasNext()) {
                Iterator<String> iterator = net.getWarnings();
                while (iterator.hasNext()) {
                    printStream.println("   (" + iterator.next() + ")");
                }
                printStream.println();
            }
            boolean bl2 = false;
            if (dataFormatException != null) {
                this.reportException(dataFormatException, "INPUT", null, false);
            } else {
                try {
                    this.systre.processGraph(net, string2, true);
                    bl2 = true;
                }
                catch (TaskStoppedException taskStoppedException) {
                    this.reportException(new SystreException(SystreException.CANCELLED, "Execution stopped for this structure"), "CANCELLED", null, false);
                    bl = true;
                }
                catch (SystreException systreException) {
                    this.reportException(systreException, systreException.getType().toString(), null, false);
                }
                catch (Exception exception) {
                    this.reportException(exception, "INTERNAL", "Unexpected exception", true);
                }
                catch (Error error) {
                    this.reportException(error, "EXECUTION", "Runtime problem", true);
                }
            }
            printStream.println();
            printStream.println("Finished structure #" + this.count + string + ".");
            this.lastFinishedTranscript = this.currentTranscript.toString();
            this.currentTranscript.delete(0, this.currentTranscript.length());
            ProcessedNet processedNet = bl2 ? this.systre.getLastStructure() : null;
            this.bufferedNets.add(new Pair<ProcessedNet, String>(processedNet, this.lastFinishedTranscript));
        }
        catch (BailOut bailOut) {
            printStream.println();
            printStream.println("Skipping structure #" + this.count + " due to error in input.");
        }
        catch (Cancel cancel) {
            bl = true;
        }
        if (!this.moreNets()) {
            this.finishFile();
        } else if (this.getNonStopMode() && bl) {
            printStream.println();
            printStream.println("'Cancel' pressed in non-stop mode. Skipping rest of file.");
            this.finishFile();
        } else if (this.getNonStopMode()) {
            this.nextNet();
        }
        this.taskController = null;
    }

    private boolean openFile(String string) {
        PrintStream printStream = this.systre.getOutStream();
        this.netsToProcess = null;
        this.count = 0;
        this.fullFileName = string;
        this.strippedFileName = new File(string).getName().replaceFirst("\\..*$", "");
        this.bufferedNets.clear();
        this.inputException = null;
        try {
            this.netsToProcess = Net.iterator(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.reportException(fileNotFoundException, "FILE", null, false);
            return false;
        }
        catch (Net.IllegalFileNameException illegalFileNameException) {
            this.reportException(illegalFileNameException, "FILE", null, false);
            return false;
        }
        catch (Exception exception) {
            this.reportException(exception, "INTERNAL", "Unexpected exception", true);
        }
        catch (Error error) {
            this.reportException(error, "EXECUTION", "Runtime problem", true);
        }
        if (this.netsToProcess == null) {
            return false;
        }
        printStream.println("Data file \"" + string + "\".");
        return true;
    }

    private void finishFile() {
        PrintStream printStream = this.systre.getOutStream();
        this.status("End of file reached!");
        printStream.println();
        printStream.println("Finished data file \"" + this.fullFileName + "\".");
        this.netsToProcess = null;
        this.inputException = null;
    }

    private void reportException(final Throwable throwable, final String string, String string2, boolean bl) {
        boolean bl2;
        PrintStream printStream = this.systre.getOutStream();
        printStream.println();
        if (bl) {
            printStream.println("==================================================");
        }
        boolean bl3 = bl2 = throwable instanceof SystreException && ((SystreException)throwable).getType().equals(SystreException.CANCELLED);
        final String string3 = bl2 ? "CANCELLING" : "ERROR (" + string + ") - " + (string2 == null ? "" : string2);
        printStream.print("!!! " + string3);
        if (throwable != null) {
            if (bl) {
                printStream.println();
                printStream.print(Misc.stackTrace(throwable));
                printStream.println("==================================================");
            } else {
                printStream.println((throwable != null ? " - " + throwable.getMessage() : "") + ".");
            }
        }
        if (!this.getNonStopMode()) {
            Invoke.andWait(new Runnable(){

                @Override
                public void run() {
                    String string4 = "Systre: " + string + " ERROR";
                    String string2 = string3 + (throwable != null ? " - " + throwable.getMessage() : "") + ".";
                    BStandardDialog bStandardDialog = new BStandardDialog(string4, string2, BStandardDialog.ERROR);
                    bStandardDialog.showMessageDialog(SystreGUI.this);
                }
            });
        }
    }

    private void disableMainButtons() {
        Invoke.andWait(new Runnable(){

            @Override
            public void run() {
                SystreGUI.this.openButton.setEnabled(false);
                SystreGUI.this.nextButton.setEnabled(false);
                SystreGUI.this.saveButton.setEnabled(false);
                SystreGUI.this.optionsButton.setEnabled(false);
            }
        });
    }

    private void enableMainButtons() {
        Invoke.later(new Runnable(){

            @Override
            public void run() {
                SystreGUI.this.openButton.setEnabled(true);
                if (SystreGUI.this.moreNets()) {
                    SystreGUI.this.nextButton.setEnabled(true);
                }
                SystreGUI.this.saveButton.setEnabled(true);
                SystreGUI.this.optionsButton.setEnabled(true);
            }
        });
    }

    public void doHelp() {
        final BFrame bFrame = new BFrame("Systre - Help");
        BorderContainer borderContainer = new BorderContainer();
        borderContainer.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, defaultInsets, null));
        borderContainer.setBackground(textColor);
        final BDocumentViewer bDocumentViewer = new BDocumentViewer(){

            @Override
            public void processLinkEvent(DocumentLinkEvent documentLinkEvent) throws IOException {
                String string;
                if (documentLinkEvent.getURL() == null && (string = documentLinkEvent.getDescription()).startsWith("#")) {
                    ((JEditorPane)this.component).scrollToReference(string.substring(1));
                }
            }
        };
        bDocumentViewer.setBackground(null);
        final BScrollPane bScrollPane = new BScrollPane(bDocumentViewer, BScrollPane.SCROLLBAR_AS_NEEDED, BScrollPane.SCROLLBAR_ALWAYS);
        bScrollPane.setBackground(null);
        bScrollPane.setForceHeight(true);
        bScrollPane.setForceWidth(true);
        borderContainer.add(bScrollPane, BorderContainer.CENTER);
        bFrame.setContent(borderContainer);
        bFrame.addEventLink(WindowClosingEvent.class, (Object)bFrame, "dispose");
        bDocumentViewer.addEventLink(DocumentLinkEvent.class, (Object)bDocumentViewer, "processLinkEvent");
        new Thread(new Runnable(){

            @Override
            public void run() {
                Package package_ = this.getClass().getPackage();
                String string = package_.getName().replaceAll("\\.", "/");
                String string2 = string + "/Systre-Help.html";
                InputStream inputStream = ClassLoader.getSystemResourceAsStream(string2);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuffer stringBuffer = new StringBuffer(10000);
                while (true) {
                    String string3;
                    try {
                        string3 = bufferedReader.readLine();
                    }
                    catch (IOException iOException) {
                        break;
                    }
                    if (string3 == null) break;
                    stringBuffer.append(string3);
                    stringBuffer.append("\n");
                }
                bDocumentViewer.setDocument(stringBuffer.toString(), "text/html");
                bScrollPane.getVerticalScrollBar().setValue(0);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        bFrame.pack();
                        JFrame jFrame = bFrame.getComponent();
                        jFrame.setSize(700, 600);
                        jFrame.validate();
                        bFrame.setVisible(true);
                    }
                });
            }
        }).start();
    }

    public void doCancel() {
        this.systre.cancel();
        this.saveButton.setEnabled(true);
        if (this.taskController != null) {
            this.taskController.cancel();
        }
    }

    public void doSaveOptions() {
        this.systre.saveOptions(this.configFileName);
    }

    public void doQuit() {
        System.exit(0);
    }

    public boolean getSingleWrite() {
        return this.singleWrite;
    }

    public void setSingleWrite(boolean bl) {
        this.singleWrite = bl;
    }

    public boolean getReadArchivesAsInput() {
        return this.readArchivesAsInput;
    }

    public void setReadArchivesAsInput(boolean bl) {
        this.readArchivesAsInput = bl;
    }

    public boolean getNonStopMode() {
        return this.nonStopMode;
    }

    public void setNonStopMode(boolean bl) {
        this.nonStopMode = bl;
    }

    public static void main(String[] stringArray) {
        new SystreGUI();
    }
}

