/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.Widget;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public abstract class TextWidget
extends Widget {
    protected CaretListener caretListener = new CaretListener(){

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            TextWidget.this.caretMoved();
        }
    };
    protected DocumentListener documentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            TextWidget.this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            TextWidget.this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            TextWidget.this.textChanged();
        }
    };
    protected int suppressEvents;

    protected TextWidget() {
    }

    @Override
    public JTextComponent getComponent() {
        return (JTextComponent)this.component;
    }

    public String getText() {
        return this.getComponent().getText();
    }

    public void setText(String string) {
        try {
            ++this.suppressEvents;
            this.getComponent().setText(string);
        }
        finally {
            --this.suppressEvents;
        }
    }

    public int getLength() {
        return this.getComponent().getDocument().getLength();
    }

    public int getCaretPosition() {
        return this.getComponent().getCaretPosition();
    }

    public void setCaretPosition(int n) {
        try {
            ++this.suppressEvents;
            this.getComponent().setCaretPosition(n);
        }
        finally {
            --this.suppressEvents;
        }
    }

    public int getSelectionStart() {
        return this.getComponent().getSelectionStart();
    }

    public void setSelectionStart(int n) {
        try {
            ++this.suppressEvents;
            this.getComponent().setSelectionStart(n);
        }
        finally {
            --this.suppressEvents;
        }
    }

    public int getSelectionEnd() {
        return this.getComponent().getSelectionEnd();
    }

    public void setSelectionEnd(int n) {
        try {
            ++this.suppressEvents;
            this.getComponent().setSelectionEnd(n);
        }
        finally {
            --this.suppressEvents;
        }
    }

    public String getSelectedText() {
        return this.getComponent().getSelectedText();
    }

    public boolean isEditable() {
        return this.getComponent().isEditable();
    }

    public void setEditable(boolean bl) {
        this.getComponent().setEditable(bl);
    }

    protected void caretMoved() {
        if (this.suppressEvents == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextWidget.this.dispatchEvent(new SelectionChangedEvent(TextWidget.this));
                }
            });
        }
    }

    protected void textChanged() {
        this.invalidateSize();
        if (this.suppressEvents == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextWidget.this.dispatchEvent(new ValueChangedEvent(TextWidget.this));
                }
            });
        }
    }
}

