/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.CommandEvent;
import buoy.widget.Widget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;

public class BButton
extends Widget {
    public static final Position CENTER = new Position(0);
    public static final Position NORTH = new Position(1);
    public static final Position SOUTH = new Position(2);
    public static final Position WEST = new Position(4);
    public static final Position EAST = new Position(8);
    public static final Position NORTHEAST = new Position(BButton.NORTH.value + BButton.EAST.value);
    public static final Position SOUTHEAST = new Position(BButton.SOUTH.value + BButton.EAST.value);
    public static final Position NORTHWEST = new Position(BButton.NORTH.value + BButton.WEST.value);
    public static final Position SOUTHWEST = new Position(BButton.SOUTH.value + BButton.WEST.value);

    public BButton() {
        this.component = this.createComponent();
        this.getComponent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BButton.this.dispatchEvent(new CommandEvent(BButton.this, actionEvent.getWhen(), actionEvent.getModifiers(), ((JButton)BButton.this.component).getActionCommand()));
            }
        });
    }

    public BButton(String string) {
        this();
        this.getComponent().setText(string);
    }

    public BButton(Icon icon) {
        this();
        this.getComponent().setIcon(icon);
    }

    public BButton(String string, Icon icon) {
        this();
        this.getComponent().setText(string);
        this.getComponent().setIcon(icon);
    }

    protected JButton createComponent() {
        return new JButton();
    }

    @Override
    public JButton getComponent() {
        return (JButton)this.component;
    }

    public String getText() {
        return this.getComponent().getText();
    }

    public void setText(String string) {
        this.getComponent().setText(string);
        this.invalidateSize();
    }

    public Icon getIcon() {
        return this.getComponent().getIcon();
    }

    public void setIcon(Icon icon) {
        this.getComponent().setIcon(icon);
        this.invalidateSize();
    }

    public String getActionCommand() {
        return this.getComponent().getActionCommand();
    }

    public void setActionCommand(String string) {
        this.getComponent().setActionCommand(string);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Position getTextPosition() {
        int n = this.getComponent().getHorizontalTextPosition();
        int n2 = this.getComponent().getVerticalTextPosition();
        return Position.get(n, n2);
    }

    public void setTextPosition(Position position) {
        int n = position.value;
        JButton jButton = this.getComponent();
        if ((n & BButton.NORTH.value) != 0) {
            jButton.setVerticalTextPosition(1);
        } else if ((n & BButton.SOUTH.value) != 0) {
            jButton.setVerticalTextPosition(3);
        } else {
            jButton.setVerticalTextPosition(0);
        }
        if ((n & BButton.EAST.value) != 0) {
            jButton.setHorizontalTextPosition(4);
        } else if ((n & BButton.WEST.value) != 0) {
            jButton.setHorizontalTextPosition(2);
        } else {
            jButton.setHorizontalTextPosition(0);
        }
        this.invalidateSize();
    }

    static {
        WidgetEncoder.setPersistenceDelegate(Position.class, new StaticFieldDelegate(BButton.class));
    }

    public static class Position {
        protected int value;

        private Position(int n) {
            this.value = n;
        }

        private static Position get(int n, int n2) {
            switch (n) {
                case 2: {
                    switch (n2) {
                        case 1: {
                            return NORTHWEST;
                        }
                        case 3: {
                            return SOUTHWEST;
                        }
                    }
                    return WEST;
                }
                case 4: {
                    switch (n2) {
                        case 1: {
                            return NORTHEAST;
                        }
                        case 3: {
                            return SOUTHEAST;
                        }
                    }
                    return EAST;
                }
            }
            switch (n2) {
                case 1: {
                    return NORTH;
                }
                case 3: {
                    return SOUTH;
                }
            }
            return CENTER;
        }
    }
}

