# Numerical Analysis

Numerical Analysis comprises a collection of useful numerical methods for solving equations, fitting data, integrating functions and parameterizing curves with Bezier Polynomials.

Specifically Numerical Analysis consists of the following methods:

### Calculation of Roots of Equation

* Bisection Method
* Secant Method
* Newton Raphson
* Newton Raphson for System 2x2
* Newton Raphson for multiple roots

### Numerical Integration

* Trapezoid Method
* Simpson 1/3
* Simpson 3/8
* Romberg
* Gauss-Legendre

### Regression

* Least Squares with:

    * Straight Line (Linear Regression)
    * Polynomial
    * Exponential Function
    * Logarithmic Function
    
### Splines

* Bezier-Bernstein Polynomials
  
* Composite Bezier-Bernstein:

    * Quadratic Bezier
    * Cubic Bezier
    * N-th Order Bezier


## Installation

Use the package manager [pip](https://pip.pypa.io/en/stable/) to install numerical-analysis.

```bash
pip install numerical_analysis
```

## Requirements

* Numpy
* Matplotlib
