/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.sparksdk.transformation.deserializers;

import aialgorithms.proto2.RecordProto2;
import com.amazonaws.services.sagemaker.sparksdk.protobuf.ProtobufConverter$;
import com.amazonaws.services.sagemaker.sparksdk.transformation.ResponseRowDeserializer;
import com.amazonaws.services.sagemaker.sparksdk.transformation.deserializers.ProtobufResponseRowDeserializer$;
import com.amazonaws.services.sagemaker.sparksdk.transformation.package$ContentTypes$;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\t\u0013\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t%\f\u0005\ty\u0001\u0011\t\u0011)A\u0005]!AQ\b\u0001BC\u0002\u0013\u0005a\b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003@\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015q\u0007\u0001\"\u0003p\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000bAq!a\u000b\u0001\t\u0013\ti\u0003C\u0005\u0002@\u0001\u0011\r\u0011\"\u0011\u0002B!9\u00111\t\u0001!\u0002\u0013qu!CA#%\u0005\u0005\t\u0012AA$\r!\t\"#!A\t\u0002\u0005%\u0003BB,\u000e\t\u0003\t\t\u0006C\u0005\u0002T5\t\n\u0011\"\u0001\u0002V!I\u00111N\u0007\u0002\u0002\u0013%\u0011Q\u000e\u0002 !J|Go\u001c2vMJ+7\u000f]8og\u0016\u0014vn\u001e#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014(BA\n\u0015\u00035!Wm]3sS\u0006d\u0017N_3sg*\u0011QCF\u0001\u000fiJ\fgn\u001d4pe6\fG/[8o\u0015\t9\u0002$\u0001\u0005ta\u0006\u00148n\u001d3l\u0015\tI\"$A\u0005tC\u001e,W.Y6fe*\u00111\u0004H\u0001\tg\u0016\u0014h/[2fg*\u0011QDH\u0001\nC6\f'p\u001c8boNT\u0011aH\u0001\u0004G>l7\u0001A\n\u0004\u0001\tB\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g\r\u0005\u0002*U5\tA#\u0003\u0002,)\t9\"+Z:q_:\u001cXMU8x\t\u0016\u001cXM]5bY&TXM]\u0001\u0007g\u000eDW-\\1\u0016\u00039\u0002\"a\f\u001e\u000e\u0003AR!!\r\u001a\u0002\u000bQL\b/Z:\u000b\u0005M\"\u0014aA:rY*\u0011QGN\u0001\u0006gB\f'o\u001b\u0006\u0003oa\na!\u00199bG\",'\"A\u001d\u0002\u0007=\u0014x-\u0003\u0002<a\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u000fM\u001c\u0007.Z7bA\u0005a\u0001O]8u_\n,hmS3zgV\tq\bE\u0002$\u0001\nK!!\u0011\u0013\u0003\r=\u0003H/[8o!\r\u00195J\u0014\b\u0003\t&s!!\u0012%\u000e\u0003\u0019S!a\u0012\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0013B\u0001&%\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001T'\u0003\u0007M+\u0017O\u0003\u0002KIA\u0011qj\u0015\b\u0003!F\u0003\"!\u0012\u0013\n\u0005I#\u0013A\u0002)sK\u0012,g-\u0003\u0002U+\n11\u000b\u001e:j]\u001eT!A\u0015\u0013\u0002\u001bA\u0014x\u000e^8ck\u001a\\U-_:!\u0003\u0019a\u0014N\\5u}Q\u0019\u0011l\u0017/\u0011\u0005i\u0003Q\"\u0001\n\t\u000b1*\u0001\u0019\u0001\u0018\t\u000fu*\u0001\u0013!a\u0001\u007f\u0005\u0019B-Z:fe&\fG.\u001b>f%\u0016\u001c\bo\u001c8tKR\u0011qL\u001a\t\u0004\u0007\u0002\u0014\u0017BA1N\u0005!IE/\u001a:bi>\u0014\bCA2e\u001b\u0005\u0011\u0014BA33\u0005\r\u0011vn\u001e\u0005\u0006O\u001a\u0001\r\u0001[\u0001\re\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\t\u0004G%\\\u0017B\u00016%\u0005\u0015\t%O]1z!\t\u0019C.\u0003\u0002nI\t!!)\u001f;f\u00035\u0001(o\u001c;pEV4Gk\u001c*poR\u0011!\r\u001d\u0005\u0006c\u001e\u0001\rA]\u0001\u0007e\u0016\u001cwN\u001d3\u0011\u0005MthB\u0001;|\u001d\t)\bP\u0004\u0002Fm&\tq/\u0001\u0007bS\u0006dwm\u001c:ji\"l7/\u0003\u0002zu\u00061\u0001O]8u_JR\u0011a^\u0005\u0003yv\fABU3d_J$\u0007K]8u_JR!!\u001f>\n\u0007}\f\tA\u0001\u0004SK\u000e|'\u000f\u001a\u0006\u0003yv\fQcZ3u-\u0006dW/\u001a$s_6d\u0015MY3m\u0019&\u001cH\u000f\u0006\u0004\u0002\b\u00055\u0011\u0011\u0003\t\u0004g\u0006%\u0011\u0002BA\u0006\u0003\u0003\u0011QAV1mk\u0016Da!a\u0004\t\u0001\u0004q\u0015!\u00034jK2$g*Y7f\u0011\u001d\t\u0019\u0002\u0003a\u0001\u0003+\t\u0011\u0002\\1cK2d\u0015n\u001d;\u0011\r\u0005]\u0011\u0011EA\u0013\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003?!\u0013AC2pY2,7\r^5p]&!\u00111EA\r\u0005\u0019\u0011UO\u001a4feB\u00191/a\n\n\t\u0005%\u0012\u0011\u0001\u0002\t\u001b\u0006\u0004XI\u001c;ss\u0006\u0011r-\u001a;WC2,XM\u0012:p[R+gn]8s)\u0011\ty#!\u000e\u0011\u0007\r\n\t$C\u0002\u00024\u0011\u00121!\u00118z\u0011\u001d\t9$\u0003a\u0001\u0003s\tAB^1mk\u0016\u001cH+\u001a8t_J\u00042a]A\u001e\u0013\u0011\ti$!\u0001\u0003\u001b\u0019cw.\u0019;4eQ+gn]8s\u0003\u001d\t7mY3qiN,\u0012AT\u0001\tC\u000e\u001cW\r\u001d;tA\u0005y\u0002K]8u_\n,hMU3ta>t7/\u001a*po\u0012+7/\u001a:jC2L'0\u001a:\u0011\u0005ik1\u0003B\u0007#\u0003\u0017\u00022aIA'\u0013\r\ty\u0005\n\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003\u000f\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCAA,U\ry\u0014\u0011L\u0016\u0003\u00037\u0002B!!\u0018\u0002h5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\r\u0013\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002j\u0005}#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\u0007\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\t1\fgn\u001a\u0006\u0003\u0003s\nAA[1wC&!\u0011QPA:\u0005\u0019y%M[3di\u0002")
public class ProtobufResponseRowDeserializer
implements ResponseRowDeserializer {
    private final StructType schema;
    private final Option<Seq<String>> protobufKeys;
    private final String accepts;

    public static Option<Seq<String>> $lessinit$greater$default$2() {
        return ProtobufResponseRowDeserializer$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public StructType schema() {
        return this.schema;
    }

    public Option<Seq<String>> protobufKeys() {
        return this.protobufKeys;
    }

    @Override
    public Iterator<Row> deserializeResponse(byte[] responseData) {
        Iterator<RecordProto2.Record> recordIterator = ProtobufConverter$.MODULE$.recordIOByteArrayToProtobufs(responseData);
        ListBuffer rowList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (recordIterator.hasNext()) {
            rowList.$plus$eq((Object)this.protobufToRow((RecordProto2.Record)recordIterator.next()));
        }
        return rowList.toIterator();
    }

    private Row protobufToRow(RecordProto2.Record record) {
        ListBuffer rowValues = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        List<RecordProto2.MapEntry> labelList = record.getLabelList();
        ((IterableLike)this.protobufKeys().getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.wrapRefArray((Object[])this.schema().fieldNames()))).foreach((Function1 & Serializable & scala.Serializable)fieldName -> {
            RecordProto2.Value value = this.getValueFromLabelList((String)fieldName, (Buffer<RecordProto2.MapEntry>)((Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(labelList).asScala()));
            Object dataValue = this.getValueFromTensor(value.getFloat32Tensor());
            return rowValues.$plus$eq(dataValue);
        });
        if (this.schema().fields().length > ((Object[])rowValues.toArray(ClassTag$.MODULE$.Any())).length) {
            throw new IllegalArgumentException(new StringBuilder(53).append("Expected ").append(this.schema().fields().length).append(" entries to fit").append(" schema ").append(this.schema()).append(", received ").append(((Object[])rowValues.toArray(ClassTag$.MODULE$.Any())).length).append(" entries: ").append(rowValues.toList()).toString());
        }
        return new GenericRowWithSchema((Object[])rowValues.toArray(ClassTag$.MODULE$.Any()), this.schema());
    }

    private RecordProto2.Value getValueFromLabelList(String fieldName, Buffer<RecordProto2.MapEntry> labelList) {
        Buffer mapEntryList = (Buffer)labelList.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ProtobufResponseRowDeserializer.$anonfun$getValueFromLabelList$1(fieldName, x$1)));
        Predef$.MODULE$.require(mapEntryList.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Couldn't find field ").append(fieldName).append(" in ").append(labelList).toString());
        return ((RecordProto2.MapEntry)mapEntryList.head()).getValue();
    }

    private Object getValueFromTensor(RecordProto2.Float32Tensor valuesTensor) {
        int valuesCount = valuesTensor.getValuesCount();
        Predef$.MODULE$.require(valuesCount > 0, (Function0 & Serializable & scala.Serializable)() -> "Can't get value from deserialized tensor: values list is empty.");
        if (valuesCount == 1) {
            return BoxesRunTime.boxToDouble((double)valuesTensor.getValues(0));
        }
        int keyCount = valuesTensor.getKeysCount();
        double[] values = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(valuesTensor.getValuesList()).asScala()).toArray(ClassTag$.MODULE$.apply(Float.class)))).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Float2float(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        if (keyCount > 0) {
            Predef$.MODULE$.require(valuesTensor.getShapeCount() == 1, (Function0 & Serializable & scala.Serializable)() -> "Cannot deserialize tensor to vector. Shape list has more than one value.");
            int[] indices = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(valuesTensor.getKeysList()).asScala()).toArray(ClassTag$.MODULE$.apply(Long.class)))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ProtobufResponseRowDeserializer.$anonfun$getValueFromTensor$4(x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            return new SparseVector((int)valuesTensor.getShape(0), indices, values);
        }
        return new DenseVector(values);
    }

    @Override
    public String accepts() {
        return this.accepts;
    }

    public static final /* synthetic */ boolean $anonfun$getValueFromLabelList$1(String fieldName$1, RecordProto2.MapEntry x$1) {
        String string = x$1.getKey();
        String string2 = fieldName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$getValueFromTensor$4(Long x$3) {
        return (int)Predef$.MODULE$.Long2long(x$3);
    }

    public ProtobufResponseRowDeserializer(StructType schema, Option<Seq<String>> protobufKeys) {
        this.schema = schema;
        this.protobufKeys = protobufKeys;
        this.accepts = package$ContentTypes$.MODULE$.PROTOBUF();
    }
}

