/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.SearchRecord;

@SdkInternalApi
public class SearchRecordMarshaller {
    private static final MarshallingInfo<StructuredPojo> TRAININGJOB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingJob").build();
    private static final MarshallingInfo<StructuredPojo> EXPERIMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Experiment").build();
    private static final MarshallingInfo<StructuredPojo> TRIAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Trial").build();
    private static final MarshallingInfo<StructuredPojo> TRIALCOMPONENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrialComponent").build();
    private static final MarshallingInfo<StructuredPojo> ENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Endpoint").build();
    private static final MarshallingInfo<StructuredPojo> MODELPACKAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelPackage").build();
    private static final MarshallingInfo<StructuredPojo> MODELPACKAGEGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelPackageGroup").build();
    private static final MarshallingInfo<StructuredPojo> PIPELINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pipeline").build();
    private static final MarshallingInfo<StructuredPojo> PIPELINEEXECUTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PipelineExecution").build();
    private static final MarshallingInfo<StructuredPojo> FEATUREGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FeatureGroup").build();
    private static final MarshallingInfo<StructuredPojo> PROJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Project").build();
    private static final MarshallingInfo<StructuredPojo> FEATUREMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FeatureMetadata").build();
    private static final SearchRecordMarshaller instance = new SearchRecordMarshaller();

    public static SearchRecordMarshaller getInstance() {
        return instance;
    }

    public void marshall(SearchRecord searchRecord, ProtocolMarshaller protocolMarshaller) {
        if (searchRecord == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)searchRecord.getTrainingJob(), TRAININGJOB_BINDING);
            protocolMarshaller.marshall((Object)searchRecord.getExperiment(), EXPERIMENT_BINDING);
            protocolMarshaller.marshall((Object)searchRecord.getTrial(), TRIAL_BINDING);
            protocolMarshaller.marshall((Object)searchRecord.getTrialComponent(), TRIALCOMPONENT_BINDING);
            protocolMarshaller.marshall((Object)searchRecord.getEndpoint(), ENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)searchRecord.getModelPackage(), MODELPACKAGE_BINDING);
            protocolMarshaller.marshall((Object)searchRecord.getModelPackageGroup(), MODELPACKAGEGROUP_BINDING);
            protocolMarshaller.marshall((Object)searchRecord.getPipeline(), PIPELINE_BINDING);
            protocolMarshaller.marshall((Object)searchRecord.getPipelineExecution(), PIPELINEEXECUTION_BINDING);
            protocolMarshaller.marshall((Object)searchRecord.getFeatureGroup(), FEATUREGROUP_BINDING);
            protocolMarshaller.marshall((Object)searchRecord.getProject(), PROJECT_BINDING);
            protocolMarshaller.marshall((Object)searchRecord.getFeatureMetadata(), FEATUREMETADATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

