# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['fastapi_admin', 'fastapi_admin.routes']

package_data = \
{'': ['*']}

install_requires = \
['aiomysql',
 'aiosqlite',
 'bcrypt',
 'colorama',
 'fastapi',
 'jinja2',
 'passlib',
 'prompt_toolkit',
 'pyjwt',
 'python-dotenv',
 'python-rapidjson',
 'tortoise-orm',
 'uvicorn',
 'xlsxwriter']

extras_require = \
{'uvloop': ['uvloop']}

entry_points = \
{'console_scripts': ['fastapi-admin = fastapi_admin.cli:main']}

setup_kwargs = {
    'name': 'fastapi-admin',
    'version': '0.3.0',
    'description': 'Fast Admin Dashboard based on fastapi and tortoise-orm and rest-admin.',
    'long_description': '# FastAPI Admin\n\n[![image](https://img.shields.io/pypi/v/fastapi-admin.svg?style=flat)](https://pypi.python.org/pypi/fastapi-admin)\n[![image](https://img.shields.io/github/license/long2ice/fastapi-admin)](https://github.com/long2ice/fastapi-admin)\n[![image](https://github.com/long2ice/fastapi-admin/workflows/gh-pages/badge.svg)](https://github.com/long2ice/fastapi-admin/actions?query=workflow:gh-pages)\n[![image](https://github.com/long2ice/fastapi-admin/workflows/pypi/badge.svg)](https://github.com/long2ice/fastapi-admin/actions?query=workflow:pypi)\n\n<a href="https://tracking.gitads.io/?repo=fastapi-admin"><img src="https://images.gitads.io/fastapi-admin" alt="GitAds"/></a>\n\n[中文文档](https://blog.long2ice.cn/2020/05/fastapi-admin%E5%BF%AB%E9%80%9F%E6%90%AD%E5%BB%BA%E5%9F%BA%E4%BA%8Efastapi%E4%B8%8Etortoise-orm%E7%9A%84%E7%AE%A1%E7%90%86%E5%90%8E%E5%8F%B0/)\n\n## Introduction\n\nFastAPI-Admin is a admin dashboard based on\n[fastapi](https://github.com/tiangolo/fastapi) and\n[tortoise-orm](https://github.com/tortoise/tortoise-orm).\n\nFastAPI-Admin provide crud feature out-of-the-box with just a few\nconfig.\n\n## Live Demo\n\nCheck a live Demo here\n[https://fastapi-admin.long2ice.cn](https://fastapi-admin.long2ice.cn/).\n\n- username: `admin`\n- password: `123456`\n\nData in database will restore every day.\n\n## Screenshots\n\n![image](https://github.com/long2ice/fastapi-admin/raw/master/images/login.png)\n\n![image](https://github.com/long2ice/fastapi-admin/raw/master/images/list.png)\n\n![image](https://github.com/long2ice/fastapi-admin/raw/master/images/view.png)\n\n![image](https://github.com/long2ice/fastapi-admin/raw/master/images/create.png)\n\n## Requirements\n\n- [FastAPI](https://github.com/tiangolo/fastapi) framework as your\n  backend framework.\n- [Tortoise-ORM](https://github.com/tortoise/tortoise-orm) as your orm\n  framework, by the way, which is best asyncio orm so far and I\\\'m one\n  of the contributors😋.\n\n## Quick Start\n\n### Run Example Local\n\nLook at\n[examples](https://github.com/long2ice/fastapi-admin/tree/master/examples).\n\n1. `git clone https://github.com/long2ice/fastapi-admin.git`.\n2. create database `fastapi-admin` and import from\n   `examples/example.sql`.\n3. run `poetry install`, you must install [poetry](https://github.com/python-poetry/poetry) first.\n4. `env DATABASE_URL=mysql://root:123456@127.0.0.1:3306/fastapi-admin PYTHONPATH=./ python3 examples/main.py`, then\n   you can see:\n\n```log\nINFO:     Uvicorn running on http://127.0.0.1:8000 (Press CTRL+C to quit)\nINFO:     Started reloader process [89005]\nINFO:     Started server process [89009]\nINFO:     Waiting for application startup.\nINFO:     Tortoise-ORM startup\n    connections: {\'default\': \'mysql://root:123456@127.0.0.1:3306/fastapi-admin\'}\n    apps: {\'models\': {\'models\': [\'examples.models\'], \'default_connection\': \'default\'}}\nINFO:     Tortoise-ORM started, {\'default\': <tortoise.backends.mysql.client.MySQLClient object at 0x110ed6760>}, {\'models\': {\'Category\': <class \'examples.models.Category\'>, \'Product\': <class \'examples.models.Product\'>, \'User\': <class \'examples.models.User\'>}}\nINFO:     Tortoise-ORM generating schema\nINFO:     Application startup complete.\n```\n\n### Backend Integration\n\n```shell\n> pip3 install fastapi-admin\n```\n\n```python\nfrom fastapi_admin.factory import app as admin_app\n\nfast_app = FastAPI()\n\nregister_tortoise(fast_app, config=TORTOISE_ORM, generate_schemas=True)\n\nfast_app.mount(\'/admin\', admin_app)\n\n@fast_app.on_event(\'startup\')\nasync def startup():\n    admin_app.init(\n        admin_secret="test",\n        permission=True,\n        site=Site(\n            name="FastAPI-Admin DEMO",\n            login_footer="FASTAPI ADMIN - FastAPI Admin Dashboard",\n            login_description="FastAPI Admin Dashboard",\n            locale="en-US",\n            locale_switcher=True,\n            theme_switcher=True,\n        ),\n    )\n```\n\n### Front\n\nSee\n[restful-admin](https://github.com/long2ice/restful-admin)\nfor reference.\n\n## Features\n\n### Builtin Auth And Permissions Control\n\nYou should inherit `fastapi_admin.models.AbstractUser`,`fastapi_admin.models.AbstractPermission`,`fastapi_admin.models.AbstractRole` and add extra fields.\n\n```python\nfrom fastapi_admin.models import AbstractUser,AbstractPermission,AbstractRole\n\nclass AdminUser(AbstractUser,Model):\n    is_active = fields.BooleanField(default=False, description=\'Is Active\')\n    is_superuser = fields.BooleanField(default=False, description=\'Is Superuser\')\n    status = fields.IntEnumField(Status, description=\'User Status\')\n    created_at = fields.DatetimeField(auto_now_add=True)\n    updated_at = fields.DatetimeField(auto_now=True)\n\nclass Permission(AbstractPermission):\n    pass\n\nclass Role(AbstractRole):\n    pass\n```\n\nAnd set `permission=True` to active it:\n\n```python\nadmin_app.init(\n    ...\n    permission=True,\n    site=Site(\n        ...\n    ),\n)\n```\n\nAnd register permissions and createsuperuser:\n\n```shell\n> fastapi-admin -h\nusage: fastapi-admin [-h] -c CONFIG {register_permissions,createsuperuser} ...\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -c CONFIG, --config CONFIG\n                        Tortoise-orm config dict import path,like settings.TORTOISE_ORM.\n\nsubcommands:\n  {register_permissions,createsuperuser}\n```\n\n### Custom Login\n\nYou can write your own login view logic:\n\n```python\nadmin_app.init(\n    ...\n    login_view="examples.routes.login"\n)\n```\n\nAnd must return json like:\n\n```json\n{\n  "user": {\n    "username": "admin",\n    "is_superuser": false,\n    "avatar": "https://avatars2.githubusercontent.com/u/13377178?s=460&u=d150d522579f41a52a0b3dd8ea997e0161313b6e&v=4"\n  },\n  "token": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ1c2VyX2lkIjoyfQ.HSlcYkOEQewxyPuaqcVwCcw_wkbLB50Ws1-ZxfPoLAQ"\n}\n```\n\n### Enum Support\n\nWhen you define a enum field of tortoise-orm,like `IntEnumField`,you can\ninherit `fastapi_admin.enums.EnumMixin` and impl `choices()` method,\nFastAPI-Admin will auto read and display and render a `select` widget in\nfront.\n\n```python\nclass Status(EnumMixin, IntEnum):\n    on = 1\n    off = 2\n\n    @classmethod\n    def choices(cls):\n        return {\n            cls.on: \'ON\',\n            cls.off: \'OFF\'\n        }\n```\n\n### Help Text\n\nFastAPI-Admin will auto read `description` defined in tortoise-orm model\n`Field` and display in front with form help text.\n\n### ForeignKeyField Support\n\nIf `ForeignKeyField` not passed in `menu.raw_id_fields`,FastAPI-Admin\nwill get all related objects and display `select` in front with\n`Model.__str__`.\n\n### ManyToManyField Support\n\nFastAPI-Admin will render `ManyToManyField` with multiple `select` in\n`form` edit with `Model.__str__`.\n\n### JSONField Render\n\nFastAPI-Admin will render `JSONField` with `jsoneditor` as beauty\ninterface.\n\n### Search Fields\n\nDefined `menu.search_fields` in `menu` will render a search form by\nfields.\n\n### Xlsx Export\n\nFastAPI-Admin can export searched data to excel file when define\n`export=True` in `menu`.\n\n### Bulk Actions\n\nCurrent FastAPI-Admin support builtin bulk action `delete_all`,if you\nwant write your own bulk actions:\n\n1. pass `bulk_actions` in `Menu`,example:\n\n```python\nMenu(\n    ...\n    bulk_actions=[{\n        \'value\': \'delete\', # this is fastapi router path param.\n        \'text\': \'delete_all\', # this will show in front.\n    }]\n)\n```\n\n2. write fastapi route,example:\n\n```python\nfrom fastapi_admin.schemas import BulkIn\nfrom fastapi_admin.factory import app as admin_app\n\n@admin_app.post(\n    \'/rest/{resource}/bulk/delete\' # `delete` is defined in Menu before.\n)\nasync def bulk_delete(\n        bulk_in: BulkIn,\n        model=Depends(get_model)\n):\n    await model.filter(pk__in=bulk_in.pk_list).delete()\n    return {\'success\': True}\n```\n\n### Default Menus\n\nDefault, FastAPI-Admin provide default menus by your models, without\ndoing tedious works.\n\n### Table Variant\n\nYou can define `RowVariant` and `CellVariants` in `computed` of `tortoise-orm`, which will effect table rows and cells variant.\n\n```python\nclass User(AbstractUser):\n    last_login = fields.DatetimeField(description="Last Login", default=datetime.datetime.now)\n    avatar = fields.CharField(max_length=200, default="")\n    intro = fields.TextField(default="")\n    created_at = fields.DatetimeField(auto_now_add=True)\n\n    def __str__(self):\n        return f"{self.pk}#{self.username}"\n\n    def rowVariant(self) -> str:\n        if not self.is_active:\n            return "warning"\n        return ""\n\n    def cellVariants(self) -> dict:\n        if self.is_active:\n            return {\n                "intro": "info",\n            }\n        return {}\n\n    class PydanticMeta:\n        computed = ("rowVariant", "cellVariants")\n```\n\n## Deployment\n\nDeploy fastapi app by gunicorn+uvicorn or reference\n<https://fastapi.tiangolo.com/deployment/>.\n\n## Restful API Docs\n\nSee [restful api](https://api-fastapi-admin.long2ice.cn:8443/admin/docs)\ndocs.\n\n## Documents\n\nSee [documents](https://fastapi-admin-docs.long2ice.cn) for reference.\n\n## Support this project\n\n- Just give a star!\n- Donation.\n- Click [Ads](https://tracking.gitads.io/?repo=fastapi-admin)\n\n### AliPay\n\n<img width="200" src="https://github.com/long2ice/fastapi-admin/raw/dev/images/alipay.jpeg"/>\n\n### WeChat Pay\n\n<img width="200" src="https://github.com/long2ice/fastapi-admin/raw/dev/images/wechatpay.jpeg"/>\n\n### PayPal\n\nDonate money by [paypal](https://www.paypal.me/long2ice) to my\naccount long2ice.\n\n## ThanksTo\n\n- [fastapi](https://github.com/tiangolo/fastapi) ,high performance\n  async api framework.\n- [tortoise-orm](https://github.com/tortoise/tortoise-orm) ,familiar\n  asyncio ORM for python.\n\n## License\n\nThis project is licensed under the\n[Apache-2.0](https://github.com/long2ice/fastapi-admin/blob/master/LICENSE)\nLicense.\n',
    'author': 'long2ice',
    'author_email': 'long2ice@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/long2ice/fastapi-admin',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
