"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontToS3 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
class CloudFrontToS3 extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the CloudFrontToS3 class.
     * @param {Construct} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {CloudFrontToS3Props} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        let bucket;
        if (!props.existingBucketObj) {
            const buildS3BucketResponse = defaults.buildS3Bucket(this, {
                bucketProps: props.bucketProps,
                loggingBucketProps: props.loggingBucketProps,
                logS3AccessLogs: props.logS3AccessLogs
            });
            this.s3Bucket = buildS3BucketResponse.bucket;
            this.s3LoggingBucket = buildS3BucketResponse.loggingBucket;
            bucket = this.s3Bucket;
        }
        else {
            bucket = props.existingBucketObj;
        }
        this.s3BucketInterface = bucket;
        const cloudFrontDistributionForS3Response = defaults.CloudFrontDistributionForS3(this, this.s3BucketInterface, props.cloudFrontDistributionProps, props.insertHttpSecurityHeaders, props.originPath, props.cloudFrontLoggingBucketProps, props.responseHeadersPolicyProps);
        this.cloudFrontWebDistribution = cloudFrontDistributionForS3Response.distribution;
        this.cloudFrontFunction = cloudFrontDistributionForS3Response.cloudfrontFunction;
        this.cloudFrontLoggingBucket = cloudFrontDistributionForS3Response.loggingBucket;
    }
}
exports.CloudFrontToS3 = CloudFrontToS3;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontToS3[_a] = { fqn: "@aws-solutions-constructs/aws-cloudfront-s3.CloudFrontToS3", version: "2.35.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQWVBLHdGQUF3RjtBQUN4RiwyQ0FBdUM7QUFDdkMsMkRBQTJEO0FBeUUzRCxNQUFhLGNBQWUsU0FBUSxzQkFBUztJQVEzQzs7Ozs7OztPQU9HO0lBQ0gsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEwQjtRQUNsRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLFFBQVEsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFM0IsSUFBSSxNQUFrQixDQUFDO1FBRXZCLElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLEVBQUU7WUFDNUIsTUFBTSxxQkFBcUIsR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLElBQUksRUFBRTtnQkFDekQsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO2dCQUM5QixrQkFBa0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCO2dCQUM1QyxlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7YUFDdkMsQ0FBQyxDQUFDO1lBQ0gsSUFBSSxDQUFDLFFBQVEsR0FBRyxxQkFBcUIsQ0FBQyxNQUFNLENBQUM7WUFDN0MsSUFBSSxDQUFDLGVBQWUsR0FBRyxxQkFBcUIsQ0FBQyxhQUFhLENBQUM7WUFDM0QsTUFBTSxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUM7U0FDeEI7YUFBTTtZQUNMLE1BQU0sR0FBRyxLQUFLLENBQUMsaUJBQWlCLENBQUM7U0FDbEM7UUFFRCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsTUFBTSxDQUFDO1FBRWhDLE1BQU0sbUNBQW1DLEdBQUcsUUFBUSxDQUFDLDJCQUEyQixDQUM5RSxJQUFJLEVBQ0osSUFBSSxDQUFDLGlCQUFpQixFQUN0QixLQUFLLENBQUMsMkJBQTJCLEVBQ2pDLEtBQUssQ0FBQyx5QkFBeUIsRUFDL0IsS0FBSyxDQUFDLFVBQVUsRUFDaEIsS0FBSyxDQUFDLDRCQUE0QixFQUNsQyxLQUFLLENBQUMsMEJBQTBCLENBQ2pDLENBQUM7UUFDRixJQUFJLENBQUMseUJBQXlCLEdBQUcsbUNBQW1DLENBQUMsWUFBWSxDQUFDO1FBQ2xGLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxtQ0FBbUMsQ0FBQyxrQkFBa0IsQ0FBQztRQUNqRixJQUFJLENBQUMsdUJBQXVCLEdBQUcsbUNBQW1DLENBQUMsYUFBYSxDQUFDO0lBQ25GLENBQUM7O0FBakRILHdDQW1EQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbmltcG9ydCAqIGFzIGNsb3VkZnJvbnQgZnJvbSAnYXdzLWNkay1saWIvYXdzLWNsb3VkZnJvbnQnO1xuaW1wb3J0ICogYXMgczMgZnJvbSAnYXdzLWNkay1saWIvYXdzLXMzJztcbi8vIE5vdGU6IFRvIGVuc3VyZSBDREt2MiBjb21wYXRpYmlsaXR5LCBrZWVwIHRoZSBpbXBvcnQgc3RhdGVtZW50IGZvciBDb25zdHJ1Y3Qgc2VwYXJhdGVcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgZGVmYXVsdHMgZnJvbSAnQGF3cy1zb2x1dGlvbnMtY29uc3RydWN0cy9jb3JlJztcblxuLyoqXG4gKiBAc3VtbWFyeSBUaGUgcHJvcGVydGllcyBmb3IgdGhlIENsb3VkRnJvbnRUb1MzIENvbnN0cnVjdFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENsb3VkRnJvbnRUb1MzUHJvcHMge1xuICAvKipcbiAgICogRXhpc3RpbmcgaW5zdGFuY2Ugb2YgUzMgQnVja2V0IG9iamVjdCwgcHJvdmlkaW5nIGJvdGggdGhpcyBhbmQgYGJ1Y2tldFByb3BzYCB3aWxsIGNhdXNlIGFuIGVycm9yLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IGV4aXN0aW5nQnVja2V0T2JqPzogczMuSUJ1Y2tldCxcbiAgLyoqXG4gICAqIE9wdGlvbmFsIHVzZXIgcHJvdmlkZWQgcHJvcHMgdG8gb3ZlcnJpZGUgdGhlIGRlZmF1bHQgcHJvcHMgZm9yIHRoZSBTMyBCdWNrZXQuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gRGVmYXVsdCBwcm9wcyBhcmUgdXNlZFxuICAgKi9cbiAgcmVhZG9ubHkgYnVja2V0UHJvcHM/OiBzMy5CdWNrZXRQcm9wcyxcbiAgLyoqXG4gICAqIE9wdGlvbmFsIHVzZXIgcHJvdmlkZWQgcHJvcHMgdG8gb3ZlcnJpZGUgdGhlIGRlZmF1bHQgcHJvcHNcbiAgICpcbiAgICogQGRlZmF1bHQgLSBEZWZhdWx0IHByb3BzIGFyZSB1c2VkXG4gICAqL1xuICByZWFkb25seSBjbG91ZEZyb250RGlzdHJpYnV0aW9uUHJvcHM/OiBjbG91ZGZyb250LkRpc3RyaWJ1dGlvblByb3BzIHwgYW55LFxuICAvKipcbiAgICogT3B0aW9uYWwgdXNlciBwcm92aWRlZCBwcm9wcyB0byB0dXJuIG9uL29mZiB0aGUgYXV0b21hdGljIGluamVjdGlvbiBvZiBiZXN0IHByYWN0aWNlIEhUVFBcbiAgICogc2VjdXJpdHkgaGVhZGVycyBpbiBhbGwgcmVzcG9uc2VzIGZyb20gY2xvdWRmcm9udC5cbiAgICogVHVybmluZyB0aGlzIG9uIHdpbGwgaW5qZWN0IGRlZmF1bHQgaGVhZGVycyBhbmQgaXMgbXV0dWFsbHkgZXhjbHVzaXZlIHdpdGggcGFzc2luZyBjdXN0b20gc2VjdXJpdHkgaGVhZGVyc1xuICAgKiB2aWEgdGhlIHJlc3BvbnNlSGVhZGVyc1BvbGljeVByb3BzIHBhcmFtZXRlci5cbiAgICpcbiAgICogQGRlZmF1bHQgLSB0cnVlXG4gICAqL1xuICByZWFkb25seSBpbnNlcnRIdHRwU2VjdXJpdHlIZWFkZXJzPzogYm9vbGVhbjtcbiAgLyoqXG4gICAqIE9wdGlvbmFsIHVzZXIgcHJvdmlkZWQgY29uZmlndXJhdGlvbiB0aGF0IGNsb3VkZnJvbnQgYXBwbGllcyB0byBhbGwgaHR0cCByZXNwb25zZXMuXG4gICAqIENhbiBiZSB1c2VkIHRvIHBhc3MgYSBjdXN0b20gUmVzcG9uc2VTZWN1cml0eUhlYWRlcnNCZWhhdmlvciwgUmVzcG9uc2VDdXN0b21IZWFkZXJzQmVoYXZpb3Igb3JcbiAgICogUmVzcG9uc2VIZWFkZXJzQ29yc0JlaGF2aW9yIHRvIHRoZSBjbG91ZGZyb250IGRpc3RyaWJ1dGlvbi5cbiAgICpcbiAgICogUGFzc2luZyBhIGN1c3RvbSBSZXNwb25zZVNlY3VyaXR5SGVhZGVyc0JlaGF2aW9yIGlzIG11dHVhbGx5IGV4Y2x1c2l2ZSB3aXRoIHR1cm5pbmcgb24gdGhlIGRlZmF1bHQgc2VjdXJpdHkgaGVhZGVyc1xuICAgKiB2aWEgYGluc2VydEh0dHBTZWN1cml0eUhlYWRlcnNgIHByb3AuIFdpbGwgdGhyb3cgYW4gZXJyb3IgaWYgYm90aCBgaW5zZXJ0SHR0cFNlY3VyaXR5SGVhZGVyc2AgaXMgc2V0IHRvIGB0cnVlYFxuICAgKiBhbmQgUmVzcG9uc2VTZWN1cml0eUhlYWRlcnNCZWhhdmlvciBpcyBwYXNzZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdW5kZWZpbmVkXG4gICAqL1xuICByZWFkb25seSByZXNwb25zZUhlYWRlcnNQb2xpY3lQcm9wcz86IGNsb3VkZnJvbnQuUmVzcG9uc2VIZWFkZXJzUG9saWN5UHJvcHNcbiAgLyoqXG4gICAqIE9wdGlvbmFsIHVzZXIgcHJvdmlkZWQgcHJvcHMgdG8gcHJvdmlkZSBhbiBvcmlnaW5QYXRoIHRoYXQgQ2xvdWRGcm9udCBhcHBlbmRzIHRvIHRoZVxuICAgKiBvcmlnaW4gZG9tYWluIG5hbWUgd2hlbiBDbG91ZEZyb250IHJlcXVlc3RzIGNvbnRlbnQgZnJvbSB0aGUgb3JpZ2luLlxuICAgKiBUaGUgc3RyaW5nIHNob3VsZCBzdGFydCB3aXRoIGEgYC9gLCBmb3IgZXhhbXBsZSBgL3Byb2R1Y3Rpb25gLlxuICAgKiBAZGFmYXVsdCA9ICcvJ1xuICAgKi9cbiAgcmVhZG9ubHkgb3JpZ2luUGF0aD86IHN0cmluZyxcbiAgLyoqXG4gICAqIE9wdGlvbmFsIHVzZXIgcHJvdmlkZWQgcHJvcHMgdG8gb3ZlcnJpZGUgdGhlIGRlZmF1bHQgcHJvcHMgZm9yIHRoZSBTMyBMb2dnaW5nIEJ1Y2tldC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBEZWZhdWx0IHByb3BzIGFyZSB1c2VkXG4gICAqL1xuICByZWFkb25seSBsb2dnaW5nQnVja2V0UHJvcHM/OiBzMy5CdWNrZXRQcm9wc1xuICAvKipcbiAgICogT3B0aW9uYWwgdXNlciBwcm92aWRlZCBwcm9wcyB0byBvdmVycmlkZSB0aGUgZGVmYXVsdCBwcm9wcyBmb3IgdGhlIENsb3VkRnJvbnQgTG9nZ2luZyBCdWNrZXQuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gRGVmYXVsdCBwcm9wcyBhcmUgdXNlZFxuICAgKi9cbiAgcmVhZG9ubHkgY2xvdWRGcm9udExvZ2dpbmdCdWNrZXRQcm9wcz86IHMzLkJ1Y2tldFByb3BzXG4gIC8qKlxuICAgKiBXaGV0aGVyIHRvIHR1cm4gb24gQWNjZXNzIExvZ3MgZm9yIHRoZSBTMyBidWNrZXQgd2l0aCB0aGUgYXNzb2NpYXRlZCBzdG9yYWdlIGNvc3RzLlxuICAgKiBFbmFibGluZyBBY2Nlc3MgTG9nZ2luZyBpcyBhIGJlc3QgcHJhY3RpY2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgbG9nUzNBY2Nlc3NMb2dzPzogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGNsYXNzIENsb3VkRnJvbnRUb1MzIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IGNsb3VkRnJvbnRXZWJEaXN0cmlidXRpb246IGNsb3VkZnJvbnQuRGlzdHJpYnV0aW9uO1xuICBwdWJsaWMgcmVhZG9ubHkgY2xvdWRGcm9udEZ1bmN0aW9uPzogY2xvdWRmcm9udC5GdW5jdGlvbjtcbiAgcHVibGljIHJlYWRvbmx5IGNsb3VkRnJvbnRMb2dnaW5nQnVja2V0PzogczMuQnVja2V0O1xuICBwdWJsaWMgcmVhZG9ubHkgczNCdWNrZXRJbnRlcmZhY2U6IHMzLklCdWNrZXQ7XG4gIHB1YmxpYyByZWFkb25seSBzM0J1Y2tldD86IHMzLkJ1Y2tldDtcbiAgcHVibGljIHJlYWRvbmx5IHMzTG9nZ2luZ0J1Y2tldD86IHMzLkJ1Y2tldDtcblxuICAvKipcbiAgICogQHN1bW1hcnkgQ29uc3RydWN0cyBhIG5ldyBpbnN0YW5jZSBvZiB0aGUgQ2xvdWRGcm9udFRvUzMgY2xhc3MuXG4gICAqIEBwYXJhbSB7Q29uc3RydWN0fSBzY29wZSAtIHJlcHJlc2VudHMgdGhlIHNjb3BlIGZvciBhbGwgdGhlIHJlc291cmNlcy5cbiAgICogQHBhcmFtIHtzdHJpbmd9IGlkIC0gdGhpcyBpcyBhIGEgc2NvcGUtdW5pcXVlIGlkLlxuICAgKiBAcGFyYW0ge0Nsb3VkRnJvbnRUb1MzUHJvcHN9IHByb3BzIC0gdXNlciBwcm92aWRlZCBwcm9wcyBmb3IgdGhlIGNvbnN0cnVjdFxuICAgKiBAc2luY2UgMC44LjBcbiAgICogQGFjY2VzcyBwdWJsaWNcbiAgICovXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDbG91ZEZyb250VG9TM1Byb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICBkZWZhdWx0cy5DaGVja1Byb3BzKHByb3BzKTtcblxuICAgIGxldCBidWNrZXQ6IHMzLklCdWNrZXQ7XG5cbiAgICBpZiAoIXByb3BzLmV4aXN0aW5nQnVja2V0T2JqKSB7XG4gICAgICBjb25zdCBidWlsZFMzQnVja2V0UmVzcG9uc2UgPSBkZWZhdWx0cy5idWlsZFMzQnVja2V0KHRoaXMsIHtcbiAgICAgICAgYnVja2V0UHJvcHM6IHByb3BzLmJ1Y2tldFByb3BzLFxuICAgICAgICBsb2dnaW5nQnVja2V0UHJvcHM6IHByb3BzLmxvZ2dpbmdCdWNrZXRQcm9wcyxcbiAgICAgICAgbG9nUzNBY2Nlc3NMb2dzOiBwcm9wcy5sb2dTM0FjY2Vzc0xvZ3NcbiAgICAgIH0pO1xuICAgICAgdGhpcy5zM0J1Y2tldCA9IGJ1aWxkUzNCdWNrZXRSZXNwb25zZS5idWNrZXQ7XG4gICAgICB0aGlzLnMzTG9nZ2luZ0J1Y2tldCA9IGJ1aWxkUzNCdWNrZXRSZXNwb25zZS5sb2dnaW5nQnVja2V0O1xuICAgICAgYnVja2V0ID0gdGhpcy5zM0J1Y2tldDtcbiAgICB9IGVsc2Uge1xuICAgICAgYnVja2V0ID0gcHJvcHMuZXhpc3RpbmdCdWNrZXRPYmo7XG4gICAgfVxuXG4gICAgdGhpcy5zM0J1Y2tldEludGVyZmFjZSA9IGJ1Y2tldDtcblxuICAgIGNvbnN0IGNsb3VkRnJvbnREaXN0cmlidXRpb25Gb3JTM1Jlc3BvbnNlID0gZGVmYXVsdHMuQ2xvdWRGcm9udERpc3RyaWJ1dGlvbkZvclMzKFxuICAgICAgdGhpcyxcbiAgICAgIHRoaXMuczNCdWNrZXRJbnRlcmZhY2UsXG4gICAgICBwcm9wcy5jbG91ZEZyb250RGlzdHJpYnV0aW9uUHJvcHMsXG4gICAgICBwcm9wcy5pbnNlcnRIdHRwU2VjdXJpdHlIZWFkZXJzLFxuICAgICAgcHJvcHMub3JpZ2luUGF0aCxcbiAgICAgIHByb3BzLmNsb3VkRnJvbnRMb2dnaW5nQnVja2V0UHJvcHMsXG4gICAgICBwcm9wcy5yZXNwb25zZUhlYWRlcnNQb2xpY3lQcm9wc1xuICAgICk7XG4gICAgdGhpcy5jbG91ZEZyb250V2ViRGlzdHJpYnV0aW9uID0gY2xvdWRGcm9udERpc3RyaWJ1dGlvbkZvclMzUmVzcG9uc2UuZGlzdHJpYnV0aW9uO1xuICAgIHRoaXMuY2xvdWRGcm9udEZ1bmN0aW9uID0gY2xvdWRGcm9udERpc3RyaWJ1dGlvbkZvclMzUmVzcG9uc2UuY2xvdWRmcm9udEZ1bmN0aW9uO1xuICAgIHRoaXMuY2xvdWRGcm9udExvZ2dpbmdCdWNrZXQgPSBjbG91ZEZyb250RGlzdHJpYnV0aW9uRm9yUzNSZXNwb25zZS5sb2dnaW5nQnVja2V0O1xuICB9XG5cbn1cbiJdfQ==