"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PloneHttpcache = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
class PloneHttpcache extends constructs_1.Construct {
    constructor(scope, id, options) {
        super(scope, id);
        let varnishVcl;
        if (!options.varnishVcl) {
            let vclPath;
            if (!options.varnishVclFile) {
                vclPath = path.join(__dirname, 'config', 'varnish.tpl.vcl');
            }
            else {
                vclPath = options.varnishVclFile;
            }
            varnishVcl = fs.readFileSync(vclPath, 'utf8');
        }
        else {
            varnishVcl = options.varnishVcl;
        }
        const httpcache = new cdk8s_1.Helm(this, 'httpcache', {
            // see https://github.com/mittwald/kube-httpcache/chart
            repo: 'https://helm.mittwald.de',
            chart: 'kube-httpcache',
            values: {
                replicaCount: 2,
                cache: {
                    // need to looks at the frontendWatch, do we need it?
                    frontendWatch: false,
                    backendWatch: false,
                    existingSecret: options.existingSecret ?? undefined,
                },
                vclTemplate: varnishVcl,
                extraEnvVars: [
                    { name: 'BACKEND_SERVICE_NAME', value: options.plone.backendServiceName },
                    { name: 'BACKEND_SERVICE_PORT', value: '8080' },
                    { name: 'BACKEND_SITE_ID', value: options.plone.siteId },
                    { name: 'FRONTEND_SERVICE_NAME', value: options.plone.frontendServiceName },
                    { name: 'FRONTEND_SERVICE_PORT', value: '3000' },
                ],
                // see https://github.com/mittwald/kube-httpcache/issues/253
                nodeSelector: {
                    'kubernetes.io/arch': 'amd64',
                },
                resources: {
                    limits: {
                        cpu: options.limitCpu || '500m',
                        memory: options.limitMemory || '500Mi',
                    },
                    requests: {
                        cpu: options.requestCpu || '100m',
                        memory: options.requestMemory || '100Mi',
                    },
                },
                rbac: {
                    enabled: false,
                },
                exporter: {
                    enabled: true,
                    resources: {
                        limits: {
                            cpu: '100m',
                            memory: '100Mi',
                        },
                        requests: {
                            cpu: '10m',
                            memory: '50Mi',
                        },
                    },
                },
                serviceMonitor: {
                    enabled: true,
                    scrapeSignaller: true,
                },
            },
        });
        const httpcacheService = httpcache.apiObjects.find((construct) => {
            if ((construct.kind === 'Service') && (construct.metadata.name?.endsWith('kube-httpcache'))) {
                return construct.name;
            }
            return undefined;
        });
        if (httpcacheService === undefined) {
            throw new Error('Could not find httpcache service');
        }
        this.httpcacheServiceName = httpcacheService.name;
    }
}
exports.PloneHttpcache = PloneHttpcache;
_a = JSII_RTTI_SYMBOL_1;
PloneHttpcache[_a] = { fqn: "@bluedynamics/cdk8s-plone.PloneHttpcache", version: "0.0.41" };
//# sourceMappingURL=data:application/json;base64,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