"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosServerlessKubernetesCluster = exports.RosManagedKubernetesCluster = exports.RosManagedEdgeKubernetesCluster = exports.RosKubernetesCluster = exports.RosClusterNodePool = exports.RosAnyCluster = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosAnyClusterProps`
 *
 * @param properties - the TypeScript properties of a `RosAnyClusterProps`
 *
 * @returns the result of the validation.
 */
function RosAnyClusterPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('clusterConfig', ros.requiredValidator)(properties.clusterConfig));
    errors.collect(ros.propertyValidator('clusterConfig', ros.hashValidator(ros.validateAny))(properties.clusterConfig));
    return errors.wrap('supplied properties not correct for "RosAnyClusterProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::AnyCluster` resource
 *
 * @param properties - the TypeScript properties of a `RosAnyClusterProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::AnyCluster` resource.
 */
// @ts-ignore TS6133
function rosAnyClusterPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosAnyClusterPropsValidator(properties).assertSuccess();
    }
    return {
        ClusterConfig: ros.hashMapper(ros.objectToRosTemplate)(properties.clusterConfig),
    };
}
/**
 * A ROS template type:  `ALIYUN::CS::AnyCluster`
 */
class RosAnyCluster extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CS::AnyCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosAnyCluster.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrApiServerSlbId = this.getAtt('APIServerSLBId');
        this.attrClusterId = this.getAtt('ClusterId');
        this.attrDefaultUserKubeConfig = this.getAtt('DefaultUserKubeConfig');
        this.attrNodes = this.getAtt('Nodes');
        this.attrPrivateUserKubConfig = this.getAtt('PrivateUserKubConfig');
        this.attrScalingConfigurationId = this.getAtt('ScalingConfigurationId');
        this.attrScalingGroupId = this.getAtt('ScalingGroupId');
        this.attrScalingRuleId = this.getAtt('ScalingRuleId');
        this.attrTaskId = this.getAtt('TaskId');
        this.attrWorkerRamRoleName = this.getAtt('WorkerRamRoleName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.clusterConfig = props.clusterConfig;
    }
    get rosProperties() {
        return {
            clusterConfig: this.clusterConfig,
        };
    }
    renderProperties(props) {
        return rosAnyClusterPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosAnyCluster = RosAnyCluster;
/**
 * The resource type name for this resource class.
 */
RosAnyCluster.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CS::AnyCluster";
/**
 * Determine whether the given properties match those of a `RosClusterNodePoolProps`
 *
 * @param properties - the TypeScript properties of a `RosClusterNodePoolProps`
 *
 * @returns the result of the validation.
 */
function RosClusterNodePoolPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('teeConfig', RosClusterNodePool_TeeConfigPropertyValidator)(properties.teeConfig));
    errors.collect(ros.propertyValidator('clusterId', ros.requiredValidator)(properties.clusterId));
    errors.collect(ros.propertyValidator('clusterId', ros.validateString)(properties.clusterId));
    errors.collect(ros.propertyValidator('nodePoolInfo', RosClusterNodePool_NodePoolInfoPropertyValidator)(properties.nodePoolInfo));
    errors.collect(ros.propertyValidator('kubernetesConfig', RosClusterNodePool_KubernetesConfigPropertyValidator)(properties.kubernetesConfig));
    errors.collect(ros.propertyValidator('count', ros.validateNumber)(properties.count));
    errors.collect(ros.propertyValidator('management', RosClusterNodePool_ManagementPropertyValidator)(properties.management));
    errors.collect(ros.propertyValidator('autoScaling', RosClusterNodePool_AutoScalingPropertyValidator)(properties.autoScaling));
    errors.collect(ros.propertyValidator('scalingGroup', ros.requiredValidator)(properties.scalingGroup));
    errors.collect(ros.propertyValidator('scalingGroup', RosClusterNodePool_ScalingGroupPropertyValidator)(properties.scalingGroup));
    return errors.wrap('supplied properties not correct for "RosClusterNodePoolProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool` resource
 *
 * @param properties - the TypeScript properties of a `RosClusterNodePoolProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool` resource.
 */
// @ts-ignore TS6133
function rosClusterNodePoolPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosClusterNodePoolPropsValidator(properties).assertSuccess();
    }
    return {
        ClusterId: ros.stringToRosTemplate(properties.clusterId),
        ScalingGroup: rosClusterNodePoolScalingGroupPropertyToRosTemplate(properties.scalingGroup),
        AutoScaling: rosClusterNodePoolAutoScalingPropertyToRosTemplate(properties.autoScaling),
        Count: ros.numberToRosTemplate(properties.count),
        KubernetesConfig: rosClusterNodePoolKubernetesConfigPropertyToRosTemplate(properties.kubernetesConfig),
        Management: rosClusterNodePoolManagementPropertyToRosTemplate(properties.management),
        NodePoolInfo: rosClusterNodePoolNodePoolInfoPropertyToRosTemplate(properties.nodePoolInfo),
        TeeConfig: rosClusterNodePoolTeeConfigPropertyToRosTemplate(properties.teeConfig),
    };
}
/**
 * A ROS template type:  `ALIYUN::CS::ClusterNodePool`
 */
class RosClusterNodePool extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CS::ClusterNodePool`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosClusterNodePool.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrNodePoolId = this.getAtt('NodePoolId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.clusterId = props.clusterId;
        this.scalingGroup = props.scalingGroup;
        this.autoScaling = props.autoScaling;
        this.count = props.count;
        this.kubernetesConfig = props.kubernetesConfig;
        this.management = props.management;
        this.nodePoolInfo = props.nodePoolInfo;
        this.teeConfig = props.teeConfig;
    }
    get rosProperties() {
        return {
            clusterId: this.clusterId,
            scalingGroup: this.scalingGroup,
            autoScaling: this.autoScaling,
            count: this.count,
            kubernetesConfig: this.kubernetesConfig,
            management: this.management,
            nodePoolInfo: this.nodePoolInfo,
            teeConfig: this.teeConfig,
        };
    }
    renderProperties(props) {
        return rosClusterNodePoolPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosClusterNodePool = RosClusterNodePool;
/**
 * The resource type name for this resource class.
 */
RosClusterNodePool.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CS::ClusterNodePool";
/**
 * Determine whether the given properties match those of a `AutoScalingProperty`
 *
 * @param properties - the TypeScript properties of a `AutoScalingProperty`
 *
 * @returns the result of the validation.
 */
function RosClusterNodePool_AutoScalingPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.eipBandwidth && (typeof properties.eipBandwidth) !== 'object') {
        errors.collect(ros.propertyValidator('eipBandwidth', ros.validateRange)({
            data: properties.eipBandwidth,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('eipBandwidth', ros.validateNumber)(properties.eipBandwidth));
    errors.collect(ros.propertyValidator('type', ros.validateString)(properties.type));
    errors.collect(ros.propertyValidator('isBondEip', ros.validateBoolean)(properties.isBondEip));
    errors.collect(ros.propertyValidator('minInstances', ros.validateNumber)(properties.minInstances));
    errors.collect(ros.propertyValidator('enable', ros.requiredValidator)(properties.enable));
    errors.collect(ros.propertyValidator('enable', ros.validateBoolean)(properties.enable));
    errors.collect(ros.propertyValidator('maxInstances', ros.validateNumber)(properties.maxInstances));
    if (properties.eipInternetChargeType && (typeof properties.eipInternetChargeType) !== 'object') {
        errors.collect(ros.propertyValidator('eipInternetChargeType', ros.validateAllowedValues)({
            data: properties.eipInternetChargeType,
            allowedValues: ["PayByBandwidth", "PayByTraffic"],
        }));
    }
    errors.collect(ros.propertyValidator('eipInternetChargeType', ros.validateString)(properties.eipInternetChargeType));
    return errors.wrap('supplied properties not correct for "AutoScalingProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.AutoScaling` resource
 *
 * @param properties - the TypeScript properties of a `AutoScalingProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.AutoScaling` resource.
 */
// @ts-ignore TS6133
function rosClusterNodePoolAutoScalingPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosClusterNodePool_AutoScalingPropertyValidator(properties).assertSuccess();
    return {
        EipBandwidth: ros.numberToRosTemplate(properties.eipBandwidth),
        Type: ros.stringToRosTemplate(properties.type),
        IsBondEip: ros.booleanToRosTemplate(properties.isBondEip),
        MinInstances: ros.numberToRosTemplate(properties.minInstances),
        Enable: ros.booleanToRosTemplate(properties.enable),
        MaxInstances: ros.numberToRosTemplate(properties.maxInstances),
        EipInternetChargeType: ros.stringToRosTemplate(properties.eipInternetChargeType),
    };
}
/**
 * Determine whether the given properties match those of a `DataDisksProperty`
 *
 * @param properties - the TypeScript properties of a `DataDisksProperty`
 *
 * @returns the result of the validation.
 */
function RosClusterNodePool_DataDisksPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('category', ros.validateString)(properties.category));
    errors.collect(ros.propertyValidator('encrypted', ros.validateBoolean)(properties.encrypted));
    errors.collect(ros.propertyValidator('performanceLevel', ros.validateString)(properties.performanceLevel));
    errors.collect(ros.propertyValidator('size', ros.validateNumber)(properties.size));
    errors.collect(ros.propertyValidator('autoSnapshotPolicyId', ros.validateString)(properties.autoSnapshotPolicyId));
    return errors.wrap('supplied properties not correct for "DataDisksProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.DataDisks` resource
 *
 * @param properties - the TypeScript properties of a `DataDisksProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.DataDisks` resource.
 */
// @ts-ignore TS6133
function rosClusterNodePoolDataDisksPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosClusterNodePool_DataDisksPropertyValidator(properties).assertSuccess();
    return {
        Category: ros.stringToRosTemplate(properties.category),
        Encrypted: ros.booleanToRosTemplate(properties.encrypted),
        PerformanceLevel: ros.stringToRosTemplate(properties.performanceLevel),
        Size: ros.numberToRosTemplate(properties.size),
        AutoSnapshotPolicyId: ros.stringToRosTemplate(properties.autoSnapshotPolicyId),
    };
}
/**
 * Determine whether the given properties match those of a `KubernetesConfigProperty`
 *
 * @param properties - the TypeScript properties of a `KubernetesConfigProperty`
 *
 * @returns the result of the validation.
 */
function RosClusterNodePool_KubernetesConfigPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('cpuPolicy', ros.validateString)(properties.cpuPolicy));
    errors.collect(ros.propertyValidator('runtime', ros.requiredValidator)(properties.runtime));
    errors.collect(ros.propertyValidator('runtime', ros.validateString)(properties.runtime));
    errors.collect(ros.propertyValidator('cmsEnabled', ros.validateBoolean)(properties.cmsEnabled));
    errors.collect(ros.propertyValidator('userData', ros.validateString)(properties.userData));
    errors.collect(ros.propertyValidator('nodeNameMode', ros.validateString)(properties.nodeNameMode));
    errors.collect(ros.propertyValidator('runtimeVersion', ros.requiredValidator)(properties.runtimeVersion));
    errors.collect(ros.propertyValidator('runtimeVersion', ros.validateString)(properties.runtimeVersion));
    if (properties.labels && (Array.isArray(properties.labels) || (typeof properties.labels) === 'string')) {
        errors.collect(ros.propertyValidator('labels', ros.validateLength)({
            data: properties.labels.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('labels', ros.listValidator(RosClusterNodePool_LabelsPropertyValidator))(properties.labels));
    errors.collect(ros.propertyValidator('unschedulable', ros.validateBoolean)(properties.unschedulable));
    if (properties.taints && (Array.isArray(properties.taints) || (typeof properties.taints) === 'string')) {
        errors.collect(ros.propertyValidator('taints', ros.validateLength)({
            data: properties.taints.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('taints', ros.listValidator(RosClusterNodePool_TaintsPropertyValidator))(properties.taints));
    return errors.wrap('supplied properties not correct for "KubernetesConfigProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.KubernetesConfig` resource
 *
 * @param properties - the TypeScript properties of a `KubernetesConfigProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.KubernetesConfig` resource.
 */
// @ts-ignore TS6133
function rosClusterNodePoolKubernetesConfigPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosClusterNodePool_KubernetesConfigPropertyValidator(properties).assertSuccess();
    return {
        CpuPolicy: ros.stringToRosTemplate(properties.cpuPolicy),
        Runtime: ros.stringToRosTemplate(properties.runtime),
        CmsEnabled: ros.booleanToRosTemplate(properties.cmsEnabled),
        UserData: ros.stringToRosTemplate(properties.userData),
        NodeNameMode: ros.stringToRosTemplate(properties.nodeNameMode),
        RuntimeVersion: ros.stringToRosTemplate(properties.runtimeVersion),
        Labels: ros.listMapper(rosClusterNodePoolLabelsPropertyToRosTemplate)(properties.labels),
        Unschedulable: ros.booleanToRosTemplate(properties.unschedulable),
        Taints: ros.listMapper(rosClusterNodePoolTaintsPropertyToRosTemplate)(properties.taints),
    };
}
/**
 * Determine whether the given properties match those of a `LabelsProperty`
 *
 * @param properties - the TypeScript properties of a `LabelsProperty`
 *
 * @returns the result of the validation.
 */
function RosClusterNodePool_LabelsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.requiredValidator)(properties.value));
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "LabelsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.Labels` resource
 *
 * @param properties - the TypeScript properties of a `LabelsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.Labels` resource.
 */
// @ts-ignore TS6133
function rosClusterNodePoolLabelsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosClusterNodePool_LabelsPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `ManagementProperty`
 *
 * @param properties - the TypeScript properties of a `ManagementProperty`
 *
 * @returns the result of the validation.
 */
function RosClusterNodePool_ManagementPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('upgradeConfig', RosClusterNodePool_UpgradeConfigPropertyValidator)(properties.upgradeConfig));
    errors.collect(ros.propertyValidator('autoRepair', ros.validateBoolean)(properties.autoRepair));
    errors.collect(ros.propertyValidator('enable', ros.requiredValidator)(properties.enable));
    errors.collect(ros.propertyValidator('enable', ros.validateBoolean)(properties.enable));
    return errors.wrap('supplied properties not correct for "ManagementProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.Management` resource
 *
 * @param properties - the TypeScript properties of a `ManagementProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.Management` resource.
 */
// @ts-ignore TS6133
function rosClusterNodePoolManagementPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosClusterNodePool_ManagementPropertyValidator(properties).assertSuccess();
    return {
        UpgradeConfig: rosClusterNodePoolUpgradeConfigPropertyToRosTemplate(properties.upgradeConfig),
        AutoRepair: ros.booleanToRosTemplate(properties.autoRepair),
        Enable: ros.booleanToRosTemplate(properties.enable),
    };
}
/**
 * Determine whether the given properties match those of a `NodePoolInfoProperty`
 *
 * @param properties - the TypeScript properties of a `NodePoolInfoProperty`
 *
 * @returns the result of the validation.
 */
function RosClusterNodePool_NodePoolInfoPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "NodePoolInfoProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.NodePoolInfo` resource
 *
 * @param properties - the TypeScript properties of a `NodePoolInfoProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.NodePoolInfo` resource.
 */
// @ts-ignore TS6133
function rosClusterNodePoolNodePoolInfoPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosClusterNodePool_NodePoolInfoPropertyValidator(properties).assertSuccess();
    return {
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        Name: ros.stringToRosTemplate(properties.name),
    };
}
/**
 * Determine whether the given properties match those of a `ScalingGroupProperty`
 *
 * @param properties - the TypeScript properties of a `ScalingGroupProperty`
 *
 * @returns the result of the validation.
 */
function RosClusterNodePool_ScalingGroupPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('spotInstanceRemedy', ros.validateBoolean)(properties.spotInstanceRemedy));
    errors.collect(ros.propertyValidator('platform', ros.validateString)(properties.platform));
    if (properties.dataDisks && (Array.isArray(properties.dataDisks) || (typeof properties.dataDisks) === 'string')) {
        errors.collect(ros.propertyValidator('dataDisks', ros.validateLength)({
            data: properties.dataDisks.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('dataDisks', ros.listValidator(RosClusterNodePool_DataDisksPropertyValidator))(properties.dataDisks));
    errors.collect(ros.propertyValidator('systemDiskSize', ros.requiredValidator)(properties.systemDiskSize));
    errors.collect(ros.propertyValidator('systemDiskSize', ros.validateNumber)(properties.systemDiskSize));
    errors.collect(ros.propertyValidator('compensateWithOnDemand', ros.validateBoolean)(properties.compensateWithOnDemand));
    errors.collect(ros.propertyValidator('instanceChargeType', ros.validateString)(properties.instanceChargeType));
    if (properties.onDemandPercentageAboveBaseCapacity && (typeof properties.onDemandPercentageAboveBaseCapacity) !== 'object') {
        errors.collect(ros.propertyValidator('onDemandPercentageAboveBaseCapacity', ros.validateRange)({
            data: properties.onDemandPercentageAboveBaseCapacity,
            min: 0,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('onDemandPercentageAboveBaseCapacity', ros.validateNumber)(properties.onDemandPercentageAboveBaseCapacity));
    errors.collect(ros.propertyValidator('autoRenew', ros.validateBoolean)(properties.autoRenew));
    if (properties.onDemandBaseCapacity && (typeof properties.onDemandBaseCapacity) !== 'object') {
        errors.collect(ros.propertyValidator('onDemandBaseCapacity', ros.validateRange)({
            data: properties.onDemandBaseCapacity,
            min: 0,
            max: 1000,
        }));
    }
    errors.collect(ros.propertyValidator('onDemandBaseCapacity', ros.validateNumber)(properties.onDemandBaseCapacity));
    errors.collect(ros.propertyValidator('systemDiskPerformanceLevel', ros.validateString)(properties.systemDiskPerformanceLevel));
    errors.collect(ros.propertyValidator('imageId', ros.validateString)(properties.imageId));
    if (properties.spotPriceLimit && (Array.isArray(properties.spotPriceLimit) || (typeof properties.spotPriceLimit) === 'string')) {
        errors.collect(ros.propertyValidator('spotPriceLimit', ros.validateLength)({
            data: properties.spotPriceLimit.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('spotPriceLimit', ros.listValidator(RosClusterNodePool_SpotPriceLimitPropertyValidator))(properties.spotPriceLimit));
    errors.collect(ros.propertyValidator('instanceTypes', ros.requiredValidator)(properties.instanceTypes));
    if (properties.instanceTypes && (Array.isArray(properties.instanceTypes) || (typeof properties.instanceTypes) === 'string')) {
        errors.collect(ros.propertyValidator('instanceTypes', ros.validateLength)({
            data: properties.instanceTypes.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('instanceTypes', ros.listValidator(ros.validateString))(properties.instanceTypes));
    if (properties.tags && (Array.isArray(properties.tags) || (typeof properties.tags) === 'string')) {
        errors.collect(ros.propertyValidator('tags', ros.validateLength)({
            data: properties.tags.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosClusterNodePool_TagsPropertyValidator))(properties.tags));
    errors.collect(ros.propertyValidator('spotStrategy', ros.validateString)(properties.spotStrategy));
    errors.collect(ros.propertyValidator('loginPassword', ros.validateString)(properties.loginPassword));
    errors.collect(ros.propertyValidator('multiAzPolicy', ros.validateString)(properties.multiAzPolicy));
    errors.collect(ros.propertyValidator('autoRenewPeriod', ros.validateNumber)(properties.autoRenewPeriod));
    errors.collect(ros.propertyValidator('scalingPolicy', ros.validateString)(properties.scalingPolicy));
    errors.collect(ros.propertyValidator('keyPair', ros.validateString)(properties.keyPair));
    errors.collect(ros.propertyValidator('vSwitchIds', ros.requiredValidator)(properties.vSwitchIds));
    if (properties.vSwitchIds && (Array.isArray(properties.vSwitchIds) || (typeof properties.vSwitchIds) === 'string')) {
        errors.collect(ros.propertyValidator('vSwitchIds', ros.validateLength)({
            data: properties.vSwitchIds.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('vSwitchIds', ros.listValidator(ros.validateString))(properties.vSwitchIds));
    errors.collect(ros.propertyValidator('securityGroupId', ros.validateString)(properties.securityGroupId));
    if (properties.spotInstancePools && (typeof properties.spotInstancePools) !== 'object') {
        errors.collect(ros.propertyValidator('spotInstancePools', ros.validateRange)({
            data: properties.spotInstancePools,
            min: 1,
            max: 10,
        }));
    }
    errors.collect(ros.propertyValidator('spotInstancePools', ros.validateNumber)(properties.spotInstancePools));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateRange)({
            data: properties.period,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('internetChargeType', ros.validateString)(properties.internetChargeType));
    errors.collect(ros.propertyValidator('systemDiskCategory', ros.validateString)(properties.systemDiskCategory));
    errors.collect(ros.propertyValidator('internetMaxBandwidthOut', ros.validateNumber)(properties.internetMaxBandwidthOut));
    if (properties.rdsInstances && (Array.isArray(properties.rdsInstances) || (typeof properties.rdsInstances) === 'string')) {
        errors.collect(ros.propertyValidator('rdsInstances', ros.validateLength)({
            data: properties.rdsInstances.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('rdsInstances', ros.listValidator(ros.validateString))(properties.rdsInstances));
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    return errors.wrap('supplied properties not correct for "ScalingGroupProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.ScalingGroup` resource
 *
 * @param properties - the TypeScript properties of a `ScalingGroupProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.ScalingGroup` resource.
 */
// @ts-ignore TS6133
function rosClusterNodePoolScalingGroupPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosClusterNodePool_ScalingGroupPropertyValidator(properties).assertSuccess();
    return {
        SpotInstanceRemedy: ros.booleanToRosTemplate(properties.spotInstanceRemedy),
        Platform: ros.stringToRosTemplate(properties.platform),
        DataDisks: ros.listMapper(rosClusterNodePoolDataDisksPropertyToRosTemplate)(properties.dataDisks),
        SystemDiskSize: ros.numberToRosTemplate(properties.systemDiskSize),
        CompensateWithOnDemand: ros.booleanToRosTemplate(properties.compensateWithOnDemand),
        InstanceChargeType: ros.stringToRosTemplate(properties.instanceChargeType),
        OnDemandPercentageAboveBaseCapacity: ros.numberToRosTemplate(properties.onDemandPercentageAboveBaseCapacity),
        AutoRenew: ros.booleanToRosTemplate(properties.autoRenew),
        OnDemandBaseCapacity: ros.numberToRosTemplate(properties.onDemandBaseCapacity),
        SystemDiskPerformanceLevel: ros.stringToRosTemplate(properties.systemDiskPerformanceLevel),
        ImageId: ros.stringToRosTemplate(properties.imageId),
        SpotPriceLimit: ros.listMapper(rosClusterNodePoolSpotPriceLimitPropertyToRosTemplate)(properties.spotPriceLimit),
        InstanceTypes: ros.listMapper(ros.stringToRosTemplate)(properties.instanceTypes),
        Tags: ros.listMapper(rosClusterNodePoolTagsPropertyToRosTemplate)(properties.tags),
        SpotStrategy: ros.stringToRosTemplate(properties.spotStrategy),
        LoginPassword: ros.stringToRosTemplate(properties.loginPassword),
        MultiAzPolicy: ros.stringToRosTemplate(properties.multiAzPolicy),
        AutoRenewPeriod: ros.numberToRosTemplate(properties.autoRenewPeriod),
        ScalingPolicy: ros.stringToRosTemplate(properties.scalingPolicy),
        KeyPair: ros.stringToRosTemplate(properties.keyPair),
        VSwitchIds: ros.listMapper(ros.stringToRosTemplate)(properties.vSwitchIds),
        SecurityGroupId: ros.stringToRosTemplate(properties.securityGroupId),
        SpotInstancePools: ros.numberToRosTemplate(properties.spotInstancePools),
        Period: ros.numberToRosTemplate(properties.period),
        InternetChargeType: ros.stringToRosTemplate(properties.internetChargeType),
        SystemDiskCategory: ros.stringToRosTemplate(properties.systemDiskCategory),
        InternetMaxBandwidthOut: ros.numberToRosTemplate(properties.internetMaxBandwidthOut),
        RdsInstances: ros.listMapper(ros.stringToRosTemplate)(properties.rdsInstances),
        PeriodUnit: ros.stringToRosTemplate(properties.periodUnit),
    };
}
/**
 * Determine whether the given properties match those of a `SpotPriceLimitProperty`
 *
 * @param properties - the TypeScript properties of a `SpotPriceLimitProperty`
 *
 * @returns the result of the validation.
 */
function RosClusterNodePool_SpotPriceLimitPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('priceLimit', ros.requiredValidator)(properties.priceLimit));
    errors.collect(ros.propertyValidator('priceLimit', ros.validateNumber)(properties.priceLimit));
    errors.collect(ros.propertyValidator('instanceType', ros.requiredValidator)(properties.instanceType));
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    return errors.wrap('supplied properties not correct for "SpotPriceLimitProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.SpotPriceLimit` resource
 *
 * @param properties - the TypeScript properties of a `SpotPriceLimitProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.SpotPriceLimit` resource.
 */
// @ts-ignore TS6133
function rosClusterNodePoolSpotPriceLimitPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosClusterNodePool_SpotPriceLimitPropertyValidator(properties).assertSuccess();
    return {
        PriceLimit: ros.numberToRosTemplate(properties.priceLimit),
        InstanceType: ros.stringToRosTemplate(properties.instanceType),
    };
}
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function RosClusterNodePool_TagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.requiredValidator)(properties.value));
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.Tags` resource.
 */
// @ts-ignore TS6133
function rosClusterNodePoolTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosClusterNodePool_TagsPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `TaintsProperty`
 *
 * @param properties - the TypeScript properties of a `TaintsProperty`
 *
 * @returns the result of the validation.
 */
function RosClusterNodePool_TaintsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.requiredValidator)(properties.value));
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('effect', ros.requiredValidator)(properties.effect));
    errors.collect(ros.propertyValidator('effect', ros.validateString)(properties.effect));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TaintsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.Taints` resource
 *
 * @param properties - the TypeScript properties of a `TaintsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.Taints` resource.
 */
// @ts-ignore TS6133
function rosClusterNodePoolTaintsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosClusterNodePool_TaintsPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Effect: ros.stringToRosTemplate(properties.effect),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `TeeConfigProperty`
 *
 * @param properties - the TypeScript properties of a `TeeConfigProperty`
 *
 * @returns the result of the validation.
 */
function RosClusterNodePool_TeeConfigPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('teeEnable', ros.requiredValidator)(properties.teeEnable));
    errors.collect(ros.propertyValidator('teeEnable', ros.validateBoolean)(properties.teeEnable));
    return errors.wrap('supplied properties not correct for "TeeConfigProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.TeeConfig` resource
 *
 * @param properties - the TypeScript properties of a `TeeConfigProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.TeeConfig` resource.
 */
// @ts-ignore TS6133
function rosClusterNodePoolTeeConfigPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosClusterNodePool_TeeConfigPropertyValidator(properties).assertSuccess();
    return {
        TeeEnable: ros.booleanToRosTemplate(properties.teeEnable),
    };
}
/**
 * Determine whether the given properties match those of a `UpgradeConfigProperty`
 *
 * @param properties - the TypeScript properties of a `UpgradeConfigProperty`
 *
 * @returns the result of the validation.
 */
function RosClusterNodePool_UpgradeConfigPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('autoUpgrade', ros.validateBoolean)(properties.autoUpgrade));
    errors.collect(ros.propertyValidator('surgePercentage', ros.validateNumber)(properties.surgePercentage));
    errors.collect(ros.propertyValidator('surge', ros.validateNumber)(properties.surge));
    if (properties.maxUnavailable && (typeof properties.maxUnavailable) !== 'object') {
        errors.collect(ros.propertyValidator('maxUnavailable', ros.validateRange)({
            data: properties.maxUnavailable,
            min: 1,
            max: 1000,
        }));
    }
    errors.collect(ros.propertyValidator('maxUnavailable', ros.validateNumber)(properties.maxUnavailable));
    return errors.wrap('supplied properties not correct for "UpgradeConfigProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.UpgradeConfig` resource
 *
 * @param properties - the TypeScript properties of a `UpgradeConfigProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ClusterNodePool.UpgradeConfig` resource.
 */
// @ts-ignore TS6133
function rosClusterNodePoolUpgradeConfigPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosClusterNodePool_UpgradeConfigPropertyValidator(properties).assertSuccess();
    return {
        AutoUpgrade: ros.booleanToRosTemplate(properties.autoUpgrade),
        SurgePercentage: ros.numberToRosTemplate(properties.surgePercentage),
        Surge: ros.numberToRosTemplate(properties.surge),
        MaxUnavailable: ros.numberToRosTemplate(properties.maxUnavailable),
    };
}
/**
 * Determine whether the given properties match those of a `RosKubernetesClusterProps`
 *
 * @param properties - the TypeScript properties of a `RosKubernetesClusterProps`
 *
 * @returns the result of the validation.
 */
function RosKubernetesClusterPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('endpointPublicAccess', ros.validateBoolean)(properties.endpointPublicAccess));
    errors.collect(ros.propertyValidator('socEnabled', ros.validateBoolean)(properties.socEnabled));
    errors.collect(ros.propertyValidator('platform', ros.validateString)(properties.platform));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('masterSystemDiskCategory', ros.validateString)(properties.masterSystemDiskCategory));
    if (properties.masterCount && (typeof properties.masterCount) !== 'object') {
        errors.collect(ros.propertyValidator('masterCount', ros.validateAllowedValues)({
            data: properties.masterCount,
            allowedValues: [3, 5],
        }));
    }
    errors.collect(ros.propertyValidator('masterCount', ros.validateNumber)(properties.masterCount));
    errors.collect(ros.propertyValidator('sshFlags', ros.validateBoolean)(properties.sshFlags));
    errors.collect(ros.propertyValidator('loadBalancerSpec', ros.validateString)(properties.loadBalancerSpec));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    errors.collect(ros.propertyValidator('taint', ros.listValidator(ros.validateAnyDict))(properties.taint));
    errors.collect(ros.propertyValidator('masterDataDisks', ros.listValidator(RosKubernetesCluster_MasterDataDisksPropertyValidator))(properties.masterDataDisks));
    errors.collect(ros.propertyValidator('isEnterpriseSecurityGroup', ros.validateBoolean)(properties.isEnterpriseSecurityGroup));
    errors.collect(ros.propertyValidator('runtime', RosKubernetesCluster_RuntimePropertyValidator)(properties.runtime));
    errors.collect(ros.propertyValidator('masterZoneIds', ros.listValidator(ros.validateString))(properties.masterZoneIds));
    if (properties.osType && (typeof properties.osType) !== 'object') {
        errors.collect(ros.propertyValidator('osType', ros.validateAllowedValues)({
            data: properties.osType,
            allowedValues: ["Windows", "Linux"],
        }));
    }
    errors.collect(ros.propertyValidator('osType', ros.validateString)(properties.osType));
    errors.collect(ros.propertyValidator('workerZoneIds', ros.listValidator(ros.validateString))(properties.workerZoneIds));
    errors.collect(ros.propertyValidator('proxyMode', ros.validateString)(properties.proxyMode));
    errors.collect(ros.propertyValidator('disableRollback', ros.validateBoolean)(properties.disableRollback));
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosKubernetesCluster_TagsPropertyValidator))(properties.tags));
    errors.collect(ros.propertyValidator('containerCidr', ros.validateString)(properties.containerCidr));
    errors.collect(ros.propertyValidator('cpuPolicy', ros.validateString)(properties.cpuPolicy));
    errors.collect(ros.propertyValidator('keyPair', ros.validateString)(properties.keyPair));
    errors.collect(ros.propertyValidator('nodeCidrMask', ros.validateString)(properties.nodeCidrMask));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 48, 60],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('deletionProtection', ros.validateBoolean)(properties.deletionProtection));
    errors.collect(ros.propertyValidator('timeZone', ros.validateString)(properties.timeZone));
    errors.collect(ros.propertyValidator('vpcId', ros.requiredValidator)(properties.vpcId));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    if (properties.nodePools && (Array.isArray(properties.nodePools) || (typeof properties.nodePools) === 'string')) {
        errors.collect(ros.propertyValidator('nodePools', ros.validateLength)({
            data: properties.nodePools.length,
            min: undefined,
            max: 1,
        }));
    }
    errors.collect(ros.propertyValidator('nodePools', ros.listValidator(RosKubernetesCluster_NodePoolsPropertyValidator))(properties.nodePools));
    errors.collect(ros.propertyValidator('userCa', ros.validateString)(properties.userCa));
    errors.collect(ros.propertyValidator('snatEntry', ros.validateBoolean)(properties.snatEntry));
    errors.collect(ros.propertyValidator('masterDataDisk', ros.validateBoolean)(properties.masterDataDisk));
    errors.collect(ros.propertyValidator('masterSystemDiskSnapshotPolicyId', ros.validateString)(properties.masterSystemDiskSnapshotPolicyId));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["Week", "Month"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    errors.collect(ros.propertyValidator('formatDisk', ros.validateBoolean)(properties.formatDisk));
    errors.collect(ros.propertyValidator('userData', ros.validateString)(properties.userData));
    errors.collect(ros.propertyValidator('autoRenew', ros.validateBoolean)(properties.autoRenew));
    errors.collect(ros.propertyValidator('addons', ros.listValidator(RosKubernetesCluster_AddonsPropertyValidator))(properties.addons));
    if (properties.masterSystemDiskSize && (typeof properties.masterSystemDiskSize) !== 'object') {
        errors.collect(ros.propertyValidator('masterSystemDiskSize', ros.validateRange)({
            data: properties.masterSystemDiskSize,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('masterSystemDiskSize', ros.validateNumber)(properties.masterSystemDiskSize));
    errors.collect(ros.propertyValidator('workerSystemDiskCategory', ros.validateString)(properties.workerSystemDiskCategory));
    errors.collect(ros.propertyValidator('nodePortRange', ros.validateString)(properties.nodePortRange));
    if (properties.workerSystemDiskSize && (typeof properties.workerSystemDiskSize) !== 'object') {
        errors.collect(ros.propertyValidator('workerSystemDiskSize', ros.validateRange)({
            data: properties.workerSystemDiskSize,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('workerSystemDiskSize', ros.validateNumber)(properties.workerSystemDiskSize));
    errors.collect(ros.propertyValidator('masterVSwitchIds', ros.requiredValidator)(properties.masterVSwitchIds));
    if (properties.masterVSwitchIds && (Array.isArray(properties.masterVSwitchIds) || (typeof properties.masterVSwitchIds) === 'string')) {
        errors.collect(ros.propertyValidator('masterVSwitchIds', ros.validateLength)({
            data: properties.masterVSwitchIds.length,
            min: 1,
            max: 3,
        }));
    }
    errors.collect(ros.propertyValidator('masterVSwitchIds', ros.listValidator(ros.validateAny))(properties.masterVSwitchIds));
    errors.collect(ros.propertyValidator('cloudMonitorFlags', ros.validateBoolean)(properties.cloudMonitorFlags));
    errors.collect(ros.propertyValidator('serviceCidr', ros.validateString)(properties.serviceCidr));
    errors.collect(ros.propertyValidator('podVswitchIds', ros.listValidator(ros.validateString))(properties.podVswitchIds));
    errors.collect(ros.propertyValidator('workerInstanceTypes', ros.requiredValidator)(properties.workerInstanceTypes));
    if (properties.workerInstanceTypes && (Array.isArray(properties.workerInstanceTypes) || (typeof properties.workerInstanceTypes) === 'string')) {
        errors.collect(ros.propertyValidator('workerInstanceTypes', ros.validateLength)({
            data: properties.workerInstanceTypes.length,
            min: 1,
            max: 10,
        }));
    }
    errors.collect(ros.propertyValidator('workerInstanceTypes', ros.listValidator(ros.validateString))(properties.workerInstanceTypes));
    errors.collect(ros.propertyValidator('loginPassword', ros.validateString)(properties.loginPassword));
    if (properties.autoRenewPeriod && (typeof properties.autoRenewPeriod) !== 'object') {
        errors.collect(ros.propertyValidator('autoRenewPeriod', ros.validateAllowedValues)({
            data: properties.autoRenewPeriod,
            allowedValues: [1, 2, 3, 6, 12],
        }));
    }
    errors.collect(ros.propertyValidator('autoRenewPeriod', ros.validateNumber)(properties.autoRenewPeriod));
    errors.collect(ros.propertyValidator('kubernetesVersion', ros.validateString)(properties.kubernetesVersion));
    errors.collect(ros.propertyValidator('masterInstanceTypes', ros.requiredValidator)(properties.masterInstanceTypes));
    if (properties.masterInstanceTypes && (Array.isArray(properties.masterInstanceTypes) || (typeof properties.masterInstanceTypes) === 'string')) {
        errors.collect(ros.propertyValidator('masterInstanceTypes', ros.validateLength)({
            data: properties.masterInstanceTypes.length,
            min: 3,
            max: 3,
        }));
    }
    errors.collect(ros.propertyValidator('masterInstanceTypes', ros.listValidator(ros.validateAny))(properties.masterInstanceTypes));
    errors.collect(ros.propertyValidator('masterSystemDiskPerformanceLevel', ros.validateString)(properties.masterSystemDiskPerformanceLevel));
    errors.collect(ros.propertyValidator('workerDataDisks', ros.listValidator(RosKubernetesCluster_WorkerDataDisksPropertyValidator))(properties.workerDataDisks));
    errors.collect(ros.propertyValidator('securityGroupId', ros.validateString)(properties.securityGroupId));
    errors.collect(ros.propertyValidator('timeoutMins', ros.validateNumber)(properties.timeoutMins));
    errors.collect(ros.propertyValidator('cisEnabled', ros.validateBoolean)(properties.cisEnabled));
    errors.collect(ros.propertyValidator('workerDataDisk', ros.validateBoolean)(properties.workerDataDisk));
    if (properties.numOfNodes && (typeof properties.numOfNodes) !== 'object') {
        errors.collect(ros.propertyValidator('numOfNodes', ros.validateRange)({
            data: properties.numOfNodes,
            min: 0,
            max: 300,
        }));
    }
    errors.collect(ros.propertyValidator('numOfNodes', ros.validateNumber)(properties.numOfNodes));
    errors.collect(ros.propertyValidator('keepInstanceName', ros.validateBoolean)(properties.keepInstanceName));
    if (properties.chargeType && (typeof properties.chargeType) !== 'object') {
        errors.collect(ros.propertyValidator('chargeType', ros.validateAllowedValues)({
            data: properties.chargeType,
            allowedValues: ["Subscription", "PrePaid", "PrePay", "Prepaid", "PayAsYouGo", "PostPaid", "PayOnDemand", "Postpaid"],
        }));
    }
    errors.collect(ros.propertyValidator('chargeType', ros.validateString)(properties.chargeType));
    errors.collect(ros.propertyValidator('workerSystemDiskSnapshotPolicyId', ros.validateString)(properties.workerSystemDiskSnapshotPolicyId));
    errors.collect(ros.propertyValidator('workerVSwitchIds', ros.requiredValidator)(properties.workerVSwitchIds));
    if (properties.workerVSwitchIds && (Array.isArray(properties.workerVSwitchIds) || (typeof properties.workerVSwitchIds) === 'string')) {
        errors.collect(ros.propertyValidator('workerVSwitchIds', ros.validateLength)({
            data: properties.workerVSwitchIds.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('workerVSwitchIds', ros.listValidator(ros.validateAny))(properties.workerVSwitchIds));
    return errors.wrap('supplied properties not correct for "RosKubernetesClusterProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster` resource
 *
 * @param properties - the TypeScript properties of a `RosKubernetesClusterProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosKubernetesClusterPropsValidator(properties).assertSuccess();
    }
    return {
        MasterInstanceTypes: ros.listMapper(ros.objectToRosTemplate)(properties.masterInstanceTypes),
        MasterVSwitchIds: ros.listMapper(ros.objectToRosTemplate)(properties.masterVSwitchIds),
        Name: ros.stringToRosTemplate(properties.name),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        WorkerInstanceTypes: ros.listMapper(ros.stringToRosTemplate)(properties.workerInstanceTypes),
        WorkerVSwitchIds: ros.listMapper(ros.objectToRosTemplate)(properties.workerVSwitchIds),
        Addons: ros.listMapper(rosKubernetesClusterAddonsPropertyToRosTemplate)(properties.addons),
        AutoRenew: ros.booleanToRosTemplate(properties.autoRenew),
        AutoRenewPeriod: ros.numberToRosTemplate(properties.autoRenewPeriod),
        ChargeType: ros.stringToRosTemplate(properties.chargeType),
        CisEnabled: ros.booleanToRosTemplate(properties.cisEnabled),
        CloudMonitorFlags: ros.booleanToRosTemplate(properties.cloudMonitorFlags),
        ContainerCidr: ros.stringToRosTemplate(properties.containerCidr),
        CpuPolicy: ros.stringToRosTemplate(properties.cpuPolicy),
        DeletionProtection: ros.booleanToRosTemplate(properties.deletionProtection),
        DisableRollback: ros.booleanToRosTemplate(properties.disableRollback),
        EndpointPublicAccess: ros.booleanToRosTemplate(properties.endpointPublicAccess),
        FormatDisk: ros.booleanToRosTemplate(properties.formatDisk),
        IsEnterpriseSecurityGroup: ros.booleanToRosTemplate(properties.isEnterpriseSecurityGroup),
        KeepInstanceName: ros.booleanToRosTemplate(properties.keepInstanceName),
        KeyPair: ros.stringToRosTemplate(properties.keyPair),
        KubernetesVersion: ros.stringToRosTemplate(properties.kubernetesVersion),
        LoadBalancerSpec: ros.stringToRosTemplate(properties.loadBalancerSpec),
        LoginPassword: ros.stringToRosTemplate(properties.loginPassword),
        MasterCount: ros.numberToRosTemplate(properties.masterCount),
        MasterDataDisk: ros.booleanToRosTemplate(properties.masterDataDisk),
        MasterDataDisks: ros.listMapper(rosKubernetesClusterMasterDataDisksPropertyToRosTemplate)(properties.masterDataDisks),
        MasterSystemDiskCategory: ros.stringToRosTemplate(properties.masterSystemDiskCategory),
        MasterSystemDiskPerformanceLevel: ros.stringToRosTemplate(properties.masterSystemDiskPerformanceLevel),
        MasterSystemDiskSize: ros.numberToRosTemplate(properties.masterSystemDiskSize),
        MasterSystemDiskSnapshotPolicyId: ros.stringToRosTemplate(properties.masterSystemDiskSnapshotPolicyId),
        MasterZoneIds: ros.listMapper(ros.stringToRosTemplate)(properties.masterZoneIds),
        NodeCidrMask: ros.stringToRosTemplate(properties.nodeCidrMask),
        NodePools: ros.listMapper(rosKubernetesClusterNodePoolsPropertyToRosTemplate)(properties.nodePools),
        NodePortRange: ros.stringToRosTemplate(properties.nodePortRange),
        NumOfNodes: ros.numberToRosTemplate(properties.numOfNodes),
        OsType: ros.stringToRosTemplate(properties.osType),
        Period: ros.numberToRosTemplate(properties.period),
        PeriodUnit: ros.stringToRosTemplate(properties.periodUnit),
        Platform: ros.stringToRosTemplate(properties.platform),
        PodVswitchIds: ros.listMapper(ros.stringToRosTemplate)(properties.podVswitchIds),
        ProxyMode: ros.stringToRosTemplate(properties.proxyMode),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        Runtime: rosKubernetesClusterRuntimePropertyToRosTemplate(properties.runtime),
        SecurityGroupId: ros.stringToRosTemplate(properties.securityGroupId),
        ServiceCidr: ros.stringToRosTemplate(properties.serviceCidr),
        SnatEntry: ros.booleanToRosTemplate(properties.snatEntry),
        SocEnabled: ros.booleanToRosTemplate(properties.socEnabled),
        SshFlags: ros.booleanToRosTemplate(properties.sshFlags),
        Tags: ros.listMapper(rosKubernetesClusterTagsPropertyToRosTemplate)(properties.tags),
        Taint: ros.listMapper(ros.anyDictToRosTemplate)(properties.taint),
        TimeoutMins: ros.numberToRosTemplate(properties.timeoutMins),
        TimeZone: ros.stringToRosTemplate(properties.timeZone),
        UserCa: ros.stringToRosTemplate(properties.userCa),
        UserData: ros.stringToRosTemplate(properties.userData),
        WorkerDataDisk: ros.booleanToRosTemplate(properties.workerDataDisk),
        WorkerDataDisks: ros.listMapper(rosKubernetesClusterWorkerDataDisksPropertyToRosTemplate)(properties.workerDataDisks),
        WorkerSystemDiskCategory: ros.stringToRosTemplate(properties.workerSystemDiskCategory),
        WorkerSystemDiskSize: ros.numberToRosTemplate(properties.workerSystemDiskSize),
        WorkerSystemDiskSnapshotPolicyId: ros.stringToRosTemplate(properties.workerSystemDiskSnapshotPolicyId),
        WorkerZoneIds: ros.listMapper(ros.stringToRosTemplate)(properties.workerZoneIds),
    };
}
/**
 * A ROS template type:  `ALIYUN::CS::KubernetesCluster`
 */
class RosKubernetesCluster extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CS::KubernetesCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosKubernetesCluster.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrApiServerSlbId = this.getAtt('APIServerSLBId');
        this.attrClusterId = this.getAtt('ClusterId');
        this.attrDefaultUserKubeConfig = this.getAtt('DefaultUserKubeConfig');
        this.attrNodes = this.getAtt('Nodes');
        this.attrPrivateUserKubConfig = this.getAtt('PrivateUserKubConfig');
        this.attrScalingConfigurationId = this.getAtt('ScalingConfigurationId');
        this.attrScalingGroupId = this.getAtt('ScalingGroupId');
        this.attrScalingRuleId = this.getAtt('ScalingRuleId');
        this.attrTaskId = this.getAtt('TaskId');
        this.attrWorkerRamRoleName = this.getAtt('WorkerRamRoleName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.masterInstanceTypes = props.masterInstanceTypes;
        this.masterVSwitchIds = props.masterVSwitchIds;
        this.name = props.name;
        this.vpcId = props.vpcId;
        this.workerInstanceTypes = props.workerInstanceTypes;
        this.workerVSwitchIds = props.workerVSwitchIds;
        this.addons = props.addons;
        this.autoRenew = props.autoRenew;
        this.autoRenewPeriod = props.autoRenewPeriod;
        this.chargeType = props.chargeType;
        this.cisEnabled = props.cisEnabled;
        this.cloudMonitorFlags = props.cloudMonitorFlags;
        this.containerCidr = props.containerCidr;
        this.cpuPolicy = props.cpuPolicy;
        this.deletionProtection = props.deletionProtection;
        this.disableRollback = props.disableRollback;
        this.endpointPublicAccess = props.endpointPublicAccess;
        this.formatDisk = props.formatDisk;
        this.isEnterpriseSecurityGroup = props.isEnterpriseSecurityGroup;
        this.keepInstanceName = props.keepInstanceName;
        this.keyPair = props.keyPair;
        this.kubernetesVersion = props.kubernetesVersion;
        this.loadBalancerSpec = props.loadBalancerSpec;
        this.loginPassword = props.loginPassword;
        this.masterCount = props.masterCount;
        this.masterDataDisk = props.masterDataDisk;
        this.masterDataDisks = props.masterDataDisks;
        this.masterSystemDiskCategory = props.masterSystemDiskCategory;
        this.masterSystemDiskPerformanceLevel = props.masterSystemDiskPerformanceLevel;
        this.masterSystemDiskSize = props.masterSystemDiskSize;
        this.masterSystemDiskSnapshotPolicyId = props.masterSystemDiskSnapshotPolicyId;
        this.masterZoneIds = props.masterZoneIds;
        this.nodeCidrMask = props.nodeCidrMask;
        this.nodePools = props.nodePools;
        this.nodePortRange = props.nodePortRange;
        this.numOfNodes = props.numOfNodes;
        this.osType = props.osType;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.platform = props.platform;
        this.podVswitchIds = props.podVswitchIds;
        this.proxyMode = props.proxyMode;
        this.resourceGroupId = props.resourceGroupId;
        this.runtime = props.runtime;
        this.securityGroupId = props.securityGroupId;
        this.serviceCidr = props.serviceCidr;
        this.snatEntry = props.snatEntry;
        this.socEnabled = props.socEnabled;
        this.sshFlags = props.sshFlags;
        this.tags = props.tags;
        this.taint = props.taint;
        this.timeoutMins = props.timeoutMins;
        this.timeZone = props.timeZone;
        this.userCa = props.userCa;
        this.userData = props.userData;
        this.workerDataDisk = props.workerDataDisk;
        this.workerDataDisks = props.workerDataDisks;
        this.workerSystemDiskCategory = props.workerSystemDiskCategory;
        this.workerSystemDiskSize = props.workerSystemDiskSize;
        this.workerSystemDiskSnapshotPolicyId = props.workerSystemDiskSnapshotPolicyId;
        this.workerZoneIds = props.workerZoneIds;
    }
    get rosProperties() {
        return {
            masterInstanceTypes: this.masterInstanceTypes,
            masterVSwitchIds: this.masterVSwitchIds,
            name: this.name,
            vpcId: this.vpcId,
            workerInstanceTypes: this.workerInstanceTypes,
            workerVSwitchIds: this.workerVSwitchIds,
            addons: this.addons,
            autoRenew: this.autoRenew,
            autoRenewPeriod: this.autoRenewPeriod,
            chargeType: this.chargeType,
            cisEnabled: this.cisEnabled,
            cloudMonitorFlags: this.cloudMonitorFlags,
            containerCidr: this.containerCidr,
            cpuPolicy: this.cpuPolicy,
            deletionProtection: this.deletionProtection,
            disableRollback: this.disableRollback,
            endpointPublicAccess: this.endpointPublicAccess,
            formatDisk: this.formatDisk,
            isEnterpriseSecurityGroup: this.isEnterpriseSecurityGroup,
            keepInstanceName: this.keepInstanceName,
            keyPair: this.keyPair,
            kubernetesVersion: this.kubernetesVersion,
            loadBalancerSpec: this.loadBalancerSpec,
            loginPassword: this.loginPassword,
            masterCount: this.masterCount,
            masterDataDisk: this.masterDataDisk,
            masterDataDisks: this.masterDataDisks,
            masterSystemDiskCategory: this.masterSystemDiskCategory,
            masterSystemDiskPerformanceLevel: this.masterSystemDiskPerformanceLevel,
            masterSystemDiskSize: this.masterSystemDiskSize,
            masterSystemDiskSnapshotPolicyId: this.masterSystemDiskSnapshotPolicyId,
            masterZoneIds: this.masterZoneIds,
            nodeCidrMask: this.nodeCidrMask,
            nodePools: this.nodePools,
            nodePortRange: this.nodePortRange,
            numOfNodes: this.numOfNodes,
            osType: this.osType,
            period: this.period,
            periodUnit: this.periodUnit,
            platform: this.platform,
            podVswitchIds: this.podVswitchIds,
            proxyMode: this.proxyMode,
            resourceGroupId: this.resourceGroupId,
            runtime: this.runtime,
            securityGroupId: this.securityGroupId,
            serviceCidr: this.serviceCidr,
            snatEntry: this.snatEntry,
            socEnabled: this.socEnabled,
            sshFlags: this.sshFlags,
            tags: this.tags,
            taint: this.taint,
            timeoutMins: this.timeoutMins,
            timeZone: this.timeZone,
            userCa: this.userCa,
            userData: this.userData,
            workerDataDisk: this.workerDataDisk,
            workerDataDisks: this.workerDataDisks,
            workerSystemDiskCategory: this.workerSystemDiskCategory,
            workerSystemDiskSize: this.workerSystemDiskSize,
            workerSystemDiskSnapshotPolicyId: this.workerSystemDiskSnapshotPolicyId,
            workerZoneIds: this.workerZoneIds,
        };
    }
    renderProperties(props) {
        return rosKubernetesClusterPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosKubernetesCluster = RosKubernetesCluster;
/**
 * The resource type name for this resource class.
 */
RosKubernetesCluster.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CS::KubernetesCluster";
/**
 * Determine whether the given properties match those of a `AddonsProperty`
 *
 * @param properties - the TypeScript properties of a `AddonsProperty`
 *
 * @returns the result of the validation.
 */
function RosKubernetesCluster_AddonsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('config', ros.validateString)(properties.config));
    errors.collect(ros.propertyValidator('disabled', ros.validateBoolean)(properties.disabled));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "AddonsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.Addons` resource
 *
 * @param properties - the TypeScript properties of a `AddonsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.Addons` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterAddonsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosKubernetesCluster_AddonsPropertyValidator(properties).assertSuccess();
    return {
        Config: ros.stringToRosTemplate(properties.config),
        Disabled: ros.booleanToRosTemplate(properties.disabled),
        Name: ros.stringToRosTemplate(properties.name),
    };
}
/**
 * Determine whether the given properties match those of a `DataDisksProperty`
 *
 * @param properties - the TypeScript properties of a `DataDisksProperty`
 *
 * @returns the result of the validation.
 */
function RosKubernetesCluster_DataDisksPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('category', ros.validateString)(properties.category));
    errors.collect(ros.propertyValidator('encrypted', ros.validateBoolean)(properties.encrypted));
    errors.collect(ros.propertyValidator('performanceLevel', ros.validateString)(properties.performanceLevel));
    errors.collect(ros.propertyValidator('size', ros.validateNumber)(properties.size));
    errors.collect(ros.propertyValidator('autoSnapshotPolicyId', ros.validateString)(properties.autoSnapshotPolicyId));
    return errors.wrap('supplied properties not correct for "DataDisksProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.DataDisks` resource
 *
 * @param properties - the TypeScript properties of a `DataDisksProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.DataDisks` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterDataDisksPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosKubernetesCluster_DataDisksPropertyValidator(properties).assertSuccess();
    return {
        Category: ros.stringToRosTemplate(properties.category),
        Encrypted: ros.booleanToRosTemplate(properties.encrypted),
        PerformanceLevel: ros.stringToRosTemplate(properties.performanceLevel),
        Size: ros.numberToRosTemplate(properties.size),
        AutoSnapshotPolicyId: ros.stringToRosTemplate(properties.autoSnapshotPolicyId),
    };
}
/**
 * Determine whether the given properties match those of a `KubernetesConfigProperty`
 *
 * @param properties - the TypeScript properties of a `KubernetesConfigProperty`
 *
 * @returns the result of the validation.
 */
function RosKubernetesCluster_KubernetesConfigPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('runtime', ros.requiredValidator)(properties.runtime));
    errors.collect(ros.propertyValidator('runtime', ros.validateString)(properties.runtime));
    errors.collect(ros.propertyValidator('cpuPolicy', ros.validateString)(properties.cpuPolicy));
    errors.collect(ros.propertyValidator('runtimeVersion', ros.requiredValidator)(properties.runtimeVersion));
    errors.collect(ros.propertyValidator('runtimeVersion', ros.validateString)(properties.runtimeVersion));
    if (properties.labels && (Array.isArray(properties.labels) || (typeof properties.labels) === 'string')) {
        errors.collect(ros.propertyValidator('labels', ros.validateLength)({
            data: properties.labels.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('labels', ros.listValidator(RosKubernetesCluster_LabelsPropertyValidator))(properties.labels));
    return errors.wrap('supplied properties not correct for "KubernetesConfigProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.KubernetesConfig` resource
 *
 * @param properties - the TypeScript properties of a `KubernetesConfigProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.KubernetesConfig` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterKubernetesConfigPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosKubernetesCluster_KubernetesConfigPropertyValidator(properties).assertSuccess();
    return {
        Runtime: ros.stringToRosTemplate(properties.runtime),
        CpuPolicy: ros.stringToRosTemplate(properties.cpuPolicy),
        RuntimeVersion: ros.stringToRosTemplate(properties.runtimeVersion),
        Labels: ros.listMapper(rosKubernetesClusterLabelsPropertyToRosTemplate)(properties.labels),
    };
}
/**
 * Determine whether the given properties match those of a `LabelsProperty`
 *
 * @param properties - the TypeScript properties of a `LabelsProperty`
 *
 * @returns the result of the validation.
 */
function RosKubernetesCluster_LabelsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.requiredValidator)(properties.value));
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "LabelsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.Labels` resource
 *
 * @param properties - the TypeScript properties of a `LabelsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.Labels` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterLabelsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosKubernetesCluster_LabelsPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `MasterDataDisksProperty`
 *
 * @param properties - the TypeScript properties of a `MasterDataDisksProperty`
 *
 * @returns the result of the validation.
 */
function RosKubernetesCluster_MasterDataDisksPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('category', ros.requiredValidator)(properties.category));
    errors.collect(ros.propertyValidator('category', ros.validateString)(properties.category));
    errors.collect(ros.propertyValidator('size', ros.requiredValidator)(properties.size));
    if (properties.size && (typeof properties.size) !== 'object') {
        errors.collect(ros.propertyValidator('size', ros.validateRange)({
            data: properties.size,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('size', ros.validateNumber)(properties.size));
    return errors.wrap('supplied properties not correct for "MasterDataDisksProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.MasterDataDisks` resource
 *
 * @param properties - the TypeScript properties of a `MasterDataDisksProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.MasterDataDisks` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterMasterDataDisksPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosKubernetesCluster_MasterDataDisksPropertyValidator(properties).assertSuccess();
    return {
        Category: ros.stringToRosTemplate(properties.category),
        Size: ros.numberToRosTemplate(properties.size),
    };
}
/**
 * Determine whether the given properties match those of a `NodePoolInfoProperty`
 *
 * @param properties - the TypeScript properties of a `NodePoolInfoProperty`
 *
 * @returns the result of the validation.
 */
function RosKubernetesCluster_NodePoolInfoPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "NodePoolInfoProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.NodePoolInfo` resource
 *
 * @param properties - the TypeScript properties of a `NodePoolInfoProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.NodePoolInfo` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterNodePoolInfoPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosKubernetesCluster_NodePoolInfoPropertyValidator(properties).assertSuccess();
    return {
        Name: ros.stringToRosTemplate(properties.name),
    };
}
/**
 * Determine whether the given properties match those of a `NodePoolsProperty`
 *
 * @param properties - the TypeScript properties of a `NodePoolsProperty`
 *
 * @returns the result of the validation.
 */
function RosKubernetesCluster_NodePoolsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('nodePoolInfo', RosKubernetesCluster_NodePoolInfoPropertyValidator)(properties.nodePoolInfo));
    errors.collect(ros.propertyValidator('kubernetesConfig', RosKubernetesCluster_KubernetesConfigPropertyValidator)(properties.kubernetesConfig));
    errors.collect(ros.propertyValidator('count', ros.validateNumber)(properties.count));
    errors.collect(ros.propertyValidator('scalingGroup', ros.requiredValidator)(properties.scalingGroup));
    errors.collect(ros.propertyValidator('scalingGroup', RosKubernetesCluster_ScalingGroupPropertyValidator)(properties.scalingGroup));
    return errors.wrap('supplied properties not correct for "NodePoolsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.NodePools` resource
 *
 * @param properties - the TypeScript properties of a `NodePoolsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.NodePools` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterNodePoolsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosKubernetesCluster_NodePoolsPropertyValidator(properties).assertSuccess();
    return {
        NodePoolInfo: rosKubernetesClusterNodePoolInfoPropertyToRosTemplate(properties.nodePoolInfo),
        KubernetesConfig: rosKubernetesClusterKubernetesConfigPropertyToRosTemplate(properties.kubernetesConfig),
        Count: ros.numberToRosTemplate(properties.count),
        ScalingGroup: rosKubernetesClusterScalingGroupPropertyToRosTemplate(properties.scalingGroup),
    };
}
/**
 * Determine whether the given properties match those of a `RuntimeProperty`
 *
 * @param properties - the TypeScript properties of a `RuntimeProperty`
 *
 * @returns the result of the validation.
 */
function RosKubernetesCluster_RuntimePropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('version', ros.validateString)(properties.version));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "RuntimeProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.Runtime` resource
 *
 * @param properties - the TypeScript properties of a `RuntimeProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.Runtime` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterRuntimePropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosKubernetesCluster_RuntimePropertyValidator(properties).assertSuccess();
    return {
        Version: ros.stringToRosTemplate(properties.version),
        Name: ros.stringToRosTemplate(properties.name),
    };
}
/**
 * Determine whether the given properties match those of a `ScalingGroupProperty`
 *
 * @param properties - the TypeScript properties of a `ScalingGroupProperty`
 *
 * @returns the result of the validation.
 */
function RosKubernetesCluster_ScalingGroupPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('keyPair', ros.validateString)(properties.keyPair));
    errors.collect(ros.propertyValidator('platform', ros.validateString)(properties.platform));
    if (properties.dataDisks && (Array.isArray(properties.dataDisks) || (typeof properties.dataDisks) === 'string')) {
        errors.collect(ros.propertyValidator('dataDisks', ros.validateLength)({
            data: properties.dataDisks.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('dataDisks', ros.listValidator(RosKubernetesCluster_DataDisksPropertyValidator))(properties.dataDisks));
    errors.collect(ros.propertyValidator('vSwitchIds', ros.requiredValidator)(properties.vSwitchIds));
    if (properties.vSwitchIds && (Array.isArray(properties.vSwitchIds) || (typeof properties.vSwitchIds) === 'string')) {
        errors.collect(ros.propertyValidator('vSwitchIds', ros.validateLength)({
            data: properties.vSwitchIds.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('vSwitchIds', ros.listValidator(ros.validateString))(properties.vSwitchIds));
    errors.collect(ros.propertyValidator('systemDiskSize', ros.requiredValidator)(properties.systemDiskSize));
    errors.collect(ros.propertyValidator('systemDiskSize', ros.validateNumber)(properties.systemDiskSize));
    errors.collect(ros.propertyValidator('instanceChargeType', ros.validateString)(properties.instanceChargeType));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateRange)({
            data: properties.period,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('systemDiskCategory', ros.validateString)(properties.systemDiskCategory));
    errors.collect(ros.propertyValidator('internetChargeType', ros.validateString)(properties.internetChargeType));
    errors.collect(ros.propertyValidator('isEnterpriseSecurityGroup', ros.validateBoolean)(properties.isEnterpriseSecurityGroup));
    errors.collect(ros.propertyValidator('internetMaxBandwidthOut', ros.validateNumber)(properties.internetMaxBandwidthOut));
    errors.collect(ros.propertyValidator('systemDiskPerformanceLevel', ros.validateString)(properties.systemDiskPerformanceLevel));
    if (properties.rdsInstances && (Array.isArray(properties.rdsInstances) || (typeof properties.rdsInstances) === 'string')) {
        errors.collect(ros.propertyValidator('rdsInstances', ros.validateLength)({
            data: properties.rdsInstances.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('rdsInstances', ros.listValidator(ros.validateString))(properties.rdsInstances));
    errors.collect(ros.propertyValidator('imageId', ros.validateString)(properties.imageId));
    errors.collect(ros.propertyValidator('instanceTypes', ros.requiredValidator)(properties.instanceTypes));
    if (properties.instanceTypes && (Array.isArray(properties.instanceTypes) || (typeof properties.instanceTypes) === 'string')) {
        errors.collect(ros.propertyValidator('instanceTypes', ros.validateLength)({
            data: properties.instanceTypes.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('instanceTypes', ros.listValidator(ros.validateString))(properties.instanceTypes));
    if (properties.tags && (Array.isArray(properties.tags) || (typeof properties.tags) === 'string')) {
        errors.collect(ros.propertyValidator('tags', ros.validateLength)({
            data: properties.tags.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosKubernetesCluster_ScalingGroupTagsPropertyValidator))(properties.tags));
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    errors.collect(ros.propertyValidator('loginPassword', ros.validateString)(properties.loginPassword));
    return errors.wrap('supplied properties not correct for "ScalingGroupProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.ScalingGroup` resource
 *
 * @param properties - the TypeScript properties of a `ScalingGroupProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.ScalingGroup` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterScalingGroupPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosKubernetesCluster_ScalingGroupPropertyValidator(properties).assertSuccess();
    return {
        KeyPair: ros.stringToRosTemplate(properties.keyPair),
        Platform: ros.stringToRosTemplate(properties.platform),
        DataDisks: ros.listMapper(rosKubernetesClusterDataDisksPropertyToRosTemplate)(properties.dataDisks),
        VSwitchIds: ros.listMapper(ros.stringToRosTemplate)(properties.vSwitchIds),
        SystemDiskSize: ros.numberToRosTemplate(properties.systemDiskSize),
        InstanceChargeType: ros.stringToRosTemplate(properties.instanceChargeType),
        Period: ros.numberToRosTemplate(properties.period),
        SystemDiskCategory: ros.stringToRosTemplate(properties.systemDiskCategory),
        InternetChargeType: ros.stringToRosTemplate(properties.internetChargeType),
        IsEnterpriseSecurityGroup: ros.booleanToRosTemplate(properties.isEnterpriseSecurityGroup),
        InternetMaxBandwidthOut: ros.numberToRosTemplate(properties.internetMaxBandwidthOut),
        SystemDiskPerformanceLevel: ros.stringToRosTemplate(properties.systemDiskPerformanceLevel),
        RdsInstances: ros.listMapper(ros.stringToRosTemplate)(properties.rdsInstances),
        ImageId: ros.stringToRosTemplate(properties.imageId),
        InstanceTypes: ros.listMapper(ros.stringToRosTemplate)(properties.instanceTypes),
        Tags: ros.listMapper(rosKubernetesClusterScalingGroupTagsPropertyToRosTemplate)(properties.tags),
        PeriodUnit: ros.stringToRosTemplate(properties.periodUnit),
        LoginPassword: ros.stringToRosTemplate(properties.loginPassword),
    };
}
/**
 * Determine whether the given properties match those of a `ScalingGroupTagsProperty`
 *
 * @param properties - the TypeScript properties of a `ScalingGroupTagsProperty`
 *
 * @returns the result of the validation.
 */
function RosKubernetesCluster_ScalingGroupTagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.requiredValidator)(properties.value));
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "ScalingGroupTagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.ScalingGroupTags` resource
 *
 * @param properties - the TypeScript properties of a `ScalingGroupTagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.ScalingGroupTags` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterScalingGroupTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosKubernetesCluster_ScalingGroupTagsPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function RosKubernetesCluster_TagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.Tags` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosKubernetesCluster_TagsPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `WorkerDataDisksProperty`
 *
 * @param properties - the TypeScript properties of a `WorkerDataDisksProperty`
 *
 * @returns the result of the validation.
 */
function RosKubernetesCluster_WorkerDataDisksPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('category', ros.requiredValidator)(properties.category));
    errors.collect(ros.propertyValidator('category', ros.validateString)(properties.category));
    errors.collect(ros.propertyValidator('size', ros.requiredValidator)(properties.size));
    if (properties.size && (typeof properties.size) !== 'object') {
        errors.collect(ros.propertyValidator('size', ros.validateRange)({
            data: properties.size,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('size', ros.validateNumber)(properties.size));
    return errors.wrap('supplied properties not correct for "WorkerDataDisksProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.WorkerDataDisks` resource
 *
 * @param properties - the TypeScript properties of a `WorkerDataDisksProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.WorkerDataDisks` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterWorkerDataDisksPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosKubernetesCluster_WorkerDataDisksPropertyValidator(properties).assertSuccess();
    return {
        Category: ros.stringToRosTemplate(properties.category),
        Size: ros.numberToRosTemplate(properties.size),
    };
}
/**
 * Determine whether the given properties match those of a `RosManagedEdgeKubernetesClusterProps`
 *
 * @param properties - the TypeScript properties of a `RosManagedEdgeKubernetesClusterProps`
 *
 * @returns the result of the validation.
 */
function RosManagedEdgeKubernetesClusterPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('endpointPublicAccess', ros.validateBoolean)(properties.endpointPublicAccess));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('autoRenew', ros.validateBoolean)(properties.autoRenew));
    errors.collect(ros.propertyValidator('addons', ros.listValidator(RosManagedEdgeKubernetesCluster_AddonsPropertyValidator))(properties.addons));
    errors.collect(ros.propertyValidator('workerSystemDiskCategory', ros.validateString)(properties.workerSystemDiskCategory));
    if (properties.workerSystemDiskSize && (typeof properties.workerSystemDiskSize) !== 'object') {
        errors.collect(ros.propertyValidator('workerSystemDiskSize', ros.validateRange)({
            data: properties.workerSystemDiskSize,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('workerSystemDiskSize', ros.validateNumber)(properties.workerSystemDiskSize));
    errors.collect(ros.propertyValidator('profile', ros.validateString)(properties.profile));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    errors.collect(ros.propertyValidator('isEnterpriseSecurityGroup', ros.validateBoolean)(properties.isEnterpriseSecurityGroup));
    if (properties.workerDataDiskSize && (typeof properties.workerDataDiskSize) !== 'object') {
        errors.collect(ros.propertyValidator('workerDataDiskSize', ros.validateRange)({
            data: properties.workerDataDiskSize,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('workerDataDiskSize', ros.validateNumber)(properties.workerDataDiskSize));
    errors.collect(ros.propertyValidator('cloudMonitorFlags', ros.validateBoolean)(properties.cloudMonitorFlags));
    errors.collect(ros.propertyValidator('serviceCidr', ros.validateString)(properties.serviceCidr));
    errors.collect(ros.propertyValidator('zoneIds', ros.listValidator(ros.validateString))(properties.zoneIds));
    errors.collect(ros.propertyValidator('proxyMode', ros.validateString)(properties.proxyMode));
    errors.collect(ros.propertyValidator('disableRollback', ros.validateBoolean)(properties.disableRollback));
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosManagedEdgeKubernetesCluster_TagsPropertyValidator))(properties.tags));
    if (properties.workerInstanceTypes && (Array.isArray(properties.workerInstanceTypes) || (typeof properties.workerInstanceTypes) === 'string')) {
        errors.collect(ros.propertyValidator('workerInstanceTypes', ros.validateLength)({
            data: properties.workerInstanceTypes.length,
            min: 1,
            max: 10,
        }));
    }
    errors.collect(ros.propertyValidator('workerInstanceTypes', ros.listValidator(ros.validateString))(properties.workerInstanceTypes));
    errors.collect(ros.propertyValidator('loginPassword', ros.validateString)(properties.loginPassword));
    if (properties.autoRenewPeriod && (typeof properties.autoRenewPeriod) !== 'object') {
        errors.collect(ros.propertyValidator('autoRenewPeriod', ros.validateAllowedValues)({
            data: properties.autoRenewPeriod,
            allowedValues: [1, 2, 3, 6, 12],
        }));
    }
    errors.collect(ros.propertyValidator('autoRenewPeriod', ros.validateNumber)(properties.autoRenewPeriod));
    errors.collect(ros.propertyValidator('containerCidr', ros.validateString)(properties.containerCidr));
    errors.collect(ros.propertyValidator('keyPair', ros.validateString)(properties.keyPair));
    errors.collect(ros.propertyValidator('nodeCidrMask', ros.validateString)(properties.nodeCidrMask));
    if (properties.vSwitchIds && (Array.isArray(properties.vSwitchIds) || (typeof properties.vSwitchIds) === 'string')) {
        errors.collect(ros.propertyValidator('vSwitchIds', ros.validateLength)({
            data: properties.vSwitchIds.length,
            min: 1,
            max: 5,
        }));
    }
    errors.collect(ros.propertyValidator('vSwitchIds', ros.listValidator(ros.validateAny))(properties.vSwitchIds));
    errors.collect(ros.propertyValidator('timeoutMins', ros.validateNumber)(properties.timeoutMins));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 48, 60],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('clusterSpec', ros.validateString)(properties.clusterSpec));
    errors.collect(ros.propertyValidator('deletionProtection', ros.validateBoolean)(properties.deletionProtection));
    errors.collect(ros.propertyValidator('workerDataDisk', ros.validateBoolean)(properties.workerDataDisk));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    errors.collect(ros.propertyValidator('numOfNodes', ros.requiredValidator)(properties.numOfNodes));
    if (properties.numOfNodes && (typeof properties.numOfNodes) !== 'object') {
        errors.collect(ros.propertyValidator('numOfNodes', ros.validateRange)({
            data: properties.numOfNodes,
            min: 0,
            max: 300,
        }));
    }
    errors.collect(ros.propertyValidator('numOfNodes', ros.validateNumber)(properties.numOfNodes));
    if (properties.chargeType && (typeof properties.chargeType) !== 'object') {
        errors.collect(ros.propertyValidator('chargeType', ros.validateAllowedValues)({
            data: properties.chargeType,
            allowedValues: ["Subscription", "PrePaid", "PrePay", "Prepaid", "PayAsYouGo", "PostPaid", "PayOnDemand", "Postpaid"],
        }));
    }
    errors.collect(ros.propertyValidator('chargeType', ros.validateString)(properties.chargeType));
    errors.collect(ros.propertyValidator('workerDataDiskCategory', ros.validateString)(properties.workerDataDiskCategory));
    errors.collect(ros.propertyValidator('snatEntry', ros.validateBoolean)(properties.snatEntry));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["Week", "Month"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    return errors.wrap('supplied properties not correct for "RosManagedEdgeKubernetesClusterProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedEdgeKubernetesCluster` resource
 *
 * @param properties - the TypeScript properties of a `RosManagedEdgeKubernetesClusterProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedEdgeKubernetesCluster` resource.
 */
// @ts-ignore TS6133
function rosManagedEdgeKubernetesClusterPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosManagedEdgeKubernetesClusterPropsValidator(properties).assertSuccess();
    }
    return {
        Name: ros.stringToRosTemplate(properties.name),
        NumOfNodes: ros.numberToRosTemplate(properties.numOfNodes),
        Addons: ros.listMapper(rosManagedEdgeKubernetesClusterAddonsPropertyToRosTemplate)(properties.addons),
        AutoRenew: ros.booleanToRosTemplate(properties.autoRenew),
        AutoRenewPeriod: ros.numberToRosTemplate(properties.autoRenewPeriod),
        ChargeType: ros.stringToRosTemplate(properties.chargeType),
        CloudMonitorFlags: ros.booleanToRosTemplate(properties.cloudMonitorFlags),
        ClusterSpec: ros.stringToRosTemplate(properties.clusterSpec),
        ContainerCidr: ros.stringToRosTemplate(properties.containerCidr),
        DeletionProtection: ros.booleanToRosTemplate(properties.deletionProtection),
        DisableRollback: ros.booleanToRosTemplate(properties.disableRollback),
        EndpointPublicAccess: ros.booleanToRosTemplate(properties.endpointPublicAccess),
        IsEnterpriseSecurityGroup: ros.booleanToRosTemplate(properties.isEnterpriseSecurityGroup),
        KeyPair: ros.stringToRosTemplate(properties.keyPair),
        LoginPassword: ros.stringToRosTemplate(properties.loginPassword),
        NodeCidrMask: ros.stringToRosTemplate(properties.nodeCidrMask),
        Period: ros.numberToRosTemplate(properties.period),
        PeriodUnit: ros.stringToRosTemplate(properties.periodUnit),
        Profile: ros.stringToRosTemplate(properties.profile),
        ProxyMode: ros.stringToRosTemplate(properties.proxyMode),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        ServiceCidr: ros.stringToRosTemplate(properties.serviceCidr),
        SnatEntry: ros.booleanToRosTemplate(properties.snatEntry),
        Tags: ros.listMapper(rosManagedEdgeKubernetesClusterTagsPropertyToRosTemplate)(properties.tags),
        TimeoutMins: ros.numberToRosTemplate(properties.timeoutMins),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        VSwitchIds: ros.listMapper(ros.objectToRosTemplate)(properties.vSwitchIds),
        WorkerDataDisk: ros.booleanToRosTemplate(properties.workerDataDisk),
        WorkerDataDiskCategory: ros.stringToRosTemplate(properties.workerDataDiskCategory),
        WorkerDataDiskSize: ros.numberToRosTemplate(properties.workerDataDiskSize),
        WorkerInstanceTypes: ros.listMapper(ros.stringToRosTemplate)(properties.workerInstanceTypes),
        WorkerSystemDiskCategory: ros.stringToRosTemplate(properties.workerSystemDiskCategory),
        WorkerSystemDiskSize: ros.numberToRosTemplate(properties.workerSystemDiskSize),
        ZoneIds: ros.listMapper(ros.stringToRosTemplate)(properties.zoneIds),
    };
}
/**
 * A ROS template type:  `ALIYUN::CS::ManagedEdgeKubernetesCluster`
 */
class RosManagedEdgeKubernetesCluster extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CS::ManagedEdgeKubernetesCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosManagedEdgeKubernetesCluster.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrApiServerSlbId = this.getAtt('APIServerSLBId');
        this.attrClusterId = this.getAtt('ClusterId');
        this.attrDefaultUserKubeConfig = this.getAtt('DefaultUserKubeConfig');
        this.attrNodes = this.getAtt('Nodes');
        this.attrPrivateUserKubConfig = this.getAtt('PrivateUserKubConfig');
        this.attrScalingConfigurationId = this.getAtt('ScalingConfigurationId');
        this.attrScalingGroupId = this.getAtt('ScalingGroupId');
        this.attrScalingRuleId = this.getAtt('ScalingRuleId');
        this.attrTaskId = this.getAtt('TaskId');
        this.attrWorkerRamRoleName = this.getAtt('WorkerRamRoleName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.name = props.name;
        this.numOfNodes = props.numOfNodes;
        this.addons = props.addons;
        this.autoRenew = props.autoRenew;
        this.autoRenewPeriod = props.autoRenewPeriod;
        this.chargeType = props.chargeType;
        this.cloudMonitorFlags = props.cloudMonitorFlags;
        this.clusterSpec = props.clusterSpec;
        this.containerCidr = props.containerCidr;
        this.deletionProtection = props.deletionProtection;
        this.disableRollback = props.disableRollback;
        this.endpointPublicAccess = props.endpointPublicAccess;
        this.isEnterpriseSecurityGroup = props.isEnterpriseSecurityGroup;
        this.keyPair = props.keyPair;
        this.loginPassword = props.loginPassword;
        this.nodeCidrMask = props.nodeCidrMask;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.profile = props.profile;
        this.proxyMode = props.proxyMode;
        this.resourceGroupId = props.resourceGroupId;
        this.serviceCidr = props.serviceCidr;
        this.snatEntry = props.snatEntry;
        this.tags = props.tags;
        this.timeoutMins = props.timeoutMins;
        this.vpcId = props.vpcId;
        this.vSwitchIds = props.vSwitchIds;
        this.workerDataDisk = props.workerDataDisk;
        this.workerDataDiskCategory = props.workerDataDiskCategory;
        this.workerDataDiskSize = props.workerDataDiskSize;
        this.workerInstanceTypes = props.workerInstanceTypes;
        this.workerSystemDiskCategory = props.workerSystemDiskCategory;
        this.workerSystemDiskSize = props.workerSystemDiskSize;
        this.zoneIds = props.zoneIds;
    }
    get rosProperties() {
        return {
            name: this.name,
            numOfNodes: this.numOfNodes,
            addons: this.addons,
            autoRenew: this.autoRenew,
            autoRenewPeriod: this.autoRenewPeriod,
            chargeType: this.chargeType,
            cloudMonitorFlags: this.cloudMonitorFlags,
            clusterSpec: this.clusterSpec,
            containerCidr: this.containerCidr,
            deletionProtection: this.deletionProtection,
            disableRollback: this.disableRollback,
            endpointPublicAccess: this.endpointPublicAccess,
            isEnterpriseSecurityGroup: this.isEnterpriseSecurityGroup,
            keyPair: this.keyPair,
            loginPassword: this.loginPassword,
            nodeCidrMask: this.nodeCidrMask,
            period: this.period,
            periodUnit: this.periodUnit,
            profile: this.profile,
            proxyMode: this.proxyMode,
            resourceGroupId: this.resourceGroupId,
            serviceCidr: this.serviceCidr,
            snatEntry: this.snatEntry,
            tags: this.tags,
            timeoutMins: this.timeoutMins,
            vpcId: this.vpcId,
            vSwitchIds: this.vSwitchIds,
            workerDataDisk: this.workerDataDisk,
            workerDataDiskCategory: this.workerDataDiskCategory,
            workerDataDiskSize: this.workerDataDiskSize,
            workerInstanceTypes: this.workerInstanceTypes,
            workerSystemDiskCategory: this.workerSystemDiskCategory,
            workerSystemDiskSize: this.workerSystemDiskSize,
            zoneIds: this.zoneIds,
        };
    }
    renderProperties(props) {
        return rosManagedEdgeKubernetesClusterPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosManagedEdgeKubernetesCluster = RosManagedEdgeKubernetesCluster;
/**
 * The resource type name for this resource class.
 */
RosManagedEdgeKubernetesCluster.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CS::ManagedEdgeKubernetesCluster";
/**
 * Determine whether the given properties match those of a `AddonsProperty`
 *
 * @param properties - the TypeScript properties of a `AddonsProperty`
 *
 * @returns the result of the validation.
 */
function RosManagedEdgeKubernetesCluster_AddonsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('config', ros.validateString)(properties.config));
    errors.collect(ros.propertyValidator('disabled', ros.validateBoolean)(properties.disabled));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "AddonsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedEdgeKubernetesCluster.Addons` resource
 *
 * @param properties - the TypeScript properties of a `AddonsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedEdgeKubernetesCluster.Addons` resource.
 */
// @ts-ignore TS6133
function rosManagedEdgeKubernetesClusterAddonsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosManagedEdgeKubernetesCluster_AddonsPropertyValidator(properties).assertSuccess();
    return {
        Config: ros.stringToRosTemplate(properties.config),
        Disabled: ros.booleanToRosTemplate(properties.disabled),
        Name: ros.stringToRosTemplate(properties.name),
    };
}
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function RosManagedEdgeKubernetesCluster_TagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedEdgeKubernetesCluster.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedEdgeKubernetesCluster.Tags` resource.
 */
// @ts-ignore TS6133
function rosManagedEdgeKubernetesClusterTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosManagedEdgeKubernetesCluster_TagsPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `RosManagedKubernetesClusterProps`
 *
 * @param properties - the TypeScript properties of a `RosManagedKubernetesClusterProps`
 *
 * @returns the result of the validation.
 */
function RosManagedKubernetesClusterPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('endpointPublicAccess', ros.validateBoolean)(properties.endpointPublicAccess));
    errors.collect(ros.propertyValidator('socEnabled', ros.validateBoolean)(properties.socEnabled));
    errors.collect(ros.propertyValidator('formatDisk', ros.validateBoolean)(properties.formatDisk));
    errors.collect(ros.propertyValidator('platform', ros.validateString)(properties.platform));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('userData', ros.validateString)(properties.userData));
    errors.collect(ros.propertyValidator('autoRenew', ros.validateBoolean)(properties.autoRenew));
    errors.collect(ros.propertyValidator('addons', ros.listValidator(RosManagedKubernetesCluster_AddonsPropertyValidator))(properties.addons));
    errors.collect(ros.propertyValidator('workerSystemDiskCategory', ros.validateString)(properties.workerSystemDiskCategory));
    if (properties.workerSystemDiskSize && (typeof properties.workerSystemDiskSize) !== 'object') {
        errors.collect(ros.propertyValidator('workerSystemDiskSize', ros.validateRange)({
            data: properties.workerSystemDiskSize,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('workerSystemDiskSize', ros.validateNumber)(properties.workerSystemDiskSize));
    errors.collect(ros.propertyValidator('loadBalancerSpec', ros.validateString)(properties.loadBalancerSpec));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    errors.collect(ros.propertyValidator('taint', ros.listValidator(ros.validateAnyDict))(properties.taint));
    errors.collect(ros.propertyValidator('isEnterpriseSecurityGroup', ros.validateBoolean)(properties.isEnterpriseSecurityGroup));
    errors.collect(ros.propertyValidator('runtime', RosManagedKubernetesCluster_RuntimePropertyValidator)(properties.runtime));
    errors.collect(ros.propertyValidator('cloudMonitorFlags', ros.validateBoolean)(properties.cloudMonitorFlags));
    if (properties.osType && (typeof properties.osType) !== 'object') {
        errors.collect(ros.propertyValidator('osType', ros.validateAllowedValues)({
            data: properties.osType,
            allowedValues: ["Windows", "Linux"],
        }));
    }
    errors.collect(ros.propertyValidator('osType', ros.validateString)(properties.osType));
    errors.collect(ros.propertyValidator('serviceCidr', ros.validateString)(properties.serviceCidr));
    errors.collect(ros.propertyValidator('podVswitchIds', ros.listValidator(ros.validateString))(properties.podVswitchIds));
    errors.collect(ros.propertyValidator('zoneIds', ros.listValidator(ros.validateString))(properties.zoneIds));
    errors.collect(ros.propertyValidator('proxyMode', ros.validateString)(properties.proxyMode));
    errors.collect(ros.propertyValidator('disableRollback', ros.validateBoolean)(properties.disableRollback));
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosManagedKubernetesCluster_TagsPropertyValidator))(properties.tags));
    errors.collect(ros.propertyValidator('workerInstanceTypes', ros.requiredValidator)(properties.workerInstanceTypes));
    if (properties.workerInstanceTypes && (Array.isArray(properties.workerInstanceTypes) || (typeof properties.workerInstanceTypes) === 'string')) {
        errors.collect(ros.propertyValidator('workerInstanceTypes', ros.validateLength)({
            data: properties.workerInstanceTypes.length,
            min: 1,
            max: 5,
        }));
    }
    errors.collect(ros.propertyValidator('workerInstanceTypes', ros.listValidator(ros.validateString))(properties.workerInstanceTypes));
    errors.collect(ros.propertyValidator('loginPassword', ros.validateString)(properties.loginPassword));
    if (properties.autoRenewPeriod && (typeof properties.autoRenewPeriod) !== 'object') {
        errors.collect(ros.propertyValidator('autoRenewPeriod', ros.validateAllowedValues)({
            data: properties.autoRenewPeriod,
            allowedValues: [1, 2, 3, 6, 12],
        }));
    }
    errors.collect(ros.propertyValidator('autoRenewPeriod', ros.validateNumber)(properties.autoRenewPeriod));
    errors.collect(ros.propertyValidator('kubernetesVersion', ros.validateString)(properties.kubernetesVersion));
    errors.collect(ros.propertyValidator('containerCidr', ros.validateString)(properties.containerCidr));
    errors.collect(ros.propertyValidator('keyPair', ros.validateString)(properties.keyPair));
    errors.collect(ros.propertyValidator('nodeCidrMask', ros.validateString)(properties.nodeCidrMask));
    errors.collect(ros.propertyValidator('vSwitchIds', ros.requiredValidator)(properties.vSwitchIds));
    if (properties.vSwitchIds && (Array.isArray(properties.vSwitchIds) || (typeof properties.vSwitchIds) === 'string')) {
        errors.collect(ros.propertyValidator('vSwitchIds', ros.validateLength)({
            data: properties.vSwitchIds.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('vSwitchIds', ros.listValidator(ros.validateAny))(properties.vSwitchIds));
    errors.collect(ros.propertyValidator('workerDataDisks', ros.listValidator(RosManagedKubernetesCluster_WorkerDataDisksPropertyValidator))(properties.workerDataDisks));
    errors.collect(ros.propertyValidator('timeoutMins', ros.validateNumber)(properties.timeoutMins));
    errors.collect(ros.propertyValidator('securityGroupId', ros.validateString)(properties.securityGroupId));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 48, 60],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('clusterSpec', ros.validateString)(properties.clusterSpec));
    errors.collect(ros.propertyValidator('deletionProtection', ros.validateBoolean)(properties.deletionProtection));
    errors.collect(ros.propertyValidator('cisEnabled', ros.validateBoolean)(properties.cisEnabled));
    errors.collect(ros.propertyValidator('workerDataDisk', ros.validateBoolean)(properties.workerDataDisk));
    errors.collect(ros.propertyValidator('vpcId', ros.requiredValidator)(properties.vpcId));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    if (properties.numOfNodes && (typeof properties.numOfNodes) !== 'object') {
        errors.collect(ros.propertyValidator('numOfNodes', ros.validateRange)({
            data: properties.numOfNodes,
            min: 0,
            max: 300,
        }));
    }
    errors.collect(ros.propertyValidator('numOfNodes', ros.validateNumber)(properties.numOfNodes));
    errors.collect(ros.propertyValidator('keepInstanceName', ros.validateBoolean)(properties.keepInstanceName));
    if (properties.nodePools && (Array.isArray(properties.nodePools) || (typeof properties.nodePools) === 'string')) {
        errors.collect(ros.propertyValidator('nodePools', ros.validateLength)({
            data: properties.nodePools.length,
            min: undefined,
            max: 1,
        }));
    }
    errors.collect(ros.propertyValidator('nodePools', ros.listValidator(RosManagedKubernetesCluster_NodePoolsPropertyValidator))(properties.nodePools));
    if (properties.chargeType && (typeof properties.chargeType) !== 'object') {
        errors.collect(ros.propertyValidator('chargeType', ros.validateAllowedValues)({
            data: properties.chargeType,
            allowedValues: ["Subscription", "PrePaid", "PrePay", "Prepaid", "PayAsYouGo", "PostPaid", "PayOnDemand", "Postpaid"],
        }));
    }
    errors.collect(ros.propertyValidator('chargeType', ros.validateString)(properties.chargeType));
    errors.collect(ros.propertyValidator('encryptionProviderKey', ros.validateString)(properties.encryptionProviderKey));
    errors.collect(ros.propertyValidator('snatEntry', ros.validateBoolean)(properties.snatEntry));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["Week", "Month"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    return errors.wrap('supplied properties not correct for "RosManagedKubernetesClusterProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster` resource
 *
 * @param properties - the TypeScript properties of a `RosManagedKubernetesClusterProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster` resource.
 */
// @ts-ignore TS6133
function rosManagedKubernetesClusterPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosManagedKubernetesClusterPropsValidator(properties).assertSuccess();
    }
    return {
        Name: ros.stringToRosTemplate(properties.name),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        VSwitchIds: ros.listMapper(ros.objectToRosTemplate)(properties.vSwitchIds),
        WorkerInstanceTypes: ros.listMapper(ros.stringToRosTemplate)(properties.workerInstanceTypes),
        Addons: ros.listMapper(rosManagedKubernetesClusterAddonsPropertyToRosTemplate)(properties.addons),
        AutoRenew: ros.booleanToRosTemplate(properties.autoRenew),
        AutoRenewPeriod: ros.numberToRosTemplate(properties.autoRenewPeriod),
        ChargeType: ros.stringToRosTemplate(properties.chargeType),
        CisEnabled: ros.booleanToRosTemplate(properties.cisEnabled),
        CloudMonitorFlags: ros.booleanToRosTemplate(properties.cloudMonitorFlags),
        ClusterSpec: ros.stringToRosTemplate(properties.clusterSpec),
        ContainerCidr: ros.stringToRosTemplate(properties.containerCidr),
        DeletionProtection: ros.booleanToRosTemplate(properties.deletionProtection),
        DisableRollback: ros.booleanToRosTemplate(properties.disableRollback),
        EncryptionProviderKey: ros.stringToRosTemplate(properties.encryptionProviderKey),
        EndpointPublicAccess: ros.booleanToRosTemplate(properties.endpointPublicAccess),
        FormatDisk: ros.booleanToRosTemplate(properties.formatDisk),
        IsEnterpriseSecurityGroup: ros.booleanToRosTemplate(properties.isEnterpriseSecurityGroup),
        KeepInstanceName: ros.booleanToRosTemplate(properties.keepInstanceName),
        KeyPair: ros.stringToRosTemplate(properties.keyPair),
        KubernetesVersion: ros.stringToRosTemplate(properties.kubernetesVersion),
        LoadBalancerSpec: ros.stringToRosTemplate(properties.loadBalancerSpec),
        LoginPassword: ros.stringToRosTemplate(properties.loginPassword),
        NodeCidrMask: ros.stringToRosTemplate(properties.nodeCidrMask),
        NodePools: ros.listMapper(rosManagedKubernetesClusterNodePoolsPropertyToRosTemplate)(properties.nodePools),
        NumOfNodes: ros.numberToRosTemplate(properties.numOfNodes),
        OsType: ros.stringToRosTemplate(properties.osType),
        Period: ros.numberToRosTemplate(properties.period),
        PeriodUnit: ros.stringToRosTemplate(properties.periodUnit),
        Platform: ros.stringToRosTemplate(properties.platform),
        PodVswitchIds: ros.listMapper(ros.stringToRosTemplate)(properties.podVswitchIds),
        ProxyMode: ros.stringToRosTemplate(properties.proxyMode),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        Runtime: rosManagedKubernetesClusterRuntimePropertyToRosTemplate(properties.runtime),
        SecurityGroupId: ros.stringToRosTemplate(properties.securityGroupId),
        ServiceCidr: ros.stringToRosTemplate(properties.serviceCidr),
        SnatEntry: ros.booleanToRosTemplate(properties.snatEntry),
        SocEnabled: ros.booleanToRosTemplate(properties.socEnabled),
        Tags: ros.listMapper(rosManagedKubernetesClusterTagsPropertyToRosTemplate)(properties.tags),
        Taint: ros.listMapper(ros.anyDictToRosTemplate)(properties.taint),
        TimeoutMins: ros.numberToRosTemplate(properties.timeoutMins),
        UserData: ros.stringToRosTemplate(properties.userData),
        WorkerDataDisk: ros.booleanToRosTemplate(properties.workerDataDisk),
        WorkerDataDisks: ros.listMapper(rosManagedKubernetesClusterWorkerDataDisksPropertyToRosTemplate)(properties.workerDataDisks),
        WorkerSystemDiskCategory: ros.stringToRosTemplate(properties.workerSystemDiskCategory),
        WorkerSystemDiskSize: ros.numberToRosTemplate(properties.workerSystemDiskSize),
        ZoneIds: ros.listMapper(ros.stringToRosTemplate)(properties.zoneIds),
    };
}
/**
 * A ROS template type:  `ALIYUN::CS::ManagedKubernetesCluster`
 */
class RosManagedKubernetesCluster extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CS::ManagedKubernetesCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosManagedKubernetesCluster.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrApiServerSlbId = this.getAtt('APIServerSLBId');
        this.attrClusterId = this.getAtt('ClusterId');
        this.attrDefaultUserKubeConfig = this.getAtt('DefaultUserKubeConfig');
        this.attrNodes = this.getAtt('Nodes');
        this.attrPrivateUserKubConfig = this.getAtt('PrivateUserKubConfig');
        this.attrScalingConfigurationId = this.getAtt('ScalingConfigurationId');
        this.attrScalingGroupId = this.getAtt('ScalingGroupId');
        this.attrScalingRuleId = this.getAtt('ScalingRuleId');
        this.attrTaskId = this.getAtt('TaskId');
        this.attrWorkerRamRoleName = this.getAtt('WorkerRamRoleName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.name = props.name;
        this.vpcId = props.vpcId;
        this.vSwitchIds = props.vSwitchIds;
        this.workerInstanceTypes = props.workerInstanceTypes;
        this.addons = props.addons;
        this.autoRenew = props.autoRenew;
        this.autoRenewPeriod = props.autoRenewPeriod;
        this.chargeType = props.chargeType;
        this.cisEnabled = props.cisEnabled;
        this.cloudMonitorFlags = props.cloudMonitorFlags;
        this.clusterSpec = props.clusterSpec;
        this.containerCidr = props.containerCidr;
        this.deletionProtection = props.deletionProtection;
        this.disableRollback = props.disableRollback;
        this.encryptionProviderKey = props.encryptionProviderKey;
        this.endpointPublicAccess = props.endpointPublicAccess;
        this.formatDisk = props.formatDisk;
        this.isEnterpriseSecurityGroup = props.isEnterpriseSecurityGroup;
        this.keepInstanceName = props.keepInstanceName;
        this.keyPair = props.keyPair;
        this.kubernetesVersion = props.kubernetesVersion;
        this.loadBalancerSpec = props.loadBalancerSpec;
        this.loginPassword = props.loginPassword;
        this.nodeCidrMask = props.nodeCidrMask;
        this.nodePools = props.nodePools;
        this.numOfNodes = props.numOfNodes;
        this.osType = props.osType;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.platform = props.platform;
        this.podVswitchIds = props.podVswitchIds;
        this.proxyMode = props.proxyMode;
        this.resourceGroupId = props.resourceGroupId;
        this.runtime = props.runtime;
        this.securityGroupId = props.securityGroupId;
        this.serviceCidr = props.serviceCidr;
        this.snatEntry = props.snatEntry;
        this.socEnabled = props.socEnabled;
        this.tags = props.tags;
        this.taint = props.taint;
        this.timeoutMins = props.timeoutMins;
        this.userData = props.userData;
        this.workerDataDisk = props.workerDataDisk;
        this.workerDataDisks = props.workerDataDisks;
        this.workerSystemDiskCategory = props.workerSystemDiskCategory;
        this.workerSystemDiskSize = props.workerSystemDiskSize;
        this.zoneIds = props.zoneIds;
    }
    get rosProperties() {
        return {
            name: this.name,
            vpcId: this.vpcId,
            vSwitchIds: this.vSwitchIds,
            workerInstanceTypes: this.workerInstanceTypes,
            addons: this.addons,
            autoRenew: this.autoRenew,
            autoRenewPeriod: this.autoRenewPeriod,
            chargeType: this.chargeType,
            cisEnabled: this.cisEnabled,
            cloudMonitorFlags: this.cloudMonitorFlags,
            clusterSpec: this.clusterSpec,
            containerCidr: this.containerCidr,
            deletionProtection: this.deletionProtection,
            disableRollback: this.disableRollback,
            encryptionProviderKey: this.encryptionProviderKey,
            endpointPublicAccess: this.endpointPublicAccess,
            formatDisk: this.formatDisk,
            isEnterpriseSecurityGroup: this.isEnterpriseSecurityGroup,
            keepInstanceName: this.keepInstanceName,
            keyPair: this.keyPair,
            kubernetesVersion: this.kubernetesVersion,
            loadBalancerSpec: this.loadBalancerSpec,
            loginPassword: this.loginPassword,
            nodeCidrMask: this.nodeCidrMask,
            nodePools: this.nodePools,
            numOfNodes: this.numOfNodes,
            osType: this.osType,
            period: this.period,
            periodUnit: this.periodUnit,
            platform: this.platform,
            podVswitchIds: this.podVswitchIds,
            proxyMode: this.proxyMode,
            resourceGroupId: this.resourceGroupId,
            runtime: this.runtime,
            securityGroupId: this.securityGroupId,
            serviceCidr: this.serviceCidr,
            snatEntry: this.snatEntry,
            socEnabled: this.socEnabled,
            tags: this.tags,
            taint: this.taint,
            timeoutMins: this.timeoutMins,
            userData: this.userData,
            workerDataDisk: this.workerDataDisk,
            workerDataDisks: this.workerDataDisks,
            workerSystemDiskCategory: this.workerSystemDiskCategory,
            workerSystemDiskSize: this.workerSystemDiskSize,
            zoneIds: this.zoneIds,
        };
    }
    renderProperties(props) {
        return rosManagedKubernetesClusterPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosManagedKubernetesCluster = RosManagedKubernetesCluster;
/**
 * The resource type name for this resource class.
 */
RosManagedKubernetesCluster.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CS::ManagedKubernetesCluster";
/**
 * Determine whether the given properties match those of a `AddonsProperty`
 *
 * @param properties - the TypeScript properties of a `AddonsProperty`
 *
 * @returns the result of the validation.
 */
function RosManagedKubernetesCluster_AddonsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('version', ros.validateString)(properties.version));
    errors.collect(ros.propertyValidator('config', ros.validateString)(properties.config));
    errors.collect(ros.propertyValidator('disabled', ros.validateBoolean)(properties.disabled));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "AddonsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.Addons` resource
 *
 * @param properties - the TypeScript properties of a `AddonsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.Addons` resource.
 */
// @ts-ignore TS6133
function rosManagedKubernetesClusterAddonsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosManagedKubernetesCluster_AddonsPropertyValidator(properties).assertSuccess();
    return {
        Version: ros.stringToRosTemplate(properties.version),
        Config: ros.stringToRosTemplate(properties.config),
        Disabled: ros.booleanToRosTemplate(properties.disabled),
        Name: ros.stringToRosTemplate(properties.name),
    };
}
/**
 * Determine whether the given properties match those of a `DataDisksProperty`
 *
 * @param properties - the TypeScript properties of a `DataDisksProperty`
 *
 * @returns the result of the validation.
 */
function RosManagedKubernetesCluster_DataDisksPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('category', ros.validateString)(properties.category));
    errors.collect(ros.propertyValidator('encrypted', ros.validateBoolean)(properties.encrypted));
    errors.collect(ros.propertyValidator('performanceLevel', ros.validateString)(properties.performanceLevel));
    errors.collect(ros.propertyValidator('size', ros.validateNumber)(properties.size));
    errors.collect(ros.propertyValidator('autoSnapshotPolicyId', ros.validateString)(properties.autoSnapshotPolicyId));
    return errors.wrap('supplied properties not correct for "DataDisksProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.DataDisks` resource
 *
 * @param properties - the TypeScript properties of a `DataDisksProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.DataDisks` resource.
 */
// @ts-ignore TS6133
function rosManagedKubernetesClusterDataDisksPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosManagedKubernetesCluster_DataDisksPropertyValidator(properties).assertSuccess();
    return {
        Category: ros.stringToRosTemplate(properties.category),
        Encrypted: ros.booleanToRosTemplate(properties.encrypted),
        PerformanceLevel: ros.stringToRosTemplate(properties.performanceLevel),
        Size: ros.numberToRosTemplate(properties.size),
        AutoSnapshotPolicyId: ros.stringToRosTemplate(properties.autoSnapshotPolicyId),
    };
}
/**
 * Determine whether the given properties match those of a `KubernetesConfigProperty`
 *
 * @param properties - the TypeScript properties of a `KubernetesConfigProperty`
 *
 * @returns the result of the validation.
 */
function RosManagedKubernetesCluster_KubernetesConfigPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('runtime', ros.requiredValidator)(properties.runtime));
    errors.collect(ros.propertyValidator('runtime', ros.validateString)(properties.runtime));
    errors.collect(ros.propertyValidator('cpuPolicy', ros.validateString)(properties.cpuPolicy));
    errors.collect(ros.propertyValidator('runtimeVersion', ros.requiredValidator)(properties.runtimeVersion));
    errors.collect(ros.propertyValidator('runtimeVersion', ros.validateString)(properties.runtimeVersion));
    if (properties.labels && (Array.isArray(properties.labels) || (typeof properties.labels) === 'string')) {
        errors.collect(ros.propertyValidator('labels', ros.validateLength)({
            data: properties.labels.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('labels', ros.listValidator(RosManagedKubernetesCluster_LabelsPropertyValidator))(properties.labels));
    return errors.wrap('supplied properties not correct for "KubernetesConfigProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.KubernetesConfig` resource
 *
 * @param properties - the TypeScript properties of a `KubernetesConfigProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.KubernetesConfig` resource.
 */
// @ts-ignore TS6133
function rosManagedKubernetesClusterKubernetesConfigPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosManagedKubernetesCluster_KubernetesConfigPropertyValidator(properties).assertSuccess();
    return {
        Runtime: ros.stringToRosTemplate(properties.runtime),
        CpuPolicy: ros.stringToRosTemplate(properties.cpuPolicy),
        RuntimeVersion: ros.stringToRosTemplate(properties.runtimeVersion),
        Labels: ros.listMapper(rosManagedKubernetesClusterLabelsPropertyToRosTemplate)(properties.labels),
    };
}
/**
 * Determine whether the given properties match those of a `LabelsProperty`
 *
 * @param properties - the TypeScript properties of a `LabelsProperty`
 *
 * @returns the result of the validation.
 */
function RosManagedKubernetesCluster_LabelsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.requiredValidator)(properties.value));
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "LabelsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.Labels` resource
 *
 * @param properties - the TypeScript properties of a `LabelsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.Labels` resource.
 */
// @ts-ignore TS6133
function rosManagedKubernetesClusterLabelsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosManagedKubernetesCluster_LabelsPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `NodePoolInfoProperty`
 *
 * @param properties - the TypeScript properties of a `NodePoolInfoProperty`
 *
 * @returns the result of the validation.
 */
function RosManagedKubernetesCluster_NodePoolInfoPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "NodePoolInfoProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.NodePoolInfo` resource
 *
 * @param properties - the TypeScript properties of a `NodePoolInfoProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.NodePoolInfo` resource.
 */
// @ts-ignore TS6133
function rosManagedKubernetesClusterNodePoolInfoPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosManagedKubernetesCluster_NodePoolInfoPropertyValidator(properties).assertSuccess();
    return {
        Name: ros.stringToRosTemplate(properties.name),
    };
}
/**
 * Determine whether the given properties match those of a `NodePoolsProperty`
 *
 * @param properties - the TypeScript properties of a `NodePoolsProperty`
 *
 * @returns the result of the validation.
 */
function RosManagedKubernetesCluster_NodePoolsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('nodePoolInfo', RosManagedKubernetesCluster_NodePoolInfoPropertyValidator)(properties.nodePoolInfo));
    errors.collect(ros.propertyValidator('kubernetesConfig', RosManagedKubernetesCluster_KubernetesConfigPropertyValidator)(properties.kubernetesConfig));
    errors.collect(ros.propertyValidator('count', ros.validateNumber)(properties.count));
    errors.collect(ros.propertyValidator('scalingGroup', ros.requiredValidator)(properties.scalingGroup));
    errors.collect(ros.propertyValidator('scalingGroup', RosManagedKubernetesCluster_ScalingGroupPropertyValidator)(properties.scalingGroup));
    return errors.wrap('supplied properties not correct for "NodePoolsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.NodePools` resource
 *
 * @param properties - the TypeScript properties of a `NodePoolsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.NodePools` resource.
 */
// @ts-ignore TS6133
function rosManagedKubernetesClusterNodePoolsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosManagedKubernetesCluster_NodePoolsPropertyValidator(properties).assertSuccess();
    return {
        NodePoolInfo: rosManagedKubernetesClusterNodePoolInfoPropertyToRosTemplate(properties.nodePoolInfo),
        KubernetesConfig: rosManagedKubernetesClusterKubernetesConfigPropertyToRosTemplate(properties.kubernetesConfig),
        Count: ros.numberToRosTemplate(properties.count),
        ScalingGroup: rosManagedKubernetesClusterScalingGroupPropertyToRosTemplate(properties.scalingGroup),
    };
}
/**
 * Determine whether the given properties match those of a `RuntimeProperty`
 *
 * @param properties - the TypeScript properties of a `RuntimeProperty`
 *
 * @returns the result of the validation.
 */
function RosManagedKubernetesCluster_RuntimePropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('version', ros.validateString)(properties.version));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "RuntimeProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.Runtime` resource
 *
 * @param properties - the TypeScript properties of a `RuntimeProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.Runtime` resource.
 */
// @ts-ignore TS6133
function rosManagedKubernetesClusterRuntimePropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosManagedKubernetesCluster_RuntimePropertyValidator(properties).assertSuccess();
    return {
        Version: ros.stringToRosTemplate(properties.version),
        Name: ros.stringToRosTemplate(properties.name),
    };
}
/**
 * Determine whether the given properties match those of a `ScalingGroupProperty`
 *
 * @param properties - the TypeScript properties of a `ScalingGroupProperty`
 *
 * @returns the result of the validation.
 */
function RosManagedKubernetesCluster_ScalingGroupPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('keyPair', ros.validateString)(properties.keyPair));
    errors.collect(ros.propertyValidator('platform', ros.validateString)(properties.platform));
    if (properties.dataDisks && (Array.isArray(properties.dataDisks) || (typeof properties.dataDisks) === 'string')) {
        errors.collect(ros.propertyValidator('dataDisks', ros.validateLength)({
            data: properties.dataDisks.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('dataDisks', ros.listValidator(RosManagedKubernetesCluster_DataDisksPropertyValidator))(properties.dataDisks));
    errors.collect(ros.propertyValidator('vSwitchIds', ros.requiredValidator)(properties.vSwitchIds));
    if (properties.vSwitchIds && (Array.isArray(properties.vSwitchIds) || (typeof properties.vSwitchIds) === 'string')) {
        errors.collect(ros.propertyValidator('vSwitchIds', ros.validateLength)({
            data: properties.vSwitchIds.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('vSwitchIds', ros.listValidator(ros.validateString))(properties.vSwitchIds));
    errors.collect(ros.propertyValidator('systemDiskSize', ros.requiredValidator)(properties.systemDiskSize));
    errors.collect(ros.propertyValidator('systemDiskSize', ros.validateNumber)(properties.systemDiskSize));
    errors.collect(ros.propertyValidator('instanceChargeType', ros.validateString)(properties.instanceChargeType));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateRange)({
            data: properties.period,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('systemDiskCategory', ros.validateString)(properties.systemDiskCategory));
    errors.collect(ros.propertyValidator('internetChargeType', ros.validateString)(properties.internetChargeType));
    errors.collect(ros.propertyValidator('isEnterpriseSecurityGroup', ros.validateBoolean)(properties.isEnterpriseSecurityGroup));
    errors.collect(ros.propertyValidator('internetMaxBandwidthOut', ros.validateNumber)(properties.internetMaxBandwidthOut));
    errors.collect(ros.propertyValidator('systemDiskPerformanceLevel', ros.validateString)(properties.systemDiskPerformanceLevel));
    if (properties.rdsInstances && (Array.isArray(properties.rdsInstances) || (typeof properties.rdsInstances) === 'string')) {
        errors.collect(ros.propertyValidator('rdsInstances', ros.validateLength)({
            data: properties.rdsInstances.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('rdsInstances', ros.listValidator(ros.validateString))(properties.rdsInstances));
    errors.collect(ros.propertyValidator('imageId', ros.validateString)(properties.imageId));
    errors.collect(ros.propertyValidator('instanceTypes', ros.requiredValidator)(properties.instanceTypes));
    if (properties.instanceTypes && (Array.isArray(properties.instanceTypes) || (typeof properties.instanceTypes) === 'string')) {
        errors.collect(ros.propertyValidator('instanceTypes', ros.validateLength)({
            data: properties.instanceTypes.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('instanceTypes', ros.listValidator(ros.validateString))(properties.instanceTypes));
    if (properties.tags && (Array.isArray(properties.tags) || (typeof properties.tags) === 'string')) {
        errors.collect(ros.propertyValidator('tags', ros.validateLength)({
            data: properties.tags.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosManagedKubernetesCluster_ScalingGroupTagsPropertyValidator))(properties.tags));
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    errors.collect(ros.propertyValidator('loginPassword', ros.validateString)(properties.loginPassword));
    return errors.wrap('supplied properties not correct for "ScalingGroupProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.ScalingGroup` resource
 *
 * @param properties - the TypeScript properties of a `ScalingGroupProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.ScalingGroup` resource.
 */
// @ts-ignore TS6133
function rosManagedKubernetesClusterScalingGroupPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosManagedKubernetesCluster_ScalingGroupPropertyValidator(properties).assertSuccess();
    return {
        KeyPair: ros.stringToRosTemplate(properties.keyPair),
        Platform: ros.stringToRosTemplate(properties.platform),
        DataDisks: ros.listMapper(rosManagedKubernetesClusterDataDisksPropertyToRosTemplate)(properties.dataDisks),
        VSwitchIds: ros.listMapper(ros.stringToRosTemplate)(properties.vSwitchIds),
        SystemDiskSize: ros.numberToRosTemplate(properties.systemDiskSize),
        InstanceChargeType: ros.stringToRosTemplate(properties.instanceChargeType),
        Period: ros.numberToRosTemplate(properties.period),
        SystemDiskCategory: ros.stringToRosTemplate(properties.systemDiskCategory),
        InternetChargeType: ros.stringToRosTemplate(properties.internetChargeType),
        IsEnterpriseSecurityGroup: ros.booleanToRosTemplate(properties.isEnterpriseSecurityGroup),
        InternetMaxBandwidthOut: ros.numberToRosTemplate(properties.internetMaxBandwidthOut),
        SystemDiskPerformanceLevel: ros.stringToRosTemplate(properties.systemDiskPerformanceLevel),
        RdsInstances: ros.listMapper(ros.stringToRosTemplate)(properties.rdsInstances),
        ImageId: ros.stringToRosTemplate(properties.imageId),
        InstanceTypes: ros.listMapper(ros.stringToRosTemplate)(properties.instanceTypes),
        Tags: ros.listMapper(rosManagedKubernetesClusterScalingGroupTagsPropertyToRosTemplate)(properties.tags),
        PeriodUnit: ros.stringToRosTemplate(properties.periodUnit),
        LoginPassword: ros.stringToRosTemplate(properties.loginPassword),
    };
}
/**
 * Determine whether the given properties match those of a `ScalingGroupTagsProperty`
 *
 * @param properties - the TypeScript properties of a `ScalingGroupTagsProperty`
 *
 * @returns the result of the validation.
 */
function RosManagedKubernetesCluster_ScalingGroupTagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.requiredValidator)(properties.value));
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "ScalingGroupTagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.ScalingGroupTags` resource
 *
 * @param properties - the TypeScript properties of a `ScalingGroupTagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.ScalingGroupTags` resource.
 */
// @ts-ignore TS6133
function rosManagedKubernetesClusterScalingGroupTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosManagedKubernetesCluster_ScalingGroupTagsPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function RosManagedKubernetesCluster_TagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.Tags` resource.
 */
// @ts-ignore TS6133
function rosManagedKubernetesClusterTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosManagedKubernetesCluster_TagsPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `WorkerDataDisksProperty`
 *
 * @param properties - the TypeScript properties of a `WorkerDataDisksProperty`
 *
 * @returns the result of the validation.
 */
function RosManagedKubernetesCluster_WorkerDataDisksPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('category', ros.requiredValidator)(properties.category));
    errors.collect(ros.propertyValidator('category', ros.validateString)(properties.category));
    errors.collect(ros.propertyValidator('size', ros.requiredValidator)(properties.size));
    if (properties.size && (typeof properties.size) !== 'object') {
        errors.collect(ros.propertyValidator('size', ros.validateRange)({
            data: properties.size,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('size', ros.validateNumber)(properties.size));
    return errors.wrap('supplied properties not correct for "WorkerDataDisksProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.WorkerDataDisks` resource
 *
 * @param properties - the TypeScript properties of a `WorkerDataDisksProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.WorkerDataDisks` resource.
 */
// @ts-ignore TS6133
function rosManagedKubernetesClusterWorkerDataDisksPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosManagedKubernetesCluster_WorkerDataDisksPropertyValidator(properties).assertSuccess();
    return {
        Category: ros.stringToRosTemplate(properties.category),
        Size: ros.numberToRosTemplate(properties.size),
    };
}
/**
 * Determine whether the given properties match those of a `RosServerlessKubernetesClusterProps`
 *
 * @param properties - the TypeScript properties of a `RosServerlessKubernetesClusterProps`
 *
 * @returns the result of the validation.
 */
function RosServerlessKubernetesClusterPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('kubernetesVersion', ros.validateString)(properties.kubernetesVersion));
    errors.collect(ros.propertyValidator('endpointPublicAccess', ros.validateBoolean)(properties.endpointPublicAccess));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    if (properties.vSwitchIds && (Array.isArray(properties.vSwitchIds) || (typeof properties.vSwitchIds) === 'string')) {
        errors.collect(ros.propertyValidator('vSwitchIds', ros.validateLength)({
            data: properties.vSwitchIds.length,
            min: 1,
            max: 10,
        }));
    }
    errors.collect(ros.propertyValidator('vSwitchIds', ros.listValidator(ros.validateAny))(properties.vSwitchIds));
    errors.collect(ros.propertyValidator('securityGroupId', ros.validateString)(properties.securityGroupId));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('addons', ros.listValidator(RosServerlessKubernetesCluster_AddonsPropertyValidator))(properties.addons));
    errors.collect(ros.propertyValidator('natGateway', ros.validateBoolean)(properties.natGateway));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    errors.collect(ros.propertyValidator('serviceCidr', ros.validateString)(properties.serviceCidr));
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosServerlessKubernetesCluster_TagsPropertyValidator))(properties.tags));
    errors.collect(ros.propertyValidator('privateZone', ros.validateBoolean)(properties.privateZone));
    return errors.wrap('supplied properties not correct for "RosServerlessKubernetesClusterProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ServerlessKubernetesCluster` resource
 *
 * @param properties - the TypeScript properties of a `RosServerlessKubernetesClusterProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ServerlessKubernetesCluster` resource.
 */
// @ts-ignore TS6133
function rosServerlessKubernetesClusterPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosServerlessKubernetesClusterPropsValidator(properties).assertSuccess();
    }
    return {
        Name: ros.stringToRosTemplate(properties.name),
        Addons: ros.listMapper(rosServerlessKubernetesClusterAddonsPropertyToRosTemplate)(properties.addons),
        EndpointPublicAccess: ros.booleanToRosTemplate(properties.endpointPublicAccess),
        KubernetesVersion: ros.stringToRosTemplate(properties.kubernetesVersion),
        NatGateway: ros.booleanToRosTemplate(properties.natGateway),
        PrivateZone: ros.booleanToRosTemplate(properties.privateZone),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        SecurityGroupId: ros.stringToRosTemplate(properties.securityGroupId),
        ServiceCidr: ros.stringToRosTemplate(properties.serviceCidr),
        Tags: ros.listMapper(rosServerlessKubernetesClusterTagsPropertyToRosTemplate)(properties.tags),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
        VSwitchIds: ros.listMapper(ros.objectToRosTemplate)(properties.vSwitchIds),
        ZoneId: ros.stringToRosTemplate(properties.zoneId),
    };
}
/**
 * A ROS template type:  `ALIYUN::CS::ServerlessKubernetesCluster`
 */
class RosServerlessKubernetesCluster extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CS::ServerlessKubernetesCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosServerlessKubernetesCluster.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrApiServerSlbId = this.getAtt('APIServerSLBId');
        this.attrClusterId = this.getAtt('ClusterId');
        this.attrDefaultUserKubeConfig = this.getAtt('DefaultUserKubeConfig');
        this.attrNodes = this.getAtt('Nodes');
        this.attrPrivateUserKubConfig = this.getAtt('PrivateUserKubConfig');
        this.attrScalingConfigurationId = this.getAtt('ScalingConfigurationId');
        this.attrScalingGroupId = this.getAtt('ScalingGroupId');
        this.attrScalingRuleId = this.getAtt('ScalingRuleId');
        this.attrTaskId = this.getAtt('TaskId');
        this.attrWorkerRamRoleName = this.getAtt('WorkerRamRoleName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.name = props.name;
        this.addons = props.addons;
        this.endpointPublicAccess = props.endpointPublicAccess;
        this.kubernetesVersion = props.kubernetesVersion;
        this.natGateway = props.natGateway;
        this.privateZone = props.privateZone;
        this.resourceGroupId = props.resourceGroupId;
        this.securityGroupId = props.securityGroupId;
        this.serviceCidr = props.serviceCidr;
        this.tags = props.tags;
        this.vpcId = props.vpcId;
        this.vSwitchId = props.vSwitchId;
        this.vSwitchIds = props.vSwitchIds;
        this.zoneId = props.zoneId;
    }
    get rosProperties() {
        return {
            name: this.name,
            addons: this.addons,
            endpointPublicAccess: this.endpointPublicAccess,
            kubernetesVersion: this.kubernetesVersion,
            natGateway: this.natGateway,
            privateZone: this.privateZone,
            resourceGroupId: this.resourceGroupId,
            securityGroupId: this.securityGroupId,
            serviceCidr: this.serviceCidr,
            tags: this.tags,
            vpcId: this.vpcId,
            vSwitchId: this.vSwitchId,
            vSwitchIds: this.vSwitchIds,
            zoneId: this.zoneId,
        };
    }
    renderProperties(props) {
        return rosServerlessKubernetesClusterPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosServerlessKubernetesCluster = RosServerlessKubernetesCluster;
/**
 * The resource type name for this resource class.
 */
RosServerlessKubernetesCluster.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CS::ServerlessKubernetesCluster";
/**
 * Determine whether the given properties match those of a `AddonsProperty`
 *
 * @param properties - the TypeScript properties of a `AddonsProperty`
 *
 * @returns the result of the validation.
 */
function RosServerlessKubernetesCluster_AddonsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('config', ros.validateString)(properties.config));
    errors.collect(ros.propertyValidator('disabled', ros.validateBoolean)(properties.disabled));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "AddonsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ServerlessKubernetesCluster.Addons` resource
 *
 * @param properties - the TypeScript properties of a `AddonsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ServerlessKubernetesCluster.Addons` resource.
 */
// @ts-ignore TS6133
function rosServerlessKubernetesClusterAddonsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosServerlessKubernetesCluster_AddonsPropertyValidator(properties).assertSuccess();
    return {
        Config: ros.stringToRosTemplate(properties.config),
        Disabled: ros.booleanToRosTemplate(properties.disabled),
        Name: ros.stringToRosTemplate(properties.name),
    };
}
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function RosServerlessKubernetesCluster_TagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ServerlessKubernetesCluster.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ServerlessKubernetesCluster.Tags` resource.
 */
// @ts-ignore TS6133
function rosServerlessKubernetesClusterTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosServerlessKubernetesCluster_TagsPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
//# sourceMappingURL=data:application/json;base64,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