# -*- coding: utf-8 -*-
"""CNIN_20250505_00.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1Wj9-G9HLaIhATomuQJ2-8V4u5CYnW_rf

# CondaInitializer
Colab 上で condacolab を使って conda (mamba, conda-pack) 環境を初期化し、以降の処理で conda コマンドをそのまま使えるようにします。


```
2025/05/05 1.0.5 完成
```

---

# CondaInitializer

## 1. モジュール定義
"""

# @title a. CondaInitializer 定義

from google.colab import drive
import subprocess
import sys

class CondaInitializer:
    """
    Colab 上で condacolab を使って conda (mamba, conda-pack) 環境を
    初期化し、以降の処理で conda コマンドをそのまま使えるようにします。
    """

    def __init__(self, mount_drive: bool = True):
        # 1) 必要なら Google Drive をマウント
        if mount_drive:
            print("Mounting Google Drive at /content/drive …")
            drive.mount("/content/drive", force_remount=True)

        # 2) condacolab インストール＆有効化
        print("Installing condacolab…")
        subprocess.run([sys.executable, "-m", "pip", "install", "-q", "condacolab"], check=True)
        import condacolab  # noqa: E402
        condacolab.install()

        # 3) bash で conda シェル初期化スクリプトを読み込む
        print("Sourcing conda.sh…")
        subprocess.run(
            ["bash", "-c", "source /usr/local/etc/profile.d/conda.sh"],
            shell=True,
            check=True
        )

        # 4) mamba のインストール
        print("Installing mamba in base…")
        subprocess.run(
            ["conda", "install", "-q", "mamba", "-n", "base", "-c", "conda-forge"],
            check=True
        )

        # 5) conda‑pack のインストール
        print("Installing conda-pack…")
        subprocess.run(
            ["conda", "install", "-y", "-q", "-c", "conda-forge", "conda-pack"],
            check=True
        )

        print("Conda environment is ready to use.")


if __name__ == "__main__":
    # Colab ノートブックで実行する場合は mount_drive=True のまま
    # ノートブック外からテスト実行するなら False にしてください
    CondaInitializer(mount_drive=True)