"""Initial migration

Revision ID: d869327be6c4
Revises:
Create Date: 2022-02-04 11:43:30.501952

"""
import sqlalchemy as sa
from alembic import op

import fief

# revision identifiers, used by Alembic.
revision = "d869327be6c4"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "accounts",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column("domain", sa.String(length=255), nullable=False),
        sa.Column(
            "database_type",
            sa.Enum("POSTGRESQL", "MYSQL", name="databasetype"),
            nullable=True,
        ),
        sa.Column("database_host", sa.Text(), nullable=True),
        sa.Column("database_port", sa.Text(), nullable=True),
        sa.Column("database_username", sa.Text(), nullable=True),
        sa.Column("database_password", sa.Text(), nullable=True),
        sa.Column("database_name", sa.Text(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_accounts_created_at"), "accounts", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_accounts_updated_at"), "accounts", ["updated_at"], unique=False
    )
    op.create_table(
        "admin_session_tokens",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column("token", sa.String(length=255), nullable=False),
        sa.Column("raw_tokens", sa.Text(), nullable=False),
        sa.Column("raw_userinfo", sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("token"),
    )
    op.create_index(
        op.f("ix_admin_session_tokens_created_at"),
        "admin_session_tokens",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_admin_session_tokens_updated_at"),
        "admin_session_tokens",
        ["updated_at"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_admin_session_tokens_updated_at"), table_name="admin_session_tokens"
    )
    op.drop_index(
        op.f("ix_admin_session_tokens_created_at"), table_name="admin_session_tokens"
    )
    op.drop_table("admin_session_tokens")
    op.drop_index(op.f("ix_accounts_updated_at"), table_name="accounts")
    op.drop_index(op.f("ix_accounts_created_at"), table_name="accounts")
    op.drop_table("accounts")
    # ### end Alembic commands ###
