from pydantic import BaseModel, Field, validator


class GnomadConstraintModel(BaseModel):
    obs_mis: float = Field(default=None)
    exp_mis: float = Field(default=None)
    oe_mis: float = Field(default=None)
    mu_mis: float = Field(default=None)
    possible_mis: float = Field(default=None)
    obs_mis_pphen: float = Field(default=None)
    exp_mis_pphen: float = Field(default=None)
    oe_mis_pphen: float = Field(default=None)
    possible_mis_pphen: float = Field(default=None)
    obs_syn: float = Field(default=None)
    exp_syn: float = Field(default=None)
    oe_syn: float = Field(default=None)
    mu_syn: float = Field(default=None)
    possible_syn: float = Field(default=None)
    obs_lof: float = Field(default=None)
    mu_lof: float = Field(default=None)
    possible_lof: float = Field(default=None)
    exp_lof: float = Field(default=None)
    pLI: float = Field(default=None)
    pNull: float = Field(default=None)
    pRec: float = Field(default=None)
    oe_lof: float = Field(default=None)
    oe_syn_lower: float = Field(default=None)
    oe_syn_upper: float = Field(default=None)
    oe_mis_lower: float = Field(default=None)
    oe_mis_upper: float = Field(default=None)
    oe_lof_lower: float = Field(default=None)
    oe_lof_upper: float = Field(default=None)
    constraint_flag: str = Field(default=None)
    syn_z: float = Field(default=None)
    mis_z: float = Field(default=None)
    lof_z: float = Field(default=None)
    oe_lof_upper_rank: float = Field(default=None)
    oe_lof_upper_bin: float = Field(default=None)
    oe_lof_upper_bin_6: float = Field(default=None)
    n_sites: float = Field(default=None)
    classic_caf: float = Field(default=None)
    max_af: float = Field(default=None)
    no_lofs: float = Field(default=None)
    obs_het_lof: float = Field(default=None)
    obs_hom_lof: float = Field(default=None)
    defined: float = Field(default=None)
    p: float = Field(default=None)
    exp_hom_lof: float = Field(default=None)
    classic_caf_afr: float = Field(default=None)
    classic_caf_amr: float = Field(default=None)
    classic_caf_asj: float = Field(default=None)
    classic_caf_eas: float = Field(default=None)
    classic_caf_fin: float = Field(default=None)
    classic_caf_nfe: float = Field(default=None)
    classic_caf_oth: float = Field(default=None)
    classic_caf_sas: float = Field(default=None)
    p_afr: float = Field(default=None)
    p_amr: float = Field(default=None)
    p_asj: float = Field(default=None)
    p_eas: float = Field(default=None)
    p_fin: float = Field(default=None)
    p_nfe: float = Field(default=None)
    p_oth: float = Field(default=None)
    p_sas: float = Field(default=None)
    transcript_type: str = Field(default=None)
    gene_id: str = Field(default=None)
    transcript_level: float = Field(default=None)
    cds_length: float = Field(default=None)
    num_coding_exons: float = Field(default=None)
    gene_type: str = Field(default=None)
    gene_length: float = Field(default=None)
    exac_pLI: float = Field(default=None)
    exac_obs_lof: float = Field(default=None)
    exac_exp_lof: float = Field(default=None)
    exac_oe_lof: float = Field(default=None)
    brain_expression: str = Field(default=None)
    chromosome: str = Field(default=None)
    start_position: float = Field(default=None)
    end_position: float = Field(default=None)

    @validator("*", pre=True)
    def detect_NA_values(cls, v):
        if v == "NA":
            return None
        return v
