# Deep-Learning-Blocks
A library with customized PyTorch layers and model components.

- [Install](README.md#install)
- [Documentation](README.md#documentation)
- [What's available](README.md#whats-available)
- [Bug/Feature](README.md#bug-or-feature)

## Install:
To install the latest stable version:
> pip install deepblocks

For a specific version:
> pip install deepblocks==0.1.1

To install the latest, but unstable version:
> pip install git+https://github.com/blurry-mood/Deep-Learning-Blocks

## What's available:
### **Networks**
* U-Net
* ICT-Net

### **Layers**
* Flip-Invariant Conv2d
* Squeeze-Excitation Block
* Dense Block
* Multi-Head Self-Attention
* Multi-Head Self-Attention V2

### **Activations**
* Funnel ReLU

### **Loss Functions**
* Focal Loss
* AUC Loss
* AUC Margin Loss
* KL Divergence Loss
  
### **Regularization functions**
* Anti-Correlation

### **Self-supervised Learning**
* Barlow Twin
* DINO

### **Optimizers**
* SAM


## Documentation:
The current documention is hosted 
[here](https://blurry-mood.github.io/Deep-Learning-Blocks/)

## Bug or Feature:
Deepblocks is a growing package. If you encounter a **bug** or would like to request a **feature**, please feel free to open an issue [here](https://github.com/blurry-mood/Deep-Learning-Blocks/issues).
