/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.welwindow;

import ca.pfv.spmf.gui.PreferencesManager;
import ca.pfv.spmf.welwindow.Plugin;
import ca.pfv.spmf.welwindow.PluginManager;
import ca.pfv.spmf.welwindow.PluginWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class DownloadWindow
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton jButton1;
    private JProgressBar jProgressBar1;
    private boolean stateWindow = false;
    private int count = 0;
    static long byteCountRead = 0L;
    private Thread workThead = null;
    boolean downloadFailed = false;

    public DownloadWindow(final String path, final boolean isUpdate, final PluginWindow mainPlugin) {
        byteCountRead = 0L;
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.initComponents();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    if (isUpdate) {
                        String pluginName = (String)mainPlugin.jTableInstalledPlugins.getModel().getValueAt(mainPlugin.jTableInstalledPlugins.getSelectedRow(), 0);
                        Plugin plugin = PluginManager.getInstalledPluginByNameFromList(pluginName);
                        plugin.getRepositoryURL();
                        String url1 = String.valueOf(plugin.getRepositoryURL()) + pluginName + "/" + pluginName + ".jar";
                        DownloadWindow.this.downLoadFromUrl(url1, String.valueOf(pluginName) + ".jar", path);
                        DownloadWindow.this.workThead.join();
                        if (DownloadWindow.this.downloadFailed) {
                            DownloadWindow.this.stateWindow = false;
                            DownloadWindow.this.jButton1.setText("Cancel");
                            DownloadWindow.this.jProgressBar1.setIndeterminate(false);
                            DownloadWindow.this.jProgressBar1.setMinimum(DownloadWindow.this.jProgressBar1.getMaximum());
                            DownloadWindow.this.jProgressBar1.setString(String.valueOf(byteCountRead) + " bytes - download failed");
                            DownloadWindow.this.setTitle("Download failed");
                        } else {
                            DownloadWindow.this.jProgressBar1.setIndeterminate(false);
                            DownloadWindow.this.jProgressBar1.setMinimum(DownloadWindow.this.jProgressBar1.getMaximum());
                            DownloadWindow.this.jProgressBar1.setString(String.valueOf(byteCountRead) + " bytes - completed");
                            DownloadWindow.this.jButton1.setText("Done");
                            DownloadWindow.this.setTitle("Download completed");
                            PluginManager.updatePlugin(plugin);
                        }
                    } else {
                        String pluginName = (String)mainPlugin.jTablePlugins.getModel().getValueAt(mainPlugin.jTablePlugins.getSelectedRow(), 0);
                        String url1 = String.valueOf(PreferencesManager.getInstance().getRepositoryURL()) + pluginName + "/" + pluginName + ".jar";
                        DownloadWindow.this.downLoadFromUrl(url1, String.valueOf(pluginName) + ".jar", path);
                        DownloadWindow.this.workThead.join();
                        if (DownloadWindow.this.downloadFailed) {
                            DownloadWindow.this.stateWindow = false;
                            DownloadWindow.this.jButton1.setText("Cancel");
                            DownloadWindow.this.jProgressBar1.setIndeterminate(false);
                            DownloadWindow.this.jProgressBar1.setMinimum(DownloadWindow.this.jProgressBar1.getMaximum());
                            DownloadWindow.this.jProgressBar1.setString(String.valueOf(byteCountRead) + " bytes - download failed");
                            DownloadWindow.this.setTitle("Download failed");
                        } else {
                            Plugin plugin = PluginManager.getPluginByNameFromList(pluginName);
                            PluginManager.installPlugin(plugin);
                            Object[] objectNew = new Object[]{plugin.getName(), plugin.getAuthor(), plugin.getCategory(), plugin.getVersion(), "Webpage"};
                            mainPlugin.tableModelInstalledPlugins.addRow(objectNew);
                            int i = 0;
                            while (i < mainPlugin.tableModelPlugins.getRowCount()) {
                                String name = (String)mainPlugin.tableModelPlugins.getValueAt(i, 0);
                                if (name.equals(plugin.getName())) {
                                    mainPlugin.tableModelPlugins.removeRow(i);
                                    break;
                                }
                                ++i;
                            }
                            DownloadWindow.this.jProgressBar1.setIndeterminate(false);
                            DownloadWindow.this.jProgressBar1.setMinimum(DownloadWindow.this.jProgressBar1.getMaximum());
                            DownloadWindow.this.jProgressBar1.setString(String.valueOf(byteCountRead) + " bytes - completed");
                            DownloadWindow.this.jButton1.setText("Done");
                            DownloadWindow.this.setTitle("Download completed");
                            mainPlugin.jButton2Install.setEnabled(false);
                            mainPlugin.jTextAreaDescription.setText("");
                        }
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
    }

    private void initComponents() {
        this.jProgressBar1 = new JProgressBar();
        this.jProgressBar1.setStringPainted(true);
        this.jProgressBar1.setIndeterminate(true);
        this.jButton1 = new JButton();
        this.setTitle("Downloading plugin...");
        this.jButton1.setText("Cancel");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(70, 70, 70).addComponent(this.jProgressBar1, -2, 288, -2).addContainerGap(71, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButton1).addGap(28, 28, 28)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(48, 48, 48).addComponent(this.jProgressBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 50, Short.MAX_VALUE).addComponent(this.jButton1).addContainerGap()));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadWindow.this.stateWindow = false;
                DownloadWindow.this.setVisible(false);
            }
        });
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void downLoadFromUrl(String urlStr, String fileName, String savePath) {
        try {
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(2000);
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            this.stateWindow = true;
            if (this.workThead == null) {
                this.workThead = new WorkThead();
                this.workThead.start();
            }
            InputStream inputStream = conn.getInputStream();
            byte[] getData = DownloadWindow.readInputStream(inputStream);
            File saveDir = new File(savePath);
            if (!saveDir.exists()) {
                saveDir.mkdir();
            }
            File file = new File(saveDir + File.separator + fileName);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(getData);
            fos.close();
            inputStream.close();
        }
        catch (IOException e) {
            this.downloadFailed = true;
        }
    }

    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
            byteCountRead += (long)len;
        }
        bos.close();
        return bos.toByteArray();
    }

    class WorkThead
    extends Thread {
        WorkThead() {
        }

        @Override
        public void run() {
            while (DownloadWindow.this.count < 100) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                if (!DownloadWindow.this.stateWindow) continue;
                DownloadWindow downloadWindow = DownloadWindow.this;
                downloadWindow.count = downloadWindow.count + 1;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DownloadWindow.this.jProgressBar1.setValue(DownloadWindow.this.count);
                        DownloadWindow.this.jProgressBar1.setString(String.valueOf(byteCountRead) + " bytes read");
                    }
                });
            }
        }
    }
}

