/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.tools.dataset_generator;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;

public class SequenceDatabaseGenerator {
    private static Random random = new Random(System.currentTimeMillis());

    public void generateDatabase(int sequenceCount, int maxDistinctItems, int itemCountByItemset, int itemsetCountBySequence, String output, boolean withTimestamps) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        int i = 0;
        while (i < sequenceCount) {
            if (i != 0) {
                writer.newLine();
            }
            int j = 0;
            while (j < itemsetCountBySequence) {
                HashSet<Integer> alreadyAdded = new HashSet<Integer>();
                if (withTimestamps) {
                    writer.write("<" + j + "> ");
                }
                ArrayList<Integer> itemset2 = new ArrayList<Integer>();
                int k = 0;
                while (k < itemCountByItemset) {
                    int item = random.nextInt(maxDistinctItems) + 1;
                    while (alreadyAdded.contains(item)) {
                        item = random.nextInt(maxDistinctItems) + 1;
                    }
                    alreadyAdded.add(item);
                    itemset2.add(item);
                    ++k;
                }
                Collections.sort(itemset2);
                for (Integer item : itemset2) {
                    writer.write(item + " ");
                }
                writer.write("-1 ");
                ++j;
            }
            writer.write("-2 ");
            ++i;
        }
        writer.close();
    }
}

