/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.classifiers.data.StringDataset;
import ca.pfv.spmf.algorithms.classifiers.decisiontree.id3.AlgoID3;
import ca.pfv.spmf.algorithms.classifiers.general.ClassificationAlgorithm;
import ca.pfv.spmf.algorithms.classifiers.general.Evaluator;
import ca.pfv.spmf.algorithms.classifiers.general.OverallResults;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class MainTestID3_batch_holdout {
    public static void main(String[] args) throws Exception {
        System.out.println("========= Step 1: Read the dataset ==========");
        String targetClassName = "play";
        String datasetPath = MainTestID3_batch_holdout.fileToPath("tennisExtended.txt");
        StringDataset dataset = new StringDataset(datasetPath, targetClassName);
        dataset.printStats();
        System.out.println("==== Step 2: Training:  Apply the algorithm to build a model ===");
        AlgoID3 algorithmID3 = new AlgoID3();
        Evaluator experiment1 = new Evaluator();
        double percentage = 0.5;
        ClassificationAlgorithm[] algorithms = new ClassificationAlgorithm[]{algorithmID3};
        OverallResults allResults = experiment1.trainAndRunClassifiersHoldout(algorithms, dataset, percentage);
        String forTrainingPath = "outputReportForTraining.txt";
        String onTrainingPath = "outputReportOnTraining.txt";
        String onTrestingPath = "outputReportOnTesting.txt";
        allResults.saveMetricsResultsToFile(forTrainingPath, onTrainingPath, onTrestingPath);
        allResults.printStats();
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestID3_batch_holdout.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

