/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.classifiers.acac.AlgoACAC;
import ca.pfv.spmf.algorithms.classifiers.accf.AlgoACCF;
import ca.pfv.spmf.algorithms.classifiers.acn.AlgoACN;
import ca.pfv.spmf.algorithms.classifiers.adt.AlgoADT;
import ca.pfv.spmf.algorithms.classifiers.cba.AlgoCBA;
import ca.pfv.spmf.algorithms.classifiers.cmar.AlgoCMAR;
import ca.pfv.spmf.algorithms.classifiers.data.StringDataset;
import ca.pfv.spmf.algorithms.classifiers.decisiontree.id3.AlgoID3;
import ca.pfv.spmf.algorithms.classifiers.general.ClassificationAlgorithm;
import ca.pfv.spmf.algorithms.classifiers.general.Evaluator;
import ca.pfv.spmf.algorithms.classifiers.general.OverallResults;
import ca.pfv.spmf.algorithms.classifiers.knn.AlgoKNN;
import ca.pfv.spmf.algorithms.classifiers.l3.AlgoL3;
import ca.pfv.spmf.algorithms.classifiers.mac.AlgoMAC;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class MainTestEVALUATOR_kfold {
    public static void main(String[] args) throws Exception {
        String targetClassName = "play";
        System.out.println("========= READ THE DATASET ==========");
        String datasetFile = MainTestEVALUATOR_kfold.fileToPath("tennisExtended.txt");
        StringDataset dataset = new StringDataset(datasetFile, targetClassName);
        dataset.printStats();
        System.out.println("========= PREPARE ALGORITHMS ==========");
        double minSup = 0.1;
        double minConf = 0.4;
        double minAllConf = 0.5;
        AlgoACAC algorithmACAC = new AlgoACAC(minSup, minConf, minAllConf);
        AlgoACCF algorithmACCF = new AlgoACCF(minSup, minConf);
        double minAcc = 0.55;
        double minCorr = 0.2;
        AlgoACN algorithmACN = new AlgoACN(minSup, minConf, minAcc, minCorr);
        AlgoADT algorithmADT = new AlgoADT(minSup, minConf);
        AlgoCBA algorithmCBA = new AlgoCBA(minSup, minConf, false);
        AlgoCBA algorithmCBA2 = new AlgoCBA(minSup, minConf, true);
        int delta = 2;
        AlgoCMAR algorithmCMAR = new AlgoCMAR(minSup, minConf, delta);
        AlgoL3 algorithmL3 = new AlgoL3(minSup, minConf);
        AlgoMAC algorithmMAC = new AlgoMAC(minSup, minConf);
        AlgoID3 algorithmID3 = new AlgoID3();
        int k = 3;
        AlgoKNN algorithmKNN = new AlgoKNN(k);
        ClassificationAlgorithm[] algorithms = new ClassificationAlgorithm[]{algorithmACAC, algorithmACCF, algorithmACN, algorithmADT, algorithmCBA, algorithmCBA2, algorithmMAC, algorithmL3, algorithmCMAR, algorithmID3, algorithmKNN};
        System.out.println("========= RUN EXPERIMENTS==========");
        String forTrainingPath = "outputReportForTraining.txt";
        String onTrainingPath = "outputReportOnTraining.txt";
        String onTrestingPath = "outputReportOnTesting.txt";
        Evaluator experiment1 = new Evaluator();
        int kFoldCount = 3;
        OverallResults allResults = experiment1.trainAndRunClassifiersKFold(algorithms, dataset, kFoldCount);
        allResults.saveMetricsResultsToFile(forTrainingPath, onTrainingPath, onTrestingPath);
        allResults.printStats();
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestEVALUATOR_kfold.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

