/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.algorithms.timeseries.autocorrelation.AlgoLagAutoCorrelation;
import ca.pfv.spmf.algorithms.timeseries.reader_writer.AlgoTimeSeriesReader;
import ca.pfv.spmf.algorithms.timeseries.reader_writer.AlgoTimeSeriesWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class MainTestAutocorrelationFileToFile {
    public static void main(String[] arg) throws IOException {
        String input = MainTestAutocorrelationFileToFile.fileToPath("contextAutocorrelation.txt");
        String output = "./output.txt";
        String separator = ",";
        int maxlag = 16;
        AlgoTimeSeriesReader reader = new AlgoTimeSeriesReader();
        List<TimeSeries> multipleTimeSeries = reader.runAlgorithm(input, separator);
        ArrayList<TimeSeries> resultMultipleTimeSeries = new ArrayList<TimeSeries>();
        for (TimeSeries timeSeries : multipleTimeSeries) {
            AlgoLagAutoCorrelation algorithm = new AlgoLagAutoCorrelation();
            TimeSeries aSeries = algorithm.runAlgorithm(timeSeries, maxlag);
            resultMultipleTimeSeries.add(aSeries);
            algorithm.printStats();
        }
        AlgoTimeSeriesWriter algorithm2 = new AlgoTimeSeriesWriter();
        algorithm2.runAlgorithm(output, resultMultipleTimeSeries, separator);
        algorithm2.printStats();
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestAutocorrelationFileToFile.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

