/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.classifiers.acac.AlgoACAC;
import ca.pfv.spmf.algorithms.classifiers.data.StringDataset;
import ca.pfv.spmf.algorithms.classifiers.general.ClassificationAlgorithm;
import ca.pfv.spmf.algorithms.classifiers.general.Evaluator;
import ca.pfv.spmf.algorithms.classifiers.general.OverallResults;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class MainTestACAC_batch_holdout {
    public static void main(String[] args) throws Exception {
        System.out.println("========= Step 1: Read the dataset ==========");
        String targetClassName = "play";
        String datasetPath = MainTestACAC_batch_holdout.fileToPath("tennisExtended.txt");
        StringDataset dataset = new StringDataset(datasetPath, targetClassName);
        dataset.printStats();
        System.out.println("==== Step 2: Training:  Apply the algorithm to build a model (a set of rules) ===");
        double minSup = 0.1;
        double minConf = 0.8;
        double minAllConf = 0.5;
        AlgoACAC algorithmACAC = new AlgoACAC(minSup, minConf, minAllConf);
        Evaluator experiment1 = new Evaluator();
        double percentage = 0.5;
        ClassificationAlgorithm[] algorithms = new ClassificationAlgorithm[]{algorithmACAC};
        OverallResults allResults = experiment1.trainAndRunClassifiersHoldout(algorithms, dataset, percentage);
        String forTrainingPath = "outputReportForTraining.txt";
        String onTrainingPath = "outputReportOnTraining.txt";
        String onTrestingPath = "outputReportOnTesting.txt";
        allResults.saveMetricsResultsToFile(forTrainingPath, onTrainingPath, onTrestingPath);
        allResults.printStats();
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestACAC_batch_holdout.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

