/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.input.sequence_database_array_integers;

import ca.pfv.spmf.input.sequence_database_array_integers.Sequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class SequenceDatabase {
    public int minItem = Integer.MAX_VALUE;
    public int maxItem = 0;
    public int tidsCount = 0;
    private final List<Sequence> sequences = new ArrayList<Sequence>();

    public void loadFile(String path) throws IOException {
        try (BufferedReader myInput = null;){
            try {
                String thisLine;
                FileInputStream fin = new FileInputStream(new File(path));
                myInput = new BufferedReader(new InputStreamReader(fin));
                while ((thisLine = myInput.readLine()) != null) {
                    if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                    this.addSequence(thisLine.split(" "));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
    }

    public void addSequence(String[] tokens) {
        Sequence sequence = new Sequence();
        ArrayList<Integer> itemset2 = new ArrayList<Integer>();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.codePointAt(0) != 60) {
                if (token.equals("-1")) {
                    sequence.addItemset(itemset2.toArray());
                    itemset2 = new ArrayList();
                } else if (token.equals("-2")) {
                    this.sequences.add(sequence);
                } else {
                    Integer item = Integer.parseInt(token);
                    if (item >= this.maxItem) {
                        this.maxItem = item;
                    }
                    if (item < this.minItem) {
                        this.minItem = item;
                    }
                    itemset2.add(item);
                }
            }
            ++n2;
        }
    }

    public void addSequence(Sequence sequence) {
        this.sequences.add(sequence);
    }

    public void print() {
        System.out.println("============  CONTEXTE ==========");
        int i = 0;
        while (i < this.sequences.size()) {
            System.out.print(String.valueOf(i) + ":  ");
            this.sequences.get(i).print();
            System.out.println("");
            ++i;
        }
    }

    public void printDatabaseStats() {
        System.out.println("============  STATS ==========");
        System.out.println("Number of sequences : " + this.sequences.size());
        System.out.println("Min item:" + this.minItem);
        System.out.println("Max item:" + this.maxItem);
        long size = 0L;
        for (Sequence sequence : this.sequences) {
            size += (long)sequence.size();
        }
        double meansize = (float)size / (float)this.sequences.size();
        System.out.println("mean size" + meansize);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        int i = 0;
        while (i < this.sequences.size()) {
            r.append(i);
            r.append(":  ");
            r.append(this.sequences.get(i).toString());
            r.append('\n');
            ++i;
        }
        return r.toString();
    }

    public int size() {
        return this.sequences.size();
    }

    public List<Sequence> getSequences() {
        return this.sequences;
    }
}

