/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.gui.experiments;

import ca.pfv.spmf.algorithmmanager.AlgorithmManager;
import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.experiments.oneparametervaried.ExperimenterForParameterChange;
import ca.pfv.spmf.gui.NotifyingThread;
import ca.pfv.spmf.gui.PreferencesManager;
import ca.pfv.spmf.gui.ThreadCompleteListener;
import ca.pfv.spmf.test.MainTestApriori_saveToFile;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ExperimenterWindow
extends JFrame
implements ThreadCompleteListener,
Thread.UncaughtExceptionHandler {
    private static final long serialVersionUID = 2151286070078740128L;
    private JTextField textFieldParameters;
    private JTextField textFieldTimeLimit;
    private JTextField textFieldValues;
    private JTextField textFieldAlgorithms;
    private JTextArea textAreaResult;
    private static NotifyingThread currentRunningAlgorithmThread = null;
    private JButton buttonRun;
    private String inputFile = "";
    private String outputDirectory = "";
    private String pathToSPMFJar = null;
    private JTextField textFieldInputFile;
    private JTextField textFieldOutputDirectory;
    private JTextField textFieldJARPath;
    private JComboBox comboBoxAlgorithms;
    JButton buttonAddAlgorithm;
    JCheckBox checkboxCountLines;
    JCheckBox checkboxPGFPlots;
    private int timeoutMilliseconds;
    JButton buttonHelp;

    public static void main(String[] arg) throws IOException {
        System.out.println("replace%".replaceAll("[%]", "\\%"));
        ExperimenterWindow experimenter = new ExperimenterWindow();
        experimenter.setVisible(true);
        experimenter.setDefaultCloseOperation(3);
    }

    public ExperimenterWindow() {
        this.setTitle("Run an experiment (one parameter is varied)");
        this.setBounds(100, 100, 825, 801);
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        JLabel lblNewLabel = new JLabel("Step 2: Select an input file:");
        lblNewLabel.setBounds(10, 123, 193, 14);
        this.getContentPane().add(lblNewLabel);
        this.textFieldParameters = new JTextField();
        this.textFieldParameters.setText("##");
        this.textFieldParameters.setBounds(34, 233, 757, 20);
        this.getContentPane().add(this.textFieldParameters);
        this.textFieldParameters.setColumns(10);
        JLabel lblNewLabel_1 = new JLabel("Step 1: Select algorithm(s) to be compared (Note: must have the same parameters):");
        lblNewLabel_1.setBounds(10, 15, 570, 14);
        this.getContentPane().add(lblNewLabel_1);
        JLabel lblNewLabel_2 = new JLabel("Step 5: Provide a list of values for the parameter to be varied (separated by a space):");
        lblNewLabel_2.setBounds(10, 278, 781, 14);
        this.getContentPane().add(lblNewLabel_2);
        JLabel lblNewLabel_3 = new JLabel("Time limit for each run (s): ");
        lblNewLabel_3.setBounds(34, 375, 169, 14);
        this.getContentPane().add(lblNewLabel_3);
        this.textFieldTimeLimit = new JTextField();
        this.textFieldTimeLimit.setBounds(213, 372, 496, 20);
        this.getContentPane().add(this.textFieldTimeLimit);
        this.textFieldTimeLimit.setColumns(10);
        this.textFieldValues = new JTextField();
        this.textFieldValues.setText("0.5 0.4 0.3 0.2 0.1");
        this.textFieldValues.setBounds(34, 299, 757, 20);
        this.getContentPane().add(this.textFieldValues);
        this.textFieldValues.setColumns(10);
        this.buttonRun = new JButton("Run the experiment");
        this.buttonRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExperimenterWindow.this.runExperiment();
            }
        });
        this.buttonRun.setBounds(270, 475, 230, 23);
        this.getContentPane().add(this.buttonRun);
        this.textFieldAlgorithms = new JTextField();
        this.textFieldAlgorithms.setBounds(34, 73, 757, 20);
        this.getContentPane().add(this.textFieldAlgorithms);
        this.textFieldAlgorithms.setColumns(10);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(34, 509, 757, 242);
        this.getContentPane().add(scrollPane);
        this.textAreaResult = new JTextArea();
        this.textAreaResult.setText(" ");
        this.textAreaResult.setEditable(false);
        scrollPane.setViewportView(this.textAreaResult);
        JLabel lblNewLabel_5 = new JLabel("Results:");
        lblNewLabel_5.setBounds(10, 484, 414, 14);
        this.getContentPane().add(lblNewLabel_5);
        this.textFieldInputFile = new JTextField();
        this.textFieldInputFile.setEditable(false);
        this.textFieldInputFile.setBounds(213, 120, 496, 20);
        this.getContentPane().add(this.textFieldInputFile);
        this.textFieldInputFile.setColumns(10);
        JButton buttonInputFile = new JButton("...");
        buttonInputFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExperimenterWindow.this.askUserToChooseInputFile();
            }
        });
        buttonInputFile.setBounds(719, 119, 72, 23);
        this.getContentPane().add(buttonInputFile);
        JLabel lblNewLabel_6 = new JLabel("Step 4: Provide the algorithm(s) parameter values, using ## to represent the value that will be varied:");
        lblNewLabel_6.setBounds(10, 208, 781, 14);
        this.getContentPane().add(lblNewLabel_6);
        this.textFieldOutputDirectory = new JTextField();
        this.textFieldOutputDirectory.setEditable(false);
        this.textFieldOutputDirectory.setBounds(213, 160, 496, 20);
        this.getContentPane().add(this.textFieldOutputDirectory);
        this.textFieldOutputDirectory.setColumns(10);
        JLabel lblNewLabel_7 = new JLabel("Step 3: Select output directory:");
        lblNewLabel_7.setBounds(10, 166, 193, 14);
        this.getContentPane().add(lblNewLabel_7);
        JButton btnNewButton = new JButton("...");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExperimenterWindow.this.askUserToChooseOutputDirectory();
            }
        });
        btnNewButton.setBounds(719, 161, 72, 23);
        this.getContentPane().add(btnNewButton);
        JLabel lblNewLabel_8 = new JLabel("Options:");
        lblNewLabel_8.setBounds(10, 350, 781, 14);
        this.getContentPane().add(lblNewLabel_8);
        JLabel lblNewLabel_9 = new JLabel("Path to SPMF.jar (optional):");
        lblNewLabel_9.setBounds(34, 399, 169, 14);
        this.getContentPane().add(lblNewLabel_9);
        this.textFieldJARPath = new JTextField();
        this.pathToSPMFJar = PreferencesManager.getInstance().getSPMFJarFilePath();
        this.textFieldJARPath.setText(this.pathToSPMFJar);
        this.textFieldJARPath.setEditable(false);
        this.textFieldJARPath.setBounds(213, 396, 496, 20);
        this.getContentPane().add(this.textFieldJARPath);
        this.textFieldJARPath.setColumns(10);
        JButton buttonSPMFJar = new JButton("...");
        buttonSPMFJar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExperimenterWindow.this.askUserToChooseSPMFJarPath();
            }
        });
        buttonSPMFJar.setBounds(719, 395, 72, 23);
        this.getContentPane().add(buttonSPMFJar);
        this.comboBoxAlgorithms = new JComboBox(new Vector());
        this.comboBoxAlgorithms.setBounds(34, 40, 283, 22);
        this.comboBoxAlgorithms.setMaximumRowCount(20);
        this.comboBoxAlgorithms.addItem("");
        AlgorithmManager manager = null;
        try {
            manager = AlgorithmManager.getInstance();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        List<String> algorithmList = manager.getListOfAlgorithmsAsString(false, true);
        for (String algorithmOrCategoryName : algorithmList) {
            this.comboBoxAlgorithms.addItem(algorithmOrCategoryName);
        }
        this.comboBoxAlgorithms.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                try {
                    ExperimenterWindow.this.updateUserInterfaceAfterAlgorithmSelection(evt.getItem().toString(), evt.getStateChange() == 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.getContentPane().add(this.comboBoxAlgorithms);
        this.buttonAddAlgorithm = new JButton("Add algorithm");
        this.buttonAddAlgorithm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExperimenterWindow.this.addAnAlgorithm();
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(null, "An error occurred ERROR MESSAGE = " + e.toString(), "Error", 0);
                }
            }
        });
        this.buttonAddAlgorithm.setBounds(327, 40, 176, 23);
        this.buttonAddAlgorithm.setEnabled(false);
        this.getContentPane().add(this.buttonAddAlgorithm);
        this.checkboxCountLines = new JCheckBox("Compare the number of lines in the output of each algorithm");
        this.checkboxCountLines.setBounds(34, 420, 578, 23);
        this.getContentPane().add(this.checkboxCountLines);
        this.buttonHelp = new JButton("");
        this.buttonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(URI.create("https://www.philippe-fournier-viger.com/spmf/ExperimenterPerformance.php"));
                }
                catch (IOException exception) {
                    System.out.println(exception.getMessage());
                }
            }
        });
        this.buttonHelp.setIcon(new ImageIcon(ExperimenterWindow.class.getResource("/ca/pfv/spmf/gui/Help24.gif")));
        this.buttonHelp.setBounds(761, 11, 38, 34);
        this.getContentPane().add(this.buttonHelp);
        this.checkboxPGFPlots = new JCheckBox("Save results as Latex PGFPlots figures");
        this.checkboxPGFPlots.setBounds(34, 446, 466, 23);
        this.getContentPane().add(this.checkboxPGFPlots);
    }

    protected void addAnAlgorithm() throws Exception {
        String algorithms = this.textFieldAlgorithms.getText();
        String newAlgorithm = (String)this.comboBoxAlgorithms.getSelectedItem();
        if (algorithms == null || "".equals(algorithms)) {
            this.textFieldAlgorithms.setText(newAlgorithm);
        } else {
            String[] algorithmNames = algorithms.split(" ");
            boolean alreadyThere = false;
            String[] stringArray = algorithmNames;
            int n = algorithmNames.length;
            int n2 = 0;
            while (n2 < n) {
                String algorithm = stringArray[n2];
                if (algorithm.equals(newAlgorithm)) {
                    alreadyThere = true;
                }
                ++n2;
            }
            DescriptionOfAlgorithm descriptionOfAlgorithm = AlgorithmManager.getInstance().getDescriptionOfAlgorithm(algorithmNames[0]);
            DescriptionOfParameter[] description = descriptionOfAlgorithm.getParametersDescription();
            DescriptionOfAlgorithm newDescriptionOfAlgorithm = AlgorithmManager.getInstance().getDescriptionOfAlgorithm(newAlgorithm);
            DescriptionOfParameter[] newDescription = newDescriptionOfAlgorithm.getParametersDescription();
            boolean sameMandatoryParameters = true;
            if (descriptionOfAlgorithm.getNumberOfMandatoryParameters() != newDescriptionOfAlgorithm.getNumberOfMandatoryParameters()) {
                sameMandatoryParameters = false;
            } else {
                int i = 0;
                while (i < description.length) {
                    DescriptionOfParameter parameter = description[i];
                    if (!parameter.isOptional) {
                        if (i < newDescription.length) {
                            DescriptionOfParameter newParameter = newDescription[i];
                            if (parameter.parameterType != newParameter.parameterType || !parameter.name.equals(newParameter.name)) {
                                sameMandatoryParameters = false;
                            }
                        } else {
                            sameMandatoryParameters = false;
                        }
                    }
                    ++i;
                }
            }
            if (!sameMandatoryParameters) {
                JOptionPane.showMessageDialog(null, "This algorithm (" + newAlgorithm + ") does not have the same mandatory parameters has other algorithms in this list (e.g. " + algorithmNames[0] + "). Hence, it cannot be added.", "Error", 0);
            }
            if (!alreadyThere && sameMandatoryParameters) {
                this.textFieldAlgorithms.setText(String.valueOf(algorithms) + " " + newAlgorithm);
            }
        }
    }

    protected void runExperiment() {
        this.buttonRun.setEnabled(false);
        this.textAreaResult.setText("");
        try {
            String spaceSeparatedAlgorithmNames;
            final ExperimenterForParameterChange experimenter = new ExperimenterForParameterChange();
            if (this.pathToSPMFJar != null) {
                System.out.println(this.pathToSPMFJar);
                experimenter.setSPMFJarFilePath(this.pathToSPMFJar);
            }
            if ((spaceSeparatedAlgorithmNames = this.textFieldAlgorithms.getText()) == null || "".equals(spaceSeparatedAlgorithmNames)) {
                throw new Exception("You must enter some algorithm names.");
            }
            final String[] algorithmNames = spaceSeparatedAlgorithmNames.split(" ");
            if ("".equals(this.inputFile)) {
                throw new Exception("You must select an input file.");
            }
            if ("".equals(this.outputDirectory)) {
                throw new Exception("You must select an output diretory.");
            }
            String spaceSeparatedParameters = this.textFieldParameters.getText();
            if (spaceSeparatedParameters == null || "".equals(spaceSeparatedParameters)) {
                throw new Exception("You must provide a list of parameters.");
            }
            final String[] parameters = spaceSeparatedParameters.split(" ");
            int positionParameter = -1;
            int i = 0;
            while (i < parameters.length) {
                if ("##".equals(parameters[i])) {
                    positionParameter = i;
                }
                ++i;
            }
            if (positionParameter == -1) {
                throw new Exception("The parameter to be varied should be identified with the code ## ");
            }
            String spaceSeparatedVaryingValues = this.textFieldValues.getText();
            if (spaceSeparatedVaryingValues == null || "".equals(spaceSeparatedVaryingValues)) {
                throw new Exception("You must provide a list of values for the parameter that is varied.");
            }
            final String[] varyingValues = spaceSeparatedVaryingValues.split(" ");
            this.timeoutMilliseconds = Integer.MAX_VALUE;
            String timeoutAsString = this.textFieldTimeLimit.getText();
            if (!"".equals(timeoutAsString)) {
                try {
                    this.timeoutMilliseconds = Integer.parseInt(timeoutAsString) * 1000;
                }
                catch (NumberFormatException f) {
                    throw new Exception(" Timeout must be an integer number representing a maximum duration in milliseconds.");
                }
            }
            System.setOut(new PrintStream(new TextAreaOutputStream(this.textAreaResult)));
            final boolean compareOutputSize = this.checkboxCountLines.isSelected();
            final boolean generatePGFPLOTFigures = this.checkboxPGFPlots.isSelected();
            currentRunningAlgorithmThread = new NotifyingThread(){

                @Override
                public boolean doRun() throws Exception {
                    experimenter.runAnAlgorithmAndVaryParameter(algorithmNames, parameters, varyingValues, ExperimenterWindow.this.inputFile, ExperimenterWindow.this.outputDirectory, ExperimenterWindow.this.timeoutMilliseconds, compareOutputSize, false, generatePGFPLOTFigures, "parameter");
                    return true;
                }
            };
            currentRunningAlgorithmThread.addListener(this);
            currentRunningAlgorithmThread.setUncaughtExceptionHandler(this);
            currentRunningAlgorithmThread.start();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occured while trying to run the experiment. ERROR MESSAGE = " + e.toString(), "Error", 0);
            this.buttonRun.setEnabled(true);
        }
    }

    private void askUserToChooseInputFile() {
        try {
            URL main;
            String previousPath = PreferencesManager.getInstance().getInputFilePath();
            Object path = previousPath == null ? (!"file".equalsIgnoreCase((main = MainTestApriori_saveToFile.class.getResource("MainTestApriori_saveToFile.class")).getProtocol()) ? null : new File(main.getPath())) : new File(previousPath);
            JFileChooser fc = path != null ? new JFileChooser(((File)path).getAbsolutePath()) : new JFileChooser();
            int returnVal = fc.showSaveDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                this.textFieldInputFile.setText(file.getName());
                this.inputFile = file.getPath();
                if (fc.getSelectedFile() != null) {
                    PreferencesManager.getInstance().setInputFilePath(fc.getSelectedFile().getParent());
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occured while opening the input file dialog. ERROR MESSAGE = " + e.toString(), "Error", 0);
        }
    }

    protected void askUserToChooseSPMFJarPath() {
        try {
            URL main;
            String previousPath = PreferencesManager.getInstance().getSPMFJarFilePath();
            Object path = previousPath == null ? (!"file".equalsIgnoreCase((main = MainTestApriori_saveToFile.class.getResource("MainTestApriori_saveToFile.class")).getProtocol()) ? null : new File(main.getPath())) : new File(previousPath);
            JFileChooser fc = path != null ? new JFileChooser(((File)path).getAbsolutePath()) : new JFileChooser();
            int returnVal = fc.showSaveDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                this.textFieldJARPath.setText(file.getPath());
                this.pathToSPMFJar = file.getPath();
                if (fc.getSelectedFile() != null) {
                    PreferencesManager.getInstance().setSPMFJarFilePath(fc.getSelectedFile().getPath());
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occured while opening the SPMF.jar file path dialog. ERROR MESSAGE = " + e.toString(), "Error", 0);
        }
    }

    private void askUserToChooseOutputDirectory() {
        try {
            int returnVal;
            URL main;
            String previousPath = PreferencesManager.getInstance().getExperimentDirectoryPath();
            Object path = previousPath == null ? (!"file".equalsIgnoreCase((main = MainTestApriori_saveToFile.class.getResource("MainTestApriori_saveToFile.class")).getProtocol()) ? null : new File(main.getPath())) : new File(previousPath);
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            fc.setAcceptAllFileFilterUsed(false);
            if (path != null) {
                fc.setCurrentDirectory(new File(((File)path).getAbsolutePath()));
            }
            if ((returnVal = fc.showSaveDialog(this)) == 0) {
                File file = fc.getSelectedFile();
                this.textFieldOutputDirectory.setText(file.getName());
                this.outputDirectory = file.getAbsolutePath();
                if (fc.getSelectedFile() != null) {
                    PreferencesManager.getInstance().setExperimentDirectoryPath(fc.getSelectedFile().getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occured while opening the output file dialog. ERROR MESSAGE = " + e.toString(), "Error", 0);
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.buttonRun.setEnabled(true);
    }

    @Override
    public void notifyOfThreadComplete(Thread thread, boolean succeed) {
        this.buttonRun.setEnabled(true);
    }

    protected void updateUserInterfaceAfterAlgorithmSelection(String algorithmName, boolean isSelected) throws Exception {
        if (isSelected) {
            AlgorithmManager manager = AlgorithmManager.getInstance();
            DescriptionOfAlgorithm algorithm = manager.getDescriptionOfAlgorithm(algorithmName);
            if (algorithm != null) {
                this.buttonAddAlgorithm.setEnabled(true);
            } else {
                this.buttonAddAlgorithm.setEnabled(false);
            }
        } else {
            this.buttonAddAlgorithm.setEnabled(false);
        }
    }

    static class TextAreaOutputStream
    extends OutputStream {
        JTextArea textArea;

        public TextAreaOutputStream(JTextArea textArea) {
            this.textArea = textArea;
        }

        @Override
        public void flush() {
            this.textArea.repaint();
        }

        @Override
        public void write(int b) {
            this.textArea.append(new String(new byte[]{(byte)b}));
        }
    }
}

