/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.reader_writer;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class AlgoTimeSeriesWriter {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    boolean DEBUG_MODE = false;
    int timeSeriesCount = 0;
    BufferedWriter writer = null;

    public void runAlgorithm(String output, List<TimeSeries> multipleTimeSeries, String separator) throws IOException {
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        int j = 0;
        while (j < multipleTimeSeries.size()) {
            TimeSeries timeSeries = multipleTimeSeries.get(j);
            this.writer.write("@NAME=" + timeSeries.getName());
            this.writer.newLine();
            int i = 0;
            while (i < timeSeries.data.length) {
                double value = timeSeries.data[i];
                this.writer.write(Double.toString(value));
                if (i != timeSeries.data.length - 1) {
                    this.writer.write(separator);
                }
                ++i;
            }
            if (j != multipleTimeSeries.size() - 1) {
                this.writer.newLine();
            }
            ++j;
        }
        this.writer.close();
        this.timeSeriesCount = multipleTimeSeries.size();
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    public void printStats() {
        System.out.println("======= WRITE TIME SERIES TO FILE v2.06 - STATS =======");
        System.out.println(" Number of time series processed: " + this.timeSeriesCount);
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("=====================================================================");
    }
}

