/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.normalization;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.Arrays;

public class AlgoMinMaxNormalization {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    boolean DEBUG_MODE = false;

    public TimeSeries runAlgorithm(TimeSeries timeSeries) throws IOException {
        if (timeSeries.size() < 1) {
            throw new IllegalArgumentException(" The time series should contain at least 1 point.");
        }
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        if (this.DEBUG_MODE) {
            System.out.println(" Time series: " + Arrays.toString(timeSeries.data));
        }
        double[] resultTimeSeriesArray = this.calculateMinMaxNormalization(timeSeries.data);
        TimeSeries transformedTimeSeries = new TimeSeries(resultTimeSeriesArray, String.valueOf(timeSeries.getName()) + "_MMAX");
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return transformedTimeSeries;
    }

    private double[] calculateMinMaxNormalization(double[] timeSeries) {
        double[] result = new double[timeSeries.length];
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < timeSeries.length) {
            if (timeSeries[i] < min) {
                min = timeSeries[i];
            }
            if (timeSeries[i] > max) {
                max = timeSeries[i];
            }
            ++i;
        }
        double MaxMinusMin = max - min;
        int i2 = 0;
        while (i2 < timeSeries.length) {
            result[i2] = (timeSeries[i2] - min) / MaxMinusMin;
            ++i2;
        }
        if (this.DEBUG_MODE) {
            System.out.println(" Number of data points = " + timeSeries.length);
            System.out.println(" Min max normalization: " + Arrays.toString(result));
        }
        return result;
    }

    public void printStats() {
        System.out.println("=============  Min Max Normalization transformation v2.21- STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("===================================================");
    }
}

