/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.movingaverage;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.Arrays;

public class AlgoCumulativeMovingAverage {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    boolean DEBUG_MODE = false;

    public TimeSeries runAlgorithm(TimeSeries timeSeries) throws IOException {
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        if (this.DEBUG_MODE) {
            System.out.println(" Time series: " + Arrays.toString(timeSeries.data));
        }
        double[] movingAverageData = this.calculateCumulativeMovingAverage(timeSeries.data);
        TimeSeries movingAverage = new TimeSeries(movingAverageData, String.valueOf(timeSeries.getName()) + "_CUMAVG");
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return movingAverage;
    }

    private double[] calculateCumulativeMovingAverage(double[] timeSeries) {
        double[] movingAverage = new double[timeSeries.length];
        double sum = 0.0;
        int i = 0;
        while (i < timeSeries.length) {
            movingAverage[i] = (sum += timeSeries[i]) / (double)(i + 1);
            ++i;
        }
        if (this.DEBUG_MODE) {
            System.out.println(" Number of data points = " + timeSeries.length);
            System.out.println(" Cumulative Moving average transformation: " + Arrays.toString(movingAverage));
        }
        return movingAverage;
    }

    public void printStats() {
        System.out.println("=============  Transform to Cumulative Moving Average v2.05- STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("===================================================");
    }
}

