/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spam;

import ca.pfv.spmf.algorithms.sequentialpatterns.spam.Bitmap;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.PatternVGEN;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.PrefixVGEN;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoVGEN {
    public long startTime;
    public long endTime;
    public int patternCount;
    private int minsup = 0;
    BufferedWriter writer = null;
    Map<Integer, Bitmap> verticalDB = new HashMap<Integer, Bitmap>();
    List<Integer> sequencesSize = null;
    int lastBitIndex = 0;
    private int maximumPatternLength = 1000;
    Map<Integer, Map<Integer, Integer>> coocMapAfter = null;
    Map<Integer, Map<Integer, Integer>> coocMapEquals = null;
    boolean useCMAPPruning = true;
    List<Map<Integer, List<PatternVGEN>>> generatorPatterns = null;
    private boolean useImmediateBackwardChecking = true;
    private boolean useBackwardPruning = false;
    boolean DEBUG_MODE = false;
    int transactionCount = 0;
    private int maxGap = Integer.MAX_VALUE;
    private boolean outputSequenceIdentifiers;

    public List<Map<Integer, List<PatternVGEN>>> runAlgorithm(String input, String outputFilePath, double minsupRel) throws IOException {
        if (this.DEBUG_MODE) {
            System.out.println(" %%%%%%%%%%  DEBUG MODE %%%%%%%%%%");
        }
        Bitmap.INTERSECTION_COUNT = 0L;
        this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.startTime = System.currentTimeMillis();
        this.vgen(input, minsupRel);
        this.endTime = System.currentTimeMillis();
        this.writeResultTofile(outputFilePath);
        this.writer.close();
        if (this.DEBUG_MODE) {
            System.out.println("minsup absolute : " + this.minsup);
            ArrayList<PatternVGEN> listPatterns = new ArrayList<PatternVGEN>();
            for (Map<Integer, List<PatternVGEN>> mapSizeI : this.generatorPatterns) {
                if (mapSizeI == null) continue;
                for (List<PatternVGEN> listpattern : mapSizeI.values()) {
                    for (PatternVGEN pat : listpattern) {
                        listPatterns.add(pat);
                    }
                }
            }
            for (PatternVGEN pat1 : listPatterns) {
                if (pat1.prefix.size() > 0 && pat1.getAbsoluteSupport() == this.transactionCount) {
                    System.out.println("NOT A GENERATOR !!!!!!!!!  " + pat1.prefix + "    sup: " + pat1.bitmap.getSupport() + " because of empty set");
                }
                for (PatternVGEN pat2 : listPatterns) {
                    if (pat1 == pat2 || pat1.getAbsoluteSupport() != pat2.getAbsoluteSupport() || !this.strictlyContains(pat1.prefix, pat2.prefix)) continue;
                    System.out.println("NOT A GENERATOR !!!!!!!!!  " + pat1.prefix + " " + pat2.prefix + "   sup: " + pat1.bitmap.getSupport());
                    System.out.println(String.valueOf(pat1.bitmap.sidsum) + " " + pat2.bitmap.sidsum);
                }
            }
        }
        return this.generatorPatterns;
    }

    private void vgen(String input, double minsupRel) throws IOException {
        int item;
        int i;
        String thisLine;
        BufferedReader reader;
        FileInputStream fin;
        this.generatorPatterns = new ArrayList<Map<Integer, List<PatternVGEN>>>(20);
        this.generatorPatterns.add(new HashMap());
        this.generatorPatterns.add(new HashMap());
        this.verticalDB = new HashMap<Integer, Bitmap>();
        ArrayList<int[]> inMemoryDB = new ArrayList<int[]>();
        this.sequencesSize = new ArrayList<Integer>();
        this.lastBitIndex = 0;
        try {
            fin = new FileInputStream(new File(input));
            reader = new BufferedReader(new InputStreamReader(fin));
            int bitIndex = 0;
            while ((thisLine = reader.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                this.sequencesSize.add(bitIndex);
                String[] tokens = thisLine.split(" ");
                int[] transactionArray = new int[tokens.length];
                inMemoryDB.add(transactionArray);
                i = 0;
                while (i < tokens.length) {
                    transactionArray[i] = item = Integer.parseInt(tokens[i]);
                    if (item == -1) {
                        ++bitIndex;
                    }
                    ++i;
                }
            }
            this.lastBitIndex = bitIndex - 1;
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.minsup = (int)Math.ceil(minsupRel * (double)this.sequencesSize.size());
        if (this.minsup == 0) {
            this.minsup = 1;
        }
        this.transactionCount = 0;
        try {
            fin = new FileInputStream(new File(input));
            reader = new BufferedReader(new InputStreamReader(fin));
            int sid = 0;
            int tid = 0;
            while ((thisLine = reader.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] stringArray = thisLine.split(" ");
                item = stringArray.length;
                i = 0;
                while (i < item) {
                    String token = stringArray[i];
                    if (token.equals("-1")) {
                        ++tid;
                    } else if (token.equals("-2")) {
                        ++sid;
                        tid = 0;
                    } else {
                        Integer item2 = Integer.parseInt(token);
                        Bitmap bitmapItem = this.verticalDB.get(item2);
                        if (bitmapItem == null) {
                            bitmapItem = new Bitmap(this.lastBitIndex);
                            this.verticalDB.put(item2, bitmapItem);
                        }
                        bitmapItem.registerBit(sid, tid, this.sequencesSize);
                    }
                    ++i;
                }
                ++this.transactionCount;
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Integer> frequentItems = new ArrayList<Integer>();
        Iterator<Map.Entry<Integer, Bitmap>> iter = this.verticalDB.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, Bitmap> entry = iter.next();
            if (entry.getValue().getSupport() < this.minsup) {
                iter.remove();
                continue;
            }
            frequentItems.add(entry.getKey());
        }
        Collections.sort(frequentItems, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return AlgoVGEN.this.verticalDB.get(arg0).getSupport() - AlgoVGEN.this.verticalDB.get(arg1).getSupport();
            }
        });
        this.coocMapEquals = new HashMap<Integer, Map<Integer, Integer>>(frequentItems.size());
        this.coocMapAfter = new HashMap<Integer, Map<Integer, Integer>>(frequentItems.size());
        for (int[] transaction : inMemoryDB) {
            int itemsetCount = 0;
            HashSet<Integer> alreadyProcessed = new HashSet<Integer>();
            HashMap equalProcessed = new HashMap();
            int i2 = 0;
            while (i2 < transaction.length) {
                block45: {
                    Integer itemI = transaction[i2];
                    HashSet<Integer> equalSet = (HashSet<Integer>)equalProcessed.get(itemI);
                    if (equalSet == null) {
                        equalSet = new HashSet<Integer>();
                        equalProcessed.put(itemI, equalSet);
                    }
                    if (itemI < 0) {
                        itemsetCount = (short)(itemsetCount + 1);
                    } else {
                        Bitmap bitmapOfItem = this.verticalDB.get(itemI);
                        if (bitmapOfItem != null && bitmapOfItem.getSupport() >= this.minsup) {
                            HashSet<Integer> alreadyProcessedB = new HashSet<Integer>();
                            boolean sameItemset = true;
                            int j = i2 + 1;
                            while (j < transaction.length) {
                                Integer itemJ = transaction[j];
                                if (itemJ < 0) {
                                    sameItemset = false;
                                } else {
                                    Bitmap bitmapOfitemJ = this.verticalDB.get(itemJ);
                                    if (bitmapOfitemJ != null && bitmapOfitemJ.getSupport() >= this.minsup) {
                                        Integer support;
                                        Map<Integer, Integer> map = null;
                                        if (sameItemset) {
                                            if (!equalSet.contains(itemJ)) {
                                                map = this.coocMapEquals.get(itemI);
                                                if (map == null) {
                                                    map = new HashMap<Integer, Integer>();
                                                    this.coocMapEquals.put(itemI, map);
                                                }
                                                if ((support = map.get(itemJ)) == null) {
                                                    map.put(itemJ, 1);
                                                } else {
                                                    support = support + 1;
                                                    map.put(itemJ, support);
                                                }
                                                equalSet.add(itemJ);
                                            }
                                        } else if (!alreadyProcessedB.contains(itemJ)) {
                                            if (alreadyProcessed.contains(itemI)) break block45;
                                            map = this.coocMapAfter.get(itemI);
                                            if (map == null) {
                                                map = new HashMap<Integer, Integer>();
                                                this.coocMapAfter.put(itemI, map);
                                            }
                                            if ((support = map.get(itemJ)) == null) {
                                                map.put(itemJ, 1);
                                            } else {
                                                support = support + 1;
                                                map.put(itemJ, support);
                                            }
                                            alreadyProcessedB.add(itemJ);
                                        }
                                    }
                                }
                                ++j;
                            }
                            alreadyProcessed.add(itemI);
                        }
                    }
                }
                ++i2;
            }
        }
        if (this.DEBUG_MODE) {
            System.out.println("transaction count = " + this.transactionCount);
        }
        ArrayList<PatternVGEN> prefixSingleItems = new ArrayList<PatternVGEN>(this.verticalDB.entrySet().size());
        for (Map.Entry<Integer, Bitmap> entry : this.verticalDB.entrySet()) {
            boolean itemIsEven;
            PrefixVGEN prefix = new PrefixVGEN();
            prefix.addItemset(new Itemset(entry.getKey()));
            boolean bl = itemIsEven = entry.getKey() % 2 == 0;
            if (itemIsEven) {
                prefix.sumOfEvenItems = entry.getKey();
                prefix.sumOfOddItems = 0;
            } else {
                prefix.sumOfEvenItems = 0;
                prefix.sumOfOddItems = entry.getKey();
            }
            PatternVGEN pattern = new PatternVGEN(prefix, entry.getValue());
            prefixSingleItems.add(pattern);
            if (this.transactionCount == entry.getValue().getSupport()) continue;
            List<PatternVGEN> listPatterns = this.generatorPatterns.get(1).get(pattern.bitmap.sidsum);
            if (listPatterns == null) {
                listPatterns = new ArrayList<PatternVGEN>();
                this.generatorPatterns.get(1).put(pattern.bitmap.sidsum, listPatterns);
            }
            listPatterns.add(pattern);
            ++this.patternCount;
        }
        for (PatternVGEN pattern : prefixSingleItems) {
            int item3 = pattern.prefix.get(0).get(0);
            if (this.maximumPatternLength <= 1) continue;
            this.dfsPruning(pattern.prefix, pattern.bitmap, frequentItems, frequentItems, item3, 2, item3);
        }
        Bitmap bitmap = new Bitmap(0);
        bitmap.setSupport(this.transactionCount);
        PatternVGEN pat = new PatternVGEN(new PrefixVGEN(), bitmap);
        ArrayList<PatternVGEN> listLevel0 = new ArrayList<PatternVGEN>();
        listLevel0.add(pat);
        this.generatorPatterns.get(0).put(0, listLevel0);
        ++this.patternCount;
    }

    void dfsPruning(PrefixVGEN prefix, Bitmap prefixBitmap, List<Integer> sn, List<Integer> in, int hasToBeGreaterThanForIStep, int m, Integer lastAppendedItem) throws IOException {
        ArrayList<Integer> sTemp = new ArrayList<Integer>();
        ArrayList<Bitmap> sTempBitmaps = new ArrayList<Bitmap>();
        Map<Integer, Integer> mapSupportItemsAfter = this.coocMapAfter.get(lastAppendedItem);
        for (Integer i : sn) {
            Integer support;
            if (this.useCMAPPruning && (mapSupportItemsAfter == null || (support = mapSupportItemsAfter.get(i)) == null || support < this.minsup)) continue;
            ++Bitmap.INTERSECTION_COUNT;
            Bitmap newBitmap = prefixBitmap.createNewBitmapSStep(this.verticalDB.get(i), this.sequencesSize, this.lastBitIndex, this.maxGap);
            if (newBitmap.getSupportWithoutGapTotal() < this.minsup) continue;
            sTemp.add(i);
            sTempBitmaps.add(newBitmap);
        }
        int k = 0;
        while (k < sTemp.size()) {
            int item = (Integer)sTemp.get(k);
            PrefixVGEN prefixSStep = prefix.cloneSequence();
            prefixSStep.addItemset(new Itemset(item));
            if (item % 2 == 0) {
                prefixSStep.sumOfEvenItems = item + prefix.sumOfEvenItems;
                prefixSStep.sumOfOddItems = prefix.sumOfOddItems;
            } else {
                prefixSStep.sumOfEvenItems = prefix.sumOfEvenItems;
                prefixSStep.sumOfOddItems = item + prefix.sumOfOddItems;
            }
            Bitmap newBitmap = (Bitmap)sTempBitmaps.get(k);
            if (newBitmap.getSupport() >= this.minsup) {
                boolean hasBackWardExtension;
                boolean hasNoImmediateBackwardExtension;
                boolean bl = hasNoImmediateBackwardExtension = this.useImmediateBackwardChecking || prefixBitmap.getSupport() != newBitmap.getSupport();
                if (this.maximumPatternLength > m && hasNoImmediateBackwardExtension && !(hasBackWardExtension = this.savePatternMultipleItems(prefixSStep, newBitmap, m))) {
                    this.dfsPruning(prefixSStep, newBitmap, sTemp, sTemp, item, m + 1, item);
                }
            }
            ++k;
        }
        Map<Integer, Integer> mapSupportItemsEquals = this.coocMapEquals.get(lastAppendedItem);
        ArrayList<Integer> iTemp = new ArrayList<Integer>();
        ArrayList<Bitmap> iTempBitmaps = new ArrayList<Bitmap>();
        for (Integer i : in) {
            Integer support;
            if (i <= hasToBeGreaterThanForIStep || this.useCMAPPruning && (mapSupportItemsEquals == null || (support = mapSupportItemsEquals.get(i)) == null || support < this.minsup)) continue;
            ++Bitmap.INTERSECTION_COUNT;
            Bitmap newBitmap = prefixBitmap.createNewBitmapIStep(this.verticalDB.get(i), this.sequencesSize, this.lastBitIndex);
            if (newBitmap.getSupport() < this.minsup) continue;
            iTemp.add(i);
            iTempBitmaps.add(newBitmap);
        }
        int k2 = 0;
        while (k2 < iTemp.size()) {
            boolean hasBackWardExtension;
            boolean hasNoImmediateBackwardExtension;
            int item = (Integer)iTemp.get(k2);
            PrefixVGEN prefixIStep = prefix.cloneSequence();
            ((Itemset)prefixIStep.getItemsets().get(prefixIStep.size() - 1)).addItem(item);
            if (item % 2 == 0) {
                prefixIStep.sumOfEvenItems = item + prefix.sumOfEvenItems;
                prefixIStep.sumOfOddItems = prefix.sumOfOddItems;
            } else {
                prefixIStep.sumOfEvenItems = prefix.sumOfEvenItems;
                prefixIStep.sumOfOddItems = item + prefix.sumOfOddItems;
            }
            Bitmap newBitmap = (Bitmap)iTempBitmaps.get(k2);
            boolean bl = hasNoImmediateBackwardExtension = this.useImmediateBackwardChecking || prefixBitmap.getSupport() == newBitmap.getSupport();
            if (this.maximumPatternLength > m && hasNoImmediateBackwardExtension && !(hasBackWardExtension = this.savePatternMultipleItems(prefixIStep, newBitmap, m))) {
                this.dfsPruning(prefixIStep, newBitmap, sTemp, iTemp, item, m + 1, item);
            }
            ++k2;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private boolean savePatternMultipleItems(PrefixVGEN prefix, Bitmap bitmap, int length) throws IOException {
        List<PatternVGEN> level;
        int sidsum = bitmap.sidsum;
        if (bitmap.getSupport() == this.transactionCount) {
            return false;
        }
        boolean mayBeAGenerator = true;
        int i = 1;
        while (i < length && i < this.generatorPatterns.size()) {
            level = this.generatorPatterns.get(i).get(sidsum);
            if (level != null) {
                for (PatternVGEN pPrime : level) {
                    if (prefix.sumOfEvenItems < pPrime.prefix.sumOfEvenItems || prefix.sumOfOddItems < pPrime.prefix.sumOfOddItems || bitmap.getSupport() != pPrime.getAbsoluteSupport() || !this.strictlyContains(prefix, pPrime.prefix)) continue;
                    if (this.useBackwardPruning) {
                        if (this.isThereBackwardExtension(bitmap, pPrime.bitmap)) {
                            return true;
                        }
                        mayBeAGenerator = false;
                        continue;
                    }
                    return false;
                }
            }
            ++i;
        }
        if (!mayBeAGenerator) {
            return false;
        }
        i = this.generatorPatterns.size() - 1;
        while (i > length) {
            level = this.generatorPatterns.get(i).get(sidsum);
            if (level != null) {
                Iterator<PatternVGEN> iter = level.iterator();
                while (iter.hasNext()) {
                    PatternVGEN pPrime = iter.next();
                    if (prefix.sumOfEvenItems > pPrime.prefix.sumOfEvenItems || prefix.sumOfOddItems > pPrime.prefix.sumOfOddItems || bitmap.getSupport() != pPrime.getAbsoluteSupport() || !this.strictlyContains(pPrime.prefix, prefix)) continue;
                    --this.patternCount;
                    iter.remove();
                }
            }
            --i;
        }
        while (this.generatorPatterns.size() - 1 < length) {
            this.generatorPatterns.add(new HashMap());
        }
        List<PatternVGEN> listPatterns = this.generatorPatterns.get(length).get(sidsum);
        if (listPatterns == null) {
            listPatterns = new ArrayList<PatternVGEN>();
            this.generatorPatterns.get(length).put(sidsum, listPatterns);
        }
        ++this.patternCount;
        listPatterns.add(new PatternVGEN(prefix, bitmap));
        return false;
    }

    private boolean isThereBackwardExtension(Bitmap bitmap1, Bitmap bitmap2) {
        BitSet bitset1 = bitmap1.bitmap;
        BitSet bitset2 = bitmap2.bitmap;
        int currentBit1 = bitset1.nextSetBit(0);
        int currentBit2 = bitset2.nextSetBit(0);
        do {
            if (currentBit1 > currentBit2) {
                return false;
            }
            currentBit1 = bitset1.nextSetBit(currentBit1 + 1);
            currentBit2 = bitset2.nextSetBit(currentBit2 + 1);
        } while (currentBit1 > 0);
        return true;
    }

    boolean strictlyContains(PrefixVGEN pattern1, PrefixVGEN pattern2) {
        int i = 0;
        int j = 0;
        do {
            if (pattern1.get(j).containsAll(pattern2.get(i)) && ++i == pattern2.size()) {
                return true;
            }
            if (++j < pattern1.size()) continue;
            return false;
        } while (pattern1.size() - j >= pattern2.size() - i);
        return false;
    }

    public void printStatistics() {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  VGEN v0.97- STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : " + this.patternCount);
        r.append('\n');
        r.append(" Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append(this.patternCount);
        r.append('\n');
        r.append("minsup " + this.minsup);
        r.append('\n');
        r.append("Intersection count " + Bitmap.INTERSECTION_COUNT + " \n");
        r.append("===================================================\n");
        System.out.println(r.toString());
    }

    public int getMaximumPatternLength() {
        return this.maximumPatternLength;
    }

    public void setMaximumPatternLength(int maximumPatternLength) {
        this.maximumPatternLength = maximumPatternLength;
    }

    public void writeResultTofile(String path) throws IOException {
        for (Map<Integer, List<PatternVGEN>> level : this.generatorPatterns) {
            for (List<PatternVGEN> patterns : level.values()) {
                for (PatternVGEN pattern : patterns) {
                    StringBuilder r = new StringBuilder("");
                    for (Itemset itemset2 : pattern.prefix.getItemsets()) {
                        for (Integer item : itemset2.getItems()) {
                            String string = item.toString();
                            r.append(string);
                            r.append(' ');
                        }
                        r.append("-1 ");
                    }
                    r.append("#SUP: ");
                    r.append(pattern.getAbsoluteSupport());
                    if (this.outputSequenceIdentifiers) {
                        r.append(" #SID: ");
                        r.append(pattern.bitmap.getSIDs(this.sequencesSize));
                    }
                    this.writer.write(r.toString());
                    this.writer.newLine();
                }
            }
        }
    }

    public void setMaxGap(int maxGap) {
        this.maxGap = maxGap;
    }

    public void showSequenceIdentifiersInOutput(boolean showSequenceIdentifiers) {
        this.outputSequenceIdentifiers = showSequenceIdentifiers;
    }
}

