/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spam;

import ca.pfv.spmf.algorithms.sequentialpatterns.spam.Bitmap;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.Prefix;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoCMSPAM {
    private long startTime;
    private long endTime;
    public int patternCount;
    private int minsup = 0;
    BufferedWriter writer = null;
    Map<Integer, Bitmap> verticalDB = new HashMap<Integer, Bitmap>();
    List<Integer> sequencesSize = null;
    int lastBitIndex = 0;
    private int minimumPatternLength = 0;
    private int maximumPatternLength = 1000;
    int[] mustAppearItems;
    Map<Integer, Map<Integer, Integer>> coocMapAfter = null;
    Map<Integer, Map<Integer, Integer>> coocMapEquals = null;
    Map<Integer, Short> lastItemPositionMap;
    boolean useCMAPPruning = true;
    boolean useLastPositionPruning = false;
    private int maxGap = Integer.MAX_VALUE;
    boolean outputSequenceIdentifiers;

    public void runAlgorithm(String input, String outputFilePath, double minsupRel, boolean outputSequenceIdentifiers) throws IOException {
        this.outputSequenceIdentifiers = outputSequenceIdentifiers;
        Bitmap.INTERSECTION_COUNT = 0L;
        this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.startTime = System.currentTimeMillis();
        this.spam(input, minsupRel);
        this.endTime = System.currentTimeMillis();
        this.writer.close();
    }

    private void spam(String input, double minsupRel) throws IOException {
        int i;
        int containsAMustAppearItem;
        BufferedReader reader;
        FileInputStream fin;
        this.verticalDB = new HashMap<Integer, Bitmap>();
        ArrayList<int[]> inMemoryDB = new ArrayList<int[]>();
        this.sequencesSize = new ArrayList<Integer>();
        this.lastBitIndex = 0;
        try {
            String string;
            fin = new FileInputStream(new File(input));
            reader = new BufferedReader(new InputStreamReader(fin));
            int bitIndex = 0;
            while ((string = reader.readLine()) != null) {
                if (string.isEmpty() || string.charAt(0) == '#' || string.charAt(0) == '%' || string.charAt(0) == '@') continue;
                this.sequencesSize.add(bitIndex);
                String[] tokens = string.split(" ");
                int[] transactionArray = new int[tokens.length];
                containsAMustAppearItem = 0;
                i = 0;
                while (i < tokens.length) {
                    int item;
                    transactionArray[i] = item = Integer.parseInt(tokens[i]);
                    if (item == -1) {
                        ++bitIndex;
                    }
                    if (this.itemMustAppearInPatterns(item)) {
                        containsAMustAppearItem = 1;
                    }
                    ++i;
                }
                if (containsAMustAppearItem == 0) continue;
                inMemoryDB.add(transactionArray);
            }
            this.lastBitIndex = bitIndex - 1;
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.minsup = (int)Math.ceil(minsupRel * (double)this.sequencesSize.size());
        if (this.minsup == 0) {
            this.minsup = 1;
        }
        try {
            String string;
            fin = new FileInputStream(new File(input));
            reader = new BufferedReader(new InputStreamReader(fin));
            int sid = 0;
            int tid = 0;
            while ((string = reader.readLine()) != null) {
                if (string.isEmpty() || string.charAt(0) == '#' || string.charAt(0) == '%' || string.charAt(0) == '@') continue;
                String[] item = string.split(" ");
                i = item.length;
                containsAMustAppearItem = 0;
                while (containsAMustAppearItem < i) {
                    String token = item[containsAMustAppearItem];
                    if (token.equals("-1")) {
                        ++tid;
                    } else if (token.equals("-2")) {
                        ++sid;
                        tid = 0;
                    } else {
                        Integer item2 = Integer.parseInt(token);
                        Bitmap bitmapItem = this.verticalDB.get(item2);
                        if (bitmapItem == null) {
                            bitmapItem = new Bitmap(this.lastBitIndex);
                            this.verticalDB.put(item2, bitmapItem);
                        }
                        bitmapItem.registerBit(sid, tid, this.sequencesSize);
                    }
                    ++containsAMustAppearItem;
                }
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Integer> frequentItems = new ArrayList<Integer>();
        Iterator<Map.Entry<Integer, Bitmap>> iter = this.verticalDB.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, Bitmap> entry = iter.next();
            if (entry.getValue().getSupport() < this.minsup) {
                iter.remove();
                continue;
            }
            if (this.minimumPatternLength <= 1 && this.maximumPatternLength >= 1) {
                this.savePattern(entry.getKey(), entry.getValue());
            }
            frequentItems.add(entry.getKey());
        }
        if (this.maximumPatternLength <= 1) {
            return;
        }
        this.coocMapEquals = new HashMap<Integer, Map<Integer, Integer>>(frequentItems.size());
        this.coocMapAfter = new HashMap<Integer, Map<Integer, Integer>>(frequentItems.size());
        if (this.useLastPositionPruning) {
            this.lastItemPositionMap = new HashMap<Integer, Short>(frequentItems.size());
        }
        for (int[] nArray : inMemoryDB) {
            short itemsetCount = 0;
            HashSet<Integer> alreadyProcessed = new HashSet<Integer>();
            HashMap equalProcessed = new HashMap();
            i = 0;
            while (i < nArray.length) {
                block45: {
                    Integer itemI = nArray[i];
                    HashSet<Integer> equalSet = (HashSet<Integer>)equalProcessed.get(itemI);
                    if (equalSet == null) {
                        equalSet = new HashSet<Integer>();
                        equalProcessed.put(itemI, equalSet);
                    }
                    if (itemI < 0) {
                        itemsetCount = (short)(itemsetCount + 1);
                    } else {
                        Bitmap bitmapOfItem;
                        Short last;
                        if (this.useLastPositionPruning && ((last = this.lastItemPositionMap.get(itemI)) == null || last < itemsetCount)) {
                            this.lastItemPositionMap.put(itemI, itemsetCount);
                        }
                        if ((bitmapOfItem = this.verticalDB.get(itemI)) != null && bitmapOfItem.getSupport() >= this.minsup) {
                            HashSet<Integer> alreadyProcessedB = new HashSet<Integer>();
                            boolean sameItemset = true;
                            int j = i + 1;
                            while (j < nArray.length) {
                                Integer itemJ = nArray[j];
                                if (itemJ < 0) {
                                    sameItemset = false;
                                } else {
                                    Bitmap bitmapOfitemJ = this.verticalDB.get(itemJ);
                                    if (bitmapOfitemJ != null && bitmapOfitemJ.getSupport() >= this.minsup) {
                                        Integer support;
                                        Map<Integer, Integer> map = null;
                                        if (sameItemset) {
                                            if (!equalSet.contains(itemJ)) {
                                                map = this.coocMapEquals.get(itemI);
                                                if (map == null) {
                                                    map = new HashMap<Integer, Integer>();
                                                    this.coocMapEquals.put(itemI, map);
                                                }
                                                if ((support = map.get(itemJ)) == null) {
                                                    map.put(itemJ, 1);
                                                } else {
                                                    support = support + 1;
                                                    map.put(itemJ, support);
                                                }
                                                equalSet.add(itemJ);
                                            }
                                        } else if (!alreadyProcessedB.contains(itemJ)) {
                                            if (alreadyProcessed.contains(itemI)) break block45;
                                            map = this.coocMapAfter.get(itemI);
                                            if (map == null) {
                                                map = new HashMap<Integer, Integer>();
                                                this.coocMapAfter.put(itemI, map);
                                            }
                                            if ((support = map.get(itemJ)) == null) {
                                                map.put(itemJ, 1);
                                            } else {
                                                support = support + 1;
                                                map.put(itemJ, support);
                                            }
                                            alreadyProcessedB.add(itemJ);
                                        }
                                    }
                                }
                                ++j;
                            }
                            alreadyProcessed.add(itemI);
                        }
                    }
                }
                ++i;
            }
        }
        for (Map.Entry entry : this.verticalDB.entrySet()) {
            Prefix prefix = new Prefix();
            prefix.addItemset(new Itemset((Integer)entry.getKey()));
            this.dfsPruning(prefix, (Bitmap)entry.getValue(), frequentItems, frequentItems, (Integer)entry.getKey(), 2, (Integer)entry.getKey());
        }
    }

    private void dfsPruning(Prefix prefix, Bitmap prefixBitmap, List<Integer> sn, List<Integer> in, int hasToBeGreaterThanForIStep, int m, Integer lastAppendedItem) throws IOException {
        ArrayList<Integer> sTemp = new ArrayList<Integer>();
        ArrayList<Bitmap> sTempBitmaps = new ArrayList<Bitmap>();
        Map<Integer, Integer> mapSupportItemsAfter = this.coocMapAfter.get(lastAppendedItem);
        for (Integer i : sn) {
            Integer support;
            if (this.useCMAPPruning && (mapSupportItemsAfter == null || (support = mapSupportItemsAfter.get(i)) == null || support < this.minsup)) continue;
            ++Bitmap.INTERSECTION_COUNT;
            Bitmap newBitmap = prefixBitmap.createNewBitmapSStep(this.verticalDB.get(i), this.sequencesSize, this.lastBitIndex, this.maxGap);
            if (newBitmap.getSupportWithoutGapTotal() < this.minsup) continue;
            sTemp.add(i);
            sTempBitmaps.add(newBitmap);
        }
        int k = 0;
        while (k < sTemp.size()) {
            int item = (Integer)sTemp.get(k);
            Prefix prefixSStep = prefix.cloneSequence();
            prefixSStep.addItemset(new Itemset(item));
            Bitmap newBitmap = (Bitmap)sTempBitmaps.get(k);
            if (newBitmap.getSupport() >= this.minsup) {
                if (m >= this.minimumPatternLength) {
                    this.savePattern(prefixSStep, newBitmap);
                }
                if (this.maximumPatternLength > m) {
                    this.dfsPruning(prefixSStep, newBitmap, sTemp, sTemp, item, m + 1, item);
                }
            }
            ++k;
        }
        Map<Integer, Integer> mapSupportItemsEquals = this.coocMapEquals.get(lastAppendedItem);
        ArrayList<Integer> iTemp = new ArrayList<Integer>();
        ArrayList<Bitmap> iTempBitmaps = new ArrayList<Bitmap>();
        for (Integer i : in) {
            Integer support;
            if (i <= hasToBeGreaterThanForIStep || this.useCMAPPruning && (mapSupportItemsEquals == null || (support = mapSupportItemsEquals.get(i)) == null || support < this.minsup)) continue;
            ++Bitmap.INTERSECTION_COUNT;
            Bitmap newBitmap = prefixBitmap.createNewBitmapIStep(this.verticalDB.get(i), this.sequencesSize, this.lastBitIndex);
            if (newBitmap.getSupport() < this.minsup) continue;
            iTemp.add(i);
            iTempBitmaps.add(newBitmap);
        }
        int k2 = 0;
        while (k2 < iTemp.size()) {
            int item = (Integer)iTemp.get(k2);
            Prefix prefixIStep = prefix.cloneSequence();
            prefixIStep.getItemsets().get(prefixIStep.size() - 1).addItem(item);
            Bitmap newBitmap = (Bitmap)iTempBitmaps.get(k2);
            if (m >= this.minimumPatternLength) {
                this.savePattern(prefixIStep, newBitmap);
            }
            if (this.maximumPatternLength > m) {
                this.dfsPruning(prefixIStep, newBitmap, sTemp, iTemp, item, m + 1, item);
            }
            ++k2;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void savePattern(Integer item, Bitmap bitmap) throws IOException {
        if (this.mustAppearItems != null) {
            if (this.mustAppearItems.length > 1) {
                return;
            }
            if (!item.equals(this.mustAppearItems[0])) {
                return;
            }
        }
        ++this.patternCount;
        StringBuilder r = new StringBuilder("");
        r.append(item);
        r.append(" -1 ");
        r.append("#SUP: ");
        r.append(bitmap.getSupport());
        if (this.outputSequenceIdentifiers) {
            r.append(" #SID: ");
            r.append(bitmap.getSIDs(this.sequencesSize));
        }
        this.writer.write(r.toString());
        this.writer.newLine();
    }

    private void savePattern(Prefix prefix, Bitmap bitmap) throws IOException {
        if (this.mustAppearItems != null) {
            HashSet<Integer> itemsFound = new HashSet<Integer>();
            block0: for (Itemset itemset2 : prefix.getItemsets()) {
                for (Integer item : itemset2.getItems()) {
                    if (!this.itemMustAppearInPatterns(item)) continue;
                    itemsFound.add(item);
                    if (itemsFound.size() == this.mustAppearItems.length) break block0;
                }
            }
            if (itemsFound.size() != this.mustAppearItems.length) {
                return;
            }
        }
        ++this.patternCount;
        StringBuilder r = new StringBuilder("");
        for (Itemset itemset2 : prefix.getItemsets()) {
            for (Integer item : itemset2.getItems()) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append("-1 ");
        }
        r.append("#SUP: ");
        r.append(bitmap.getSupport());
        if (this.outputSequenceIdentifiers) {
            r.append(" #SID: ");
            r.append(bitmap.getSIDs(this.sequencesSize));
        }
        this.writer.write(r.toString());
        this.writer.newLine();
    }

    public void printStatistics() {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  CM-SPAM v0.97 - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : " + this.patternCount);
        r.append('\n');
        r.append(" Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append(this.patternCount);
        r.append('\n');
        r.append("minsup " + this.minsup);
        r.append('\n');
        r.append("Intersection count " + Bitmap.INTERSECTION_COUNT + " \n");
        r.append("===================================================\n");
        System.out.println(r.toString());
    }

    public int getMaximumPatternLength() {
        return this.maximumPatternLength;
    }

    public void setMaximumPatternLength(int maximumPatternLength) {
        this.maximumPatternLength = maximumPatternLength;
    }

    public void setMinimumPatternLength(int minimumPatternLength) {
        this.minimumPatternLength = minimumPatternLength;
    }

    public void setMustAppearItems(int[] mustAppearItems) {
        this.mustAppearItems = (int[])(mustAppearItems.length > 0 ? mustAppearItems : null);
    }

    public boolean itemMustAppearInPatterns(int item) {
        return this.mustAppearItems == null || Arrays.binarySearch(this.mustAppearItems, item) >= 0;
    }

    public void setMaxGap(int maxGap) {
        this.maxGap = maxGap;
    }
}

