/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists;

import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists.IDList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IDListBitmap
implements IDList {
    final int BIT_PER_SECTION = 8;
    Map<Integer, BitSet> sequence_ItemsetEntries;
    BitSet sequences;

    public IDListBitmap() {
        this.sequence_ItemsetEntries = new HashMap<Integer, BitSet>();
        this.sequences = new BitSet();
    }

    private IDListBitmap(Map<Integer, BitSet> sequenceItemsetEntries) {
        this.sequence_ItemsetEntries = sequenceItemsetEntries;
        this.sequences = new BitSet(sequenceItemsetEntries.size());
    }

    public void registerBit(int sid, int tid) {
        int bitIndex = tid;
        BitSet bitmap = this.sequence_ItemsetEntries.get(sid);
        if (bitmap == null) {
            bitmap = new BitSet(8);
            this.sequence_ItemsetEntries.put(sid, bitmap);
            this.sequences.set(sid);
        }
        bitmap.set(bitIndex);
    }

    public void registerNBits(int sid, List<Integer> tids) {
        BitSet bitmap = this.sequence_ItemsetEntries.get(sid);
        if (bitmap == null) {
            bitmap = new BitSet(8);
            this.sequence_ItemsetEntries.put(sid, bitmap);
            this.sequences.set(sid);
        }
        for (Integer tid : tids) {
            int bitIndex = tid;
            bitmap.set(bitIndex, true);
        }
    }

    @Override
    public int getSupport() {
        return this.sequences.cardinality();
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Integer sid : this.sequence_ItemsetEntries.keySet()) {
            BitSet bitmap = this.sequence_ItemsetEntries.get(sid);
            int bit = bitmap.nextSetBit(0);
            while (bit >= 0) {
                buffer.append("[sid=");
                buffer.append(sid);
                buffer.append(" tid=");
                buffer.append(bit);
                buffer.append("]");
                bit = bitmap.nextSetBit(bit + 1);
            }
        }
        return buffer.toString();
    }

    @Override
    public IDList join(IDList idList, boolean equals, int minSupport) {
        HashMap<Integer, BitSet> intersection = new HashMap<Integer, BitSet>(((IDListBitmap)idList).getSecuenceItemsetEntries().size());
        BitSet newSequences = new BitSet(this.getSecuenceItemsetEntries().size());
        IDListBitmap idStandard = (IDListBitmap)idList;
        Map<Integer, BitSet> idListMap = idStandard.getSecuenceItemsetEntries();
        Set<Map.Entry<Integer, BitSet>> entries = idListMap.entrySet();
        if (equals) {
            this.equalLoop(intersection, entries, newSequences);
        } else {
            this.laterLoop(intersection, entries, newSequences);
        }
        IDListBitmap output = new IDListBitmap(intersection);
        output.sequences = newSequences;
        return output;
    }

    private void equalLoop(Map<Integer, BitSet> sequenceItemsetEntries, Set<Map.Entry<Integer, BitSet>> entries, BitSet sequences) {
        for (Map.Entry<Integer, BitSet> entry : entries) {
            BitSet equalResult;
            BitSet otherIdList = entry.getValue();
            BitSet thisIdList = this.sequence_ItemsetEntries.get(entry.getKey());
            if (thisIdList == null || (equalResult = this.equalOperation(thisIdList, otherIdList)) == null) continue;
            int sid = entry.getKey();
            sequenceItemsetEntries.put(sid, equalResult);
            sequences.set(sid);
        }
    }

    private void laterLoop(Map<Integer, BitSet> sequenceItemsetEntries, Set<Map.Entry<Integer, BitSet>> entries, BitSet sequences) {
        for (Map.Entry<Integer, BitSet> entry : entries) {
            BitSet greaterThanResult;
            BitSet otherIdList = entry.getValue();
            BitSet thisIdList = this.sequence_ItemsetEntries.get(entry.getKey());
            if (thisIdList == null || (greaterThanResult = this.greaterThanOperation(thisIdList, otherIdList)) == null) continue;
            int sid = entry.getKey();
            sequenceItemsetEntries.put(sid, greaterThanResult);
            sequences.set(sid);
        }
    }

    @Override
    public void setAppearingSequences(Pattern pattern) {
        pattern.setAppearingIn(this.sequences);
    }

    @Override
    public void clear() {
    }

    public void addAppearancesInSequence(Integer sid, List<Integer> itemsets) {
        this.registerNBits(sid, itemsets);
    }

    public Map<Integer, BitSet> getSecuenceItemsetEntries() {
        return this.sequence_ItemsetEntries;
    }

    public void setSequenceItemsetEntries(Map<Integer, BitSet> sequenceItemsetEntries) {
        this.sequence_ItemsetEntries = sequenceItemsetEntries;
    }

    private BitSet equalOperation(BitSet thisBitmap, BitSet otherBitmap, int temporalDistance) {
        if (thisBitmap != null) {
            BitSet result = (BitSet)thisBitmap.clone();
            result.and(this.shiftToLeft(otherBitmap, temporalDistance));
            if (result.cardinality() > 0) {
                return this.shiftToRight(result, temporalDistance);
            }
        }
        return null;
    }

    private BitSet equalOperation(BitSet thisBitmap, BitSet otherBitmap) {
        if (thisBitmap != null) {
            BitSet result = (BitSet)thisBitmap.clone();
            result.and(otherBitmap);
            if (result.cardinality() > 0) {
                return result;
            }
        }
        return null;
    }

    private BitSet greaterThanOperation(BitSet thisBitmap, BitSet otherBitmap) {
        int index;
        BitSet result = (BitSet)otherBitmap.clone();
        if (thisBitmap != null && (index = thisBitmap.nextSetBit(0)) >= 0 && index < otherBitmap.length() - 1) {
            int newIndex = index + 1;
            result.clear(0, newIndex);
            if (result.nextSetBit(newIndex) > 0) {
                return result;
            }
        }
        return null;
    }

    private BitSet shiftToLeft(BitSet bitsetArg, int temporalDistance) {
        BitSet result = new BitSet(bitsetArg.length());
        int bitIndex = bitsetArg.nextSetBit(0);
        while (bitIndex >= 0) {
            int dif = bitIndex - temporalDistance;
            if (dif >= 0) {
                result.set(dif);
            }
            bitIndex = bitsetArg.nextSetBit(bitIndex + 1);
        }
        return result;
    }

    private BitSet shiftToRight(BitSet bitsetArg, int temporalDistance) {
        BitSet result = new BitSet(bitsetArg.length());
        int bitIndex = bitsetArg.nextSetBit(0);
        while (bitIndex >= 0) {
            int dif = bitIndex + temporalDistance;
            result.set(dif);
            bitIndex = bitsetArg.nextSetBit(bitIndex + 1);
        }
        return result;
    }
}

