/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.skopus;

public class Combination {
    private int n;
    private int r;
    private int[] index;
    private boolean hasNext = true;

    public Combination(int n, int r) {
        this.n = n;
        this.r = r;
        this.index = new int[r];
        int i = 0;
        while (i < r) {
            this.index[i] = i;
            ++i;
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    private void moveIndex() {
        int i = this.rightmostIndexBelowMax();
        if (i >= 0) {
            this.index[i] = this.index[i] + 1;
            int j = i + 1;
            while (j < this.r) {
                this.index[j] = this.index[j - 1] + 1;
                ++j;
            }
        } else {
            this.hasNext = false;
        }
    }

    public int[] next() {
        if (!this.hasNext) {
            return null;
        }
        int[] result = new int[this.r];
        int i = 0;
        while (i < this.r) {
            result[i] = this.index[i];
            ++i;
        }
        this.moveIndex();
        return result;
    }

    private int rightmostIndexBelowMax() {
        int i = this.r - 1;
        while (i >= 0) {
            if (this.index[i] < this.n - this.r + i) {
                return i;
            }
            --i;
        }
        return -1;
    }
}

