/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.skopus;

import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.Combination;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.GlobalOper;
import java.util.ArrayList;

public class BinPartitionTemplate
extends ArrayList<Byte[]> {
    private int nMLength = 0;

    public BinPartitionTemplate(int nLength) {
        if (nLength < 2) {
            this.clear();
            return;
        }
        this.nMLength = nLength;
        int nTotalSize = 0;
        int i = 1;
        while (i <= this.nMLength / 2) {
            nTotalSize += (int)Math.ceil(Math.exp(GlobalOper.log_combin(this.nMLength, i)));
            ++i;
        }
        this.ensureCapacity(nTotalSize + 2);
        this.createAllPartition();
    }

    private void createAllPartition() {
        this.clear();
        int ix = 1;
        while (ix <= this.nMLength / 2) {
            Combination c = new Combination(this.nMLength, ix);
            while (c.hasNext()) {
                int[] a = c.next();
                Byte[] naTemplate = new Byte[this.nMLength];
                int i = 0;
                while (i < naTemplate.length) {
                    naTemplate[i] = 1;
                    ++i;
                }
                i = 0;
                while (i < a.length) {
                    naTemplate[a[i]] = 0;
                    ++i;
                }
                this.add(naTemplate);
            }
            ++ix;
        }
    }

    public int getLength() {
        return this.nMLength;
    }
}

