/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.util;

import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.util.Utils;

public class Timer {
    public static boolean VERBOSE = true;
    private long start;
    private long intermediateStart;
    private String process;

    public Timer(String process) {
        this.intermediateStart = this.start = System.currentTimeMillis();
        this.process = process;
        if (process.length() > 20) {
            this.process = String.valueOf(process.substring(0, 20)) + "...";
        }
        if (VERBOSE) {
            System.out.format(">Started %s\n", process);
        }
    }

    public void progress(long i, long total) {
        this.progress(null, i, total);
    }

    public void progress(String message, long i, long total) {
        long end = System.currentTimeMillis();
        long elapsed = end - this.intermediateStart;
        long elapsedTotal = end - this.start;
        if (VERBOSE) {
            String estimate = "";
            if (total < i) {
                total = i;
            }
            if (total > 10L) {
                long estimatedMilis = Math.round((double)(total - i) * ((double)elapsedTotal / (double)i));
                estimate = " Expected " + Utils.milisToStringReadable(estimatedMilis);
            }
            System.out.format(" Process %s %s: %.2f %% items. Elapsed %s. Total %s.%s\n", this.process, message == null ? "" : message, (double)i / (double)total * 100.0, Utils.milisToStringReadable(elapsed), Utils.milisToStringReadable(elapsedTotal), estimate);
        }
        this.intermediateStart = System.currentTimeMillis();
    }

    public long end() {
        long end = System.currentTimeMillis();
        long elapsed = end - this.start;
        if (VERBOSE) {
            System.out.format("<Finished %s. Took %s\n", this.process, Utils.milisToStringReadable(elapsed));
        }
        return elapsed;
    }
}

