/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public class FileStream {
    private Reader reader;
    private char[] seperators = new char[]{' ', '\n'};
    private char[] buff = new char[16384];
    private int len = 0;
    private int start = 0;

    public FileStream(File input, char ... seperators) throws IOException {
        this.reader = new FileReader(input);
        this.seperators = seperators;
    }

    public void setBufferSize(int size) {
        this.buff = new char[size];
    }

    public String nextToken() throws IOException {
        if (this.reader == null) {
            return null;
        }
        if (this.start == this.len && !this.readFromBuff()) {
            return null;
        }
        int endIndex = FileStream.indexOf(this.buff, this.seperators, this.start, this.len);
        if (endIndex != -1) {
            char[] token = Arrays.copyOfRange(this.buff, this.start, endIndex);
            this.start = endIndex + 1;
            while (this.start < this.len) {
                if (FileStream.indexOf(this.seperators, this.buff[this.start]) == -1) break;
                ++this.start;
            }
            String s = new String(token);
            return s;
        }
        char[] previous = Arrays.copyOfRange(this.buff, this.start, this.len);
        StringBuffer bufferString = new StringBuffer();
        bufferString.append(previous);
        while (true) {
            if (!this.readFromBuff()) {
                return bufferString.toString();
            }
            endIndex = FileStream.indexOf(this.buff, this.seperators, this.start, this.len);
            if (endIndex != -1) break;
            bufferString.append(this.buff);
        }
        char[] token = Arrays.copyOfRange(this.buff, this.start, endIndex);
        this.start = endIndex + 1;
        while (this.start < this.len) {
            if (FileStream.indexOf(this.seperators, this.buff[this.start]) == -1) break;
            ++this.start;
        }
        bufferString.append(token);
        return bufferString.toString();
    }

    private boolean readFromBuff() throws IOException {
        this.len = this.reader.read(this.buff);
        this.start = 0;
        if (this.len == -1) {
            this.len = 0;
            this.reader.close();
            this.reader = null;
            return false;
        }
        return true;
    }

    private static final int indexOf(char[] data, char[] targets, int start, int end) {
        int i = start;
        while (i < end) {
            if (FileStream.indexOf(targets, data[i]) != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static final int indexOf(char[] data, char target) {
        int i = 0;
        while (i < data.length) {
            if (data[i] == target) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

