/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.qcsp;

import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.QCSPData;
import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.SequentialPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.Window;
import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.util.CountMap;
import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.util.Pair;
import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.util.Timer;
import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.util.Triple;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class AlgoQCSP {
    private double alpha;
    private int minsup;
    private int maxsize;
    private int topK;
    private String patternOutputFile;
    private boolean pruningOf = false;
    private boolean debug = false;
    private String labelsFile = null;
    public static long DEBUG_ITER = 1000000L;
    private List<Window> init = this.makeList(new Window(-1, -1, -1));
    private QCSPData data;
    private double mincoh = 0.0;
    private long elapsedTime = -1L;
    private long iterations = 0L;
    private long leafs = 0L;
    private long patternCount = 0L;
    private List<Window> shorterWindowsCache = new ArrayList<Window>();
    private List<Pair<List<Integer>, Window>> stack = new ArrayList<Pair<List<Integer>, Window>>();
    private List<List<Integer>> occurrences = new ArrayList<List<Integer>>();
    private Map<Integer, Integer> itemAtT = new HashMap<Integer, Integer>();
    private static Comparator<Pair<SequentialPattern, Double>> heapComparator = new Comparator<Pair<SequentialPattern, Double>>(){

        @Override
        public int compare(Pair<SequentialPattern, Double> o1, Pair<SequentialPattern, Double> o2) {
            return Double.compare(o1.getSecond(), o2.getSecond());
        }
    };

    public List<Pair<SequentialPattern, Double>> runAlgorithm(String singleSequenceFile, String patternOutputFile, int minsup, double alpha, int maxsize, int topK) throws IOException {
        this.minsup = minsup;
        this.alpha = alpha;
        this.maxsize = maxsize;
        this.topK = topK;
        this.patternOutputFile = patternOutputFile;
        this.data = new QCSPData();
        this.data.loadData(new File(singleSequenceFile), this.labelsFile != null ? new File(this.labelsFile) : null, minsup, alpha, maxsize, this.debug);
        return this.run(this.debug);
    }

    public void setPruningOf(boolean pruningOf) {
        this.pruningOf = pruningOf;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setLabelsFile(String labelsFile) {
        this.labelsFile = labelsFile;
    }

    public List<Pair<SequentialPattern, Double>> run(boolean debug) throws IOException {
        Timer timer = new Timer("QSCP.run()");
        System.out.format("Parameters: alpha=%f, maxsize=%d, top-k=%d, pruningOf=%s\n", this.alpha, this.maxsize, this.topK, this.pruningOf);
        PriorityQueue<Pair<SequentialPattern, Double>> heapPatterns = new PriorityQueue<Pair<SequentialPattern, Double>>(this.topK, heapComparator);
        this.mincoh = 0.0;
        ArrayList<Triple<SequentialPattern, List<Window>, List<Integer>>> stack = new ArrayList<Triple<SequentialPattern, List<Window>, List<Integer>>>();
        List<Integer> allItems = this.data.getItemsSortedOnAscendingSupport();
        stack.add(new Triple<SequentialPattern, List<Window>, List<Integer>>(new SequentialPattern(), this.init, allItems));
        this.iterations = 0L;
        this.leafs = 0L;
        while (!stack.isEmpty()) {
            ++this.iterations;
            Triple top = (Triple)stack.remove(stack.size() - 1);
            SequentialPattern X = (SequentialPattern)top.getFirst();
            List P = (List)top.getSecond();
            List Y = (List)top.getThirth();
            if (debug && this.iterations % DEBUG_ITER == 0L) {
                int currentIndex = allItems.indexOf(X.pattern.size() > 0 ? X.pattern.get(0) : 0);
                timer.progress(currentIndex, allItems.size());
                System.out.format("Iterations:%-10d, #Patterns: %d, worst: %s, min_coh:%.3f, \n", this.iterations / DEBUG_ITER, heapPatterns.size(), this.toString(heapPatterns.size() > 0 ? heapPatterns.peek().getFirst().pattern : Collections.EMPTY_LIST), this.mincoh);
            }
            if (Y.size() == 0) {
                if (X.length() <= 1) continue;
                ++this.leafs;
                double qcoh = this.quantileCohesionComputedOnProjection(X, P);
                if (heapPatterns.size() < this.topK) {
                    heapPatterns.add(new Pair<SequentialPattern, Double>(X, qcoh));
                    if (heapPatterns.size() != this.topK) continue;
                    this.mincoh = heapPatterns.peek().getSecond();
                    continue;
                }
                if (!(qcoh > this.mincoh)) continue;
                heapPatterns.poll();
                heapPatterns.add(new Pair<SequentialPattern, Double>(X, qcoh));
                this.mincoh = heapPatterns.peek().getSecond();
                continue;
            }
            if (!this.pruningOf && this.prune(X, P, Y, this.mincoh)) continue;
            stack.add(new Triple(X, P, new ArrayList(Y.subList(1, Y.size()))));
            if (X.length() == this.maxsize) continue;
            int nextItem = (Integer)Y.get(0);
            SequentialPattern Z = new SequentialPattern(X, nextItem);
            List<Window> projectionZ = this.project(Z, P);
            List<Integer> itemsZ = this.projectCandidates(Z, projectionZ);
            stack.add(new Triple<SequentialPattern, List<Window>, List<Integer>>(Z, projectionZ, itemsZ));
        }
        this.elapsedTime = timer.end();
        this.patternCount = heapPatterns.size();
        ArrayList<Pair<SequentialPattern, Double>> sorted = new ArrayList<Pair<SequentialPattern, Double>>();
        while (!heapPatterns.isEmpty()) {
            Pair<SequentialPattern, Double> pattern = heapPatterns.poll();
            sorted.add(pattern);
        }
        Collections.sort(sorted, new Comparator<Pair<SequentialPattern, Double>>(){

            @Override
            public int compare(Pair<SequentialPattern, Double> o1, Pair<SequentialPattern, Double> o2) {
                return (int)(10000.0 * o2.getSecond() - 10000.0 * o1.getSecond() + (double)AlgoQCSP.this.data.support(o2.getFirst().pattern) - (double)AlgoQCSP.this.data.support(o1.getFirst().pattern));
            }
        });
        this.savePatterns(sorted);
        return sorted;
    }

    private void savePatterns(List<Pair<SequentialPattern, Double>> sortedPatterns) throws IOException {
        BufferedWriter writer = null;
        if (this.patternOutputFile != null) {
            File output = new File(this.patternOutputFile);
            if (!output.getParentFile().exists()) {
                output.getParentFile().mkdirs();
            }
            writer = new BufferedWriter(new FileWriter(output));
        }
        System.out.println("============================");
        System.out.println("QC Patterns:");
        int i = 0;
        while (i < sortedPatterns.size()) {
            Pair<SequentialPattern, Double> pattern = sortedPatterns.get(i);
            String patternToString = null;
            patternToString = this.data.hasLabels() ? String.format("%s   #SUP: %d   #QCOH: %.3f", this.toString(pattern.getFirst().pattern), this.data.support(pattern.getFirst().pattern), pattern.getSecond()) : String.format("%s   #SUP: %d   #QCOH: %.3f", this.toStringSPMF(pattern.getFirst().pattern), this.data.support(pattern.getFirst().pattern), pattern.getSecond());
            System.out.println(patternToString);
            if (this.patternOutputFile != null) {
                writer.write(patternToString);
                writer.write("\n");
            }
            ++i;
        }
        if (this.patternOutputFile != null) {
            writer.close();
        }
        System.out.println("end QC Patterns:");
        System.out.println("============================");
    }

    public void printStatistics() {
        System.out.println("=============  QCSP algorithm v1.00 - STATS =======");
        System.out.println(" Pattern count: " + this.patternCount);
        System.out.println(" Min cohesion: " + this.mincoh);
        System.out.println(" Total time ~ " + this.elapsedTime + " ms");
        System.out.println(" Number of iterations: " + this.iterations);
        System.out.println(" Number of candidates: " + this.leafs);
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" Parameters");
        System.out.println("  Maxsize: " + this.maxsize);
        System.out.println("  Pruning enabled: " + !this.pruningOf);
        System.out.println("  Alpha: " + this.alpha);
        System.out.println("  Top-k: " + this.topK);
        System.out.println(" Input file information");
        System.out.println("  number of symbols: " + this.data.getItemsSortedOnAscendingSupport().size());
        System.out.println("  sequence length: " + this.data.getSequenceSize());
        System.out.println("  label file enabled: " + this.data.hasLabels());
        System.out.println("===========================================================");
    }

    public double quantileCohesionComputedOnProjection(SequentialPattern X, List<Window> projectionX) {
        int maxwin = (int)Math.floor(this.alpha * (double)X.length());
        Map<Integer, Integer> minWinAtT = this.computeMinimalWindowsBasedOnProjection1(X, projectionX, maxwin);
        int count = minWinAtT.keySet().size();
        int supportX = this.data.support(X.pattern);
        double qcoh = (double)count / (double)supportX;
        return qcoh;
    }

    private Map<Integer, Integer> computeMinimalWindowsBasedOnProjection1(SequentialPattern X, List<Window> projectionX, int maxwin) {
        ArrayList<Window> shorterWindows = new ArrayList<Window>();
        for (Window window : projectionX) {
            if (window.a - window.t > maxwin) continue;
            int end = Math.min(window.b, window.t + maxwin);
            shorterWindows.add(new Window(window.t, end, end));
        }
        List<Integer> sequence = this.data.getSequence();
        ArrayList<Pair<ArrayList<Integer>, Window>> stack = new ArrayList<Pair<ArrayList<Integer>, Window>>();
        for (Window window : shorterWindows) {
            ArrayList<Integer> X_poslist = this.makeList(window.t);
            stack.add(new Pair<ArrayList<Integer>, Window>(X_poslist, new Window(window.t + 1, window.b, window.b)));
        }
        ArrayList<List> occurrences = new ArrayList<List>();
        while (!stack.isEmpty()) {
            Pair top = (Pair)stack.remove(stack.size() - 1);
            List poslist = (List)top.getFirst();
            Window window = (Window)top.getSecond();
            if (poslist.size() == X.length()) {
                occurrences.add(poslist);
                continue;
            }
            int currentItem = X.pattern.get(poslist.size());
            int i = window.t;
            while (i < window.b) {
                Integer item = sequence.get(i);
                if (item != null && item == currentItem) {
                    ArrayList<Integer> newPoslist = new ArrayList<Integer>(poslist);
                    newPoslist.add(i);
                    stack.add(new Pair(newPoslist, new Window(i + 1, window.b, window.b)));
                }
                ++i;
            }
        }
        HashMap<Integer, Integer> minWinAtT = new HashMap<Integer, Integer>();
        for (List occurrence : occurrences) {
            Integer mwin = (Integer)occurrence.get(occurrence.size() - 1) - (Integer)occurrence.get(0);
            for (Integer pos : occurrence) {
                minWinAtT.put(pos, this.minWindow(mwin, (Integer)minWinAtT.get(pos)));
            }
        }
        return minWinAtT;
    }

    private int computeNumberOfMinimalWindowsBasedOnProjection(SequentialPattern X, Set<Integer> XNoneOverlapping, List<Window> projectionX, int lengthZMax) {
        int maxwin = (int)Math.floor(this.alpha * (double)lengthZMax);
        List<Integer> sequence = this.data.getSequence();
        List<Window> shorterWindows = projectionX;
        if (lengthZMax < this.maxsize) {
            shorterWindows = this.shorterWindowsCache;
            this.shorterWindowsCache.clear();
            for (Window window : projectionX) {
                if (window.a - window.t > maxwin) continue;
                int end = Math.min(window.b, window.t + maxwin);
                shorterWindows.add(new Window(window.t, end, end));
            }
        }
        this.stack.clear();
        for (Window window : shorterWindows) {
            ArrayList<Integer> X_poslist = new ArrayList<Integer>(X.length());
            X_poslist.add(window.t);
            this.stack.add(new Pair(X_poslist, new Window(window.t + 1, window.b, window.b)));
        }
        this.occurrences.clear();
        while (!this.stack.isEmpty()) {
            Pair<List<Integer>, Window> top = this.stack.remove(this.stack.size() - 1);
            List<Integer> poslist = top.getFirst();
            Window window = top.getSecond();
            if (poslist.size() == X.length()) {
                this.occurrences.add(poslist);
                continue;
            }
            int currentItem = X.pattern.get(poslist.size());
            int i = window.t;
            while (i < window.b) {
                Integer item = sequence.get(i);
                if (item != null && item == currentItem) {
                    ArrayList<Integer> newPoslist = new ArrayList<Integer>(poslist);
                    newPoslist.add(i);
                    this.stack.add(new Pair(newPoslist, new Window(i + 1, window.b, window.b)));
                }
                ++i;
            }
        }
        this.itemAtT.clear();
        for (List<Integer> occurrence : this.occurrences) {
            int i = 0;
            while (i < occurrence.size()) {
                this.itemAtT.put(occurrence.get(i), X.pattern.get(i));
                ++i;
            }
        }
        int countSmallWindowsNonOverlapping = 0;
        for (Map.Entry<Integer, Integer> entry : this.itemAtT.entrySet()) {
            Integer item = entry.getValue();
            if (!XNoneOverlapping.contains(item)) continue;
            ++countSmallWindowsNonOverlapping;
        }
        return countSmallWindowsNonOverlapping;
    }

    private int minWindow(Integer a, Integer bOrNull) {
        if (bOrNull == null) {
            return a;
        }
        return Math.min(a, bOrNull);
    }

    private List<Window> project(SequentialPattern Z, List<Window> projectionX) {
        List<Integer> sequence = this.data.getSequence();
        if (Z.length() == 1) {
            List<Integer> positions = this.data.getPositions(Z.pattern.get(0));
            ArrayList<Window> windows = new ArrayList<Window>(positions.size());
            int maxwin = (int)Math.floor(this.alpha * (double)this.maxsize);
            for (int pos : positions) {
                windows.add(new Window(pos, pos + 1, Math.min(pos + maxwin, this.data.getSequenceSize())));
            }
            return windows;
        }
        ArrayList<Window> windows = new ArrayList<Window>(projectionX.size());
        int lastItem = Z.pattern.get(Z.length() - 1);
        for (Window window : projectionX) {
            int found = -1;
            int i = window.a;
            while (i < window.b) {
                Integer item = sequence.get(i);
                if (item != null && item == lastItem) {
                    found = i;
                    break;
                }
                ++i;
            }
            if (found == -1) continue;
            windows.add(new Window(window.t, found + 1, window.b));
        }
        return windows;
    }

    private List<Integer> projectCandidates(SequentialPattern z, List<Window> projectionZ) {
        List<Integer> sequence = this.data.getSequence();
        CountMap<Integer> supportInP = new CountMap<Integer>();
        for (Window window : projectionZ) {
            int i = window.a;
            while (i < window.b) {
                Integer item = sequence.get(i);
                if (item != null) {
                    supportInP.add(item);
                }
                ++i;
            }
        }
        return this.data.getItemsSorted(supportInP, false);
    }

    private boolean prune(SequentialPattern X, List<Window> P, List<Integer> Y, double mincoh) {
        int xLen = X.length();
        if (xLen < 2) {
            return false;
        }
        boolean overlap = false;
        for (Integer item : X.pattern) {
            if (!Y.contains(item)) continue;
            overlap = true;
            break;
        }
        if (!overlap) {
            int lengthZMax = Math.min(this.computeLengthZMax(X, P), this.maxsize);
            int mingap = this.computeMinGap(X, P);
            if ((double)(mingap + lengthZMax) > this.alpha * (double)(lengthZMax + xLen)) {
                return true;
            }
        }
        HashSet<Integer> XNoneOverlapping = new HashSet<Integer>();
        XNoneOverlapping.addAll(X.pattern);
        XNoneOverlapping.removeAll(Y);
        if (XNoneOverlapping.size() == 0) {
            return false;
        }
        int supportXNoneOverlapping = this.data.support(XNoneOverlapping);
        int supportZMax = supportXNoneOverlapping + this.data.support(Y);
        int maxsizeYPlus = this.computeYPlus(X, P, Y);
        int lengthZMaxCorrect = Math.min(xLen + maxsizeYPlus, this.maxsize);
        int countSmallWindowsNonOverlapping = this.computeNumberOfMinimalWindowsBasedOnProjection(X, XNoneOverlapping, P, lengthZMaxCorrect);
        int countLargeWindows = supportXNoneOverlapping - countSmallWindowsNonOverlapping;
        double maxQuantileCohesion = 1.0 - (double)countLargeWindows / (double)supportZMax;
        return maxQuantileCohesion <= mincoh;
    }

    private int computeYPlus(SequentialPattern X, List<Window> projectionX, List<Integer> Y) {
        List<Integer> sequence = this.data.getSequence();
        int[] multisetCount = new int[Y.size()];
        int[] windowCounts = new int[Y.size()];
        for (Window window : projectionX) {
            int i = window.a;
            while (i < window.b) {
                int idx;
                Integer item = sequence.get(i);
                if (item != null && (idx = Y.indexOf(item)) != -1) {
                    int n = idx;
                    windowCounts[n] = windowCounts[n] + 1;
                }
                ++i;
            }
            i = 0;
            while (i < Y.size()) {
                multisetCount[i] = Math.max(windowCounts[i], multisetCount[i]);
                ++i;
            }
        }
        int maxlen = 0;
        int[] nArray = multisetCount;
        int n = multisetCount.length;
        int n2 = 0;
        while (n2 < n) {
            int count = nArray[n2];
            maxlen += count;
            ++n2;
        }
        return maxlen;
    }

    private int computeMinGap(SequentialPattern X, List<Window> P) {
        int mingap = Integer.MAX_VALUE;
        for (Window window : P) {
            mingap = Math.min(window.a - window.t, mingap);
        }
        return mingap;
    }

    private int computeLengthZMax(SequentialPattern X, List<Window> P) {
        List<Integer> sequence = this.data.getSequence();
        int maxlen = 0;
        for (Window window : P) {
            int start = window.a;
            int i = window.a;
            while (i < window.b) {
                if (sequence.get(i) != null) break;
                ++start;
                ++i;
            }
            int end = window.b;
            int i2 = window.b - 1;
            while (i2 >= window.a) {
                if (sequence.get(i2) != null) break;
                --end;
                --i2;
            }
            maxlen = Math.max(maxlen, end - start);
        }
        return X.length() + maxlen;
    }

    private <T> ArrayList<T> makeList(T first) {
        ArrayList<T> lst = new ArrayList<T>();
        lst.add(first);
        return lst;
    }

    private String toString(List<Integer> pattern) {
        if (this.data.hasLabels()) {
            return this.data.patternToString(pattern);
        }
        StringBuffer buff = new StringBuffer();
        buff.append("(");
        int i = 0;
        while (i < pattern.size() - 1) {
            buff.append(pattern.get(i));
            buff.append(",");
            ++i;
        }
        if (pattern.size() > 0) {
            buff.append(pattern.get(pattern.size() - 1));
        }
        buff.append(")");
        return buff.toString();
    }

    private String toStringSPMF(List<Integer> pattern) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < pattern.size()) {
            buff.append(pattern.get(i));
            buff.append(" -1 ");
            ++i;
        }
        return buff.toString();
    }

    public int support(List<Integer> pattern) {
        return this.data.support(pattern);
    }
}

