/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class SequenceDatabase {
    protected List<int[]> sequences = new ArrayList<int[]>();
    protected long itemOccurrenceCount = 0L;

    public void loadFile(String path) throws IOException {
        this.itemOccurrenceCount = 0L;
        this.sequences = new ArrayList<int[]>();
        try (BufferedReader myInput = null;){
            try {
                String thisLine;
                FileInputStream fin = new FileInputStream(new File(path));
                myInput = new BufferedReader(new InputStreamReader(fin));
                while ((thisLine = myInput.readLine()) != null) {
                    if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                    String[] tokens = thisLine.split(" ");
                    int[] sequence = new int[tokens.length];
                    int j = 0;
                    while (j < tokens.length) {
                        sequence[j] = Integer.parseInt(tokens[j]);
                        ++j;
                    }
                    this.sequences.add(sequence);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
    }

    public void print() {
        System.out.println("============  SEQUENCE DATABASE ==========");
        System.out.println(this.toString());
    }

    public void printDatabaseStats() {
        System.out.println("============  STATS ==========");
        System.out.println("Number of sequences : " + this.sequences.size());
        double meansize = (float)this.itemOccurrenceCount / (float)this.sequences.size();
        System.out.println("mean size" + meansize);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.sequences.size()) {
            buffer.append(String.valueOf(i) + ":  ");
            int[] sequence = this.sequences.get(i);
            boolean startingANewItemset = true;
            int[] nArray = sequence;
            int n = sequence.length;
            int n2 = 0;
            while (n2 < n) {
                int token = nArray[n2];
                if (token >= 0) {
                    if (startingANewItemset) {
                        startingANewItemset = false;
                        buffer.append("(");
                    } else {
                        buffer.append(" ");
                    }
                    buffer.append(token);
                    ++this.itemOccurrenceCount;
                } else if (token == -1) {
                    buffer.append(")");
                    startingANewItemset = true;
                } else if (token == -2) break;
                ++n2;
            }
            buffer.append(System.lineSeparator());
            ++i;
        }
        return buffer.toString();
    }

    public int size() {
        return this.sequences.size();
    }

    public List<int[]> getSequences() {
        return this.sequences;
    }
}

