/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items;

import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.ItemFactory;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.abstractions.Abstraction_Generic;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.creators.AbstractionCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.patterns.PatternCreator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SequenceDatabase {
    private AbstractionCreator abstractionCreator;
    private Map<Item, BitSet> frequentItems = new HashMap<Item, BitSet>();
    private List<Sequence> sequences = new LinkedList<Sequence>();
    private ItemFactory<Integer> itemFactory = new ItemFactory();
    private PatternCreator patternCreator = new PatternCreator();

    public SequenceDatabase(AbstractionCreator creador) {
        this.abstractionCreator = creador;
    }

    public void loadFile(String path, double minSupportRelative) throws IOException {
        try (BufferedReader myInput = null;){
            try {
                String thisLine;
                FileInputStream fin = new FileInputStream(new File(path));
                myInput = new BufferedReader(new InputStreamReader(fin));
                int sequenceID = 1;
                while ((thisLine = myInput.readLine()) != null) {
                    if (thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                    this.addSequence(thisLine.split(" "), sequenceID);
                    ++sequenceID;
                }
                double minSupportAbsolute = (int)Math.ceil(minSupportRelative * (double)this.sequences.size());
                Set<Item> frequent = this.frequentItems.keySet();
                HashSet<Item> toRemove = new HashSet<Item>();
                for (Item item : frequent) {
                    if (!((double)this.frequentItems.get(item).cardinality() < minSupportAbsolute)) continue;
                    toRemove.add(item);
                }
                for (Item<Object> item : toRemove) {
                    this.frequentItems.remove(item);
                }
            }
            catch (Exception exception) {
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
    }

    public void addSequence(String[] integers, int sequenceID) {
        long timestamp = -1L;
        Sequence sequence = new Sequence(this.sequences.size());
        sequence.setID(sequenceID);
        Itemset itemset2 = new Itemset();
        int inicio = 0;
        HashMap<Item, Boolean> counted = new HashMap<Item, Boolean>();
        int i = inicio;
        while (i < integers.length) {
            if (integers[i].codePointAt(0) == 60) {
                String value = integers[i].substring(1, integers[i].length() - 1);
                timestamp = Long.parseLong(value);
                itemset2.setTimestamp(timestamp);
            } else if (integers[i].equals("-1")) {
                long time = itemset2.getTimestamp() + 1L;
                sequence.addItemset(itemset2);
                itemset2 = new Itemset();
                itemset2.setTimestamp(time);
            } else if (integers[i].equals("-2")) {
                this.sequences.add(sequence);
            } else {
                Item item = this.itemFactory.getItem(Integer.parseInt(integers[i]));
                Abstraction_Generic abs = this.abstractionCreator.CreateDefaultAbstraction();
                if (counted.get(item) == null) {
                    counted.put(item, Boolean.TRUE);
                    BitSet appearances = this.frequentItems.get(item);
                    if (appearances == null) {
                        appearances = new BitSet();
                        this.frequentItems.put(item, appearances);
                    }
                    appearances.set(sequence.getId());
                }
                itemset2.addItem(item);
            }
            ++i;
        }
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (Sequence sequence : this.sequences) {
            r.append(sequence.getId());
            r.append(":  ");
            r.append(sequence.toString());
            r.append('\n');
        }
        return r.toString();
    }

    public int size() {
        return this.sequences.size();
    }

    public List<Sequence> getSequences() {
        return this.sequences;
    }

    public Map<Item, BitSet> getFrequentItems() {
        return this.frequentItems;
    }

    public void clear() {
        this.abstractionCreator = null;
        if (this.frequentItems != null) {
            this.frequentItems.clear();
        }
        this.frequentItems = null;
        if (this.sequences != null) {
            this.sequences.clear();
        }
        this.sequences = null;
        this.itemFactory = null;
        this.patternCreator = null;
    }
}

