/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP;

import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.Pair;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.PseudoSequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.abstractions.Abstraction_Generic;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.abstractions.ItemAbstractionPair;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.creators.AbstractionCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.creators.ItemAbstractionPairCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.savers.Saver;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RecursionPrefixSpan_AGP {
    private AbstractionCreator abstractionCreator;
    private Saver saver;
    private long minSupportAbsolute;
    private PseudoSequenceDatabase pseudoDatabase;
    private Map<Item, BitSet> mapSequenceID;
    private int numberOfFrequentPatterns = 0;

    public RecursionPrefixSpan_AGP(AbstractionCreator abstractionCreator, Saver saver, long minSupportAbsolute, PseudoSequenceDatabase pseudoDatabase, Map<Item, BitSet> mapSequenceID) {
        this.abstractionCreator = abstractionCreator;
        this.saver = saver;
        this.minSupportAbsolute = minSupportAbsolute;
        this.pseudoDatabase = pseudoDatabase;
        this.mapSequenceID = mapSequenceID;
    }

    public void execute(boolean keepPatterns, boolean verbose) {
        ArrayList<Item> keySetList = new ArrayList<Item>(this.mapSequenceID.keySet());
        Collections.sort(keySetList);
        if (verbose) {
            System.out.println(String.valueOf(keySetList.size()) + " frequent items");
        }
        int numberOfFrequentItems = keySetList.size();
        int cont = 0;
        for (Item item : keySetList) {
            ++cont;
            if (verbose) {
                System.out.println("Projecting item = " + item + " (" + cont + "/" + numberOfFrequentItems + ")");
            }
            PseudoSequenceDatabase projectedContext = this.makePseudoProjections(item, this.pseudoDatabase, this.abstractionCreator.CreateDefaultAbstraction(), true);
            ItemAbstractionPair pair = new ItemAbstractionPair(item, this.abstractionCreator.CreateDefaultAbstraction());
            Pattern prefix = new Pattern(pair);
            prefix.setAppearingIn((BitSet)this.mapSequenceID.get(item).clone());
            if (keepPatterns) {
                this.saver.savePattern(prefix);
            }
            ++this.numberOfFrequentPatterns;
            if (projectedContext == null || (long)projectedContext.size() < this.minSupportAbsolute) continue;
            this.prefixSpanLoop(prefix, 2, projectedContext, keepPatterns, verbose);
        }
    }

    private PseudoSequenceDatabase makePseudoProjections(Item item, PseudoSequenceDatabase database, Abstraction_Generic abstraction, boolean firstTime) {
        PseudoSequenceDatabase newProjectedDatabase = new PseudoSequenceDatabase();
        List<PseudoSequence> pseudoSequences = database.getPseudoSequences();
        int sequenceIndex = 0;
        while (sequenceIndex < pseudoSequences.size()) {
            PseudoSequence sequence = pseudoSequences.get(sequenceIndex);
            int potentialSize = newProjectedDatabase.size() + pseudoSequences.size() - sequenceIndex;
            if ((long)potentialSize < this.minSupportAbsolute) {
                return null;
            }
            boolean alreadyProjected = false;
            PseudoSequence newSequence = null;
            int numberOfProjections = 0;
            HashSet<Integer> projectionsAlreadyMade = new HashSet<Integer>();
            int k = 0;
            while (k < sequence.numberOfProjectionsIncluded()) {
                int sequenceSize = sequence.size(k);
                int i = 0;
                while (i < sequenceSize) {
                    int index = sequence.indexOf(k, i, item);
                    if (index != -1 && (firstTime || abstraction.compute(sequence, k, i))) {
                        int itemsetSize = sequence.getSizeOfItemsetAt(k, i);
                        if (index != itemsetSize - 1) {
                            if (!alreadyProjected) {
                                newSequence = new PseudoSequence(sequence.getRelativeTimeStamp(i, k), sequence, i, index + 1, k);
                                projectionsAlreadyMade.add(sequence.getFirstItemset(k) + i);
                                if (newSequence.size(numberOfProjections) > 0) {
                                    ++numberOfProjections;
                                    newProjectedDatabase.addSequence(newSequence);
                                }
                                alreadyProjected = true;
                            } else if (projectionsAlreadyMade.add(sequence.getFirstItemset(k) + i)) {
                                newSequence.addProjectionPoint(k, sequence.getRelativeTimeStamp(i, k), sequence, i, index + 1);
                            }
                        } else if (i != sequenceSize - 1) {
                            if (!alreadyProjected) {
                                newSequence = new PseudoSequence(sequence.getRelativeTimeStamp(i, k), sequence, i + 1, 0, k);
                                projectionsAlreadyMade.add(sequence.getFirstItemset(k) + i);
                                if (itemsetSize > 0 && newSequence.size(numberOfProjections) > 0) {
                                    ++numberOfProjections;
                                    newProjectedDatabase.addSequence(newSequence);
                                }
                                alreadyProjected = true;
                            } else if (projectionsAlreadyMade.add(sequence.getFirstItemset(k) + i)) {
                                newSequence.addProjectionPoint(k, sequence.getRelativeTimeStamp(i, k), sequence, i + 1, 0);
                            }
                        }
                    }
                    ++i;
                }
                ++k;
            }
            ++sequenceIndex;
        }
        return newProjectedDatabase;
    }

    private void prefixSpanLoop(Pattern prefix, int k, PseudoSequenceDatabase context, boolean keepPatterns, boolean verbose) {
        Set<Pair> pairs = this.abstractionCreator.findAllFrequentPairs(context.getPseudoSequences());
        ItemAbstractionPairCreator pairCreator = ItemAbstractionPairCreator.getInstance();
        if (verbose) {
            StringBuilder tab = new StringBuilder();
            int i = 0;
            while (i < k - 2) {
                tab.append('\t');
                ++i;
            }
            System.out.println(tab + "Projecting prefix = " + prefix);
            System.out.print(tab + "\tFound " + pairs.size() + " frequent items in this projection\n");
        }
        for (Pair pair : pairs) {
            if ((long)pair.getSupport() < this.minSupportAbsolute) continue;
            Pattern newPrefix = prefix.clonePattern();
            ItemAbstractionPair newPair = pairCreator.getItemAbstractionPair(pair.getPair().getItem(), this.abstractionCreator.createAbstractionFromAPrefix(prefix, pair.getPair().getAbstraction()));
            newPrefix.add(newPair);
            PseudoSequenceDatabase projection = this.makePseudoProjections(pair.getPair().getItem(), context, pair.getPair().getAbstraction(), false);
            newPrefix.setAppearingIn((BitSet)pair.getSequencesID().clone());
            if (keepPatterns) {
                this.saver.savePattern(newPrefix);
            }
            ++this.numberOfFrequentPatterns;
            if (projection == null || (long)projection.size() < this.minSupportAbsolute) continue;
            this.prefixSpanLoop(newPrefix, k + 1, projection, keepPatterns, verbose);
        }
    }

    public int numberOfFrequentPatterns() {
        return this.numberOfFrequentPatterns;
    }

    public void clear() {
        if (this.saver != null) {
            this.saver.clear();
            this.saver = null;
        }
        if (this.pseudoDatabase != null) {
            this.pseudoDatabase.clear();
            this.pseudoDatabase = null;
        }
        if (this.mapSequenceID != null) {
            this.mapSequenceID.clear();
            this.mapSequenceID = null;
        }
    }
}

